/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.calculator;

import java.util.Vector;
import org.statcato.calculator.CompUnit;
import org.statcato.calculator.MathFunction;
import org.statcato.calculator.MathOperations;
import org.statcato.calculator.Token;
import org.statcato.calculator.TokenScanner;
import org.statcato.spreadsheet.Cell;
import org.statcato.spreadsheet.Spreadsheet;
import org.statcato.utils.HelperFunctions;

public class MathExpParserComplete {
    private TokenScanner scanner;
    private final boolean debug = false;
    private Spreadsheet spreadsheet;
    private boolean isRadian = true;

    public MathExpParserComplete(Spreadsheet sp) {
        this.spreadsheet = sp;
    }

    public CompUnit parse(String exp, boolean isRadian) {
        this.scanner = new TokenScanner(exp, this.spreadsheet);
        this.isRadian = isRadian;
        this.print("\nparsing " + exp);
        CompUnit result = this.S();
        this.print("result = " + result);
        return result;
    }

    public String getError() {
        return this.scanner.error;
    }

    public CompUnit S() {
        this.print("S:");
        CompUnit value = this.E();
        if (this.scanner.getToken() != 14) {
            this.print("token=" + this.scanner.getToken());
            this.scanner.error("Expression syntax error: unexpected " + Token.toString(this.scanner.getToken()) + " found");
            return null;
        }
        this.print("last token = " + Token.toString(this.scanner.getToken()));
        this.print("S = " + value);
        return value;
    }

    private CompUnit E() {
        this.print("  E:");
        CompUnit left = this.T();
        if (left == null) {
            return null;
        }
        this.print("  Left = " + left);
        int op = this.scanner.getToken();
        while (op == 0 || op == 1) {
            this.scanner.consumeToken();
            CompUnit right = this.T();
            if (right == null) {
                return null;
            }
            this.print("  op = " + op + ", right = " + right);
            switch (op) {
                case 0: {
                    left = MathOperations.add(left, right);
                    break;
                }
                case 1: {
                    left = MathOperations.subtract(left, right);
                }
            }
            op = this.scanner.getToken();
        }
        this.print("  E = " + left);
        return left;
    }

    private CompUnit T() {
        this.print("    T:");
        CompUnit left = this.F();
        if (left == null) {
            return null;
        }
        this.print("    left = " + left);
        int op = this.scanner.getToken();
        while (op == 2 || op == 3) {
            this.scanner.consumeToken();
            CompUnit right = this.F();
            if (right == null) {
                return null;
            }
            this.print("    op = " + op + ", right = " + right);
            switch (op) {
                case 2: {
                    left = MathOperations.multiply(left, right);
                    break;
                }
                case 3: {
                    left = MathOperations.divide(left, right);
                }
            }
            op = this.scanner.getToken();
        }
        this.print("    T = " + left);
        return left;
    }

    private CompUnit F() {
        this.print("      F:");
        CompUnit left = this.P();
        if (left == null) {
            return null;
        }
        this.print("      left = " + left);
        while (this.scanner.getToken() == 4) {
            this.scanner.consumeToken();
            CompUnit right = this.F();
            this.print("      right = " + right);
            if (right == null) {
                return null;
            }
            left = MathOperations.power(left, right);
        }
        this.print("      F = " + left);
        return left;
    }

    private CompUnit P() {
        this.print("        P:");
        CompUnit unit = null;
        int token = this.scanner.getToken();
        this.print("token type = " + Token.toString(token));
        switch (token) {
            case 8: {
                double num = this.scanner.consumeNumber();
                unit = new CompUnit(8, num);
                this.print("        P is number");
                break;
            }
            case 10: {
                int col = this.scanner.consumeColumn();
                Vector<Cell> column = this.spreadsheet.getColumn(col);
                Vector<Double> value = HelperFunctions.ConvertInputVectorToDoubles(column);
                if (value != null) {
                    value = HelperFunctions.removeEndingNullValues(value);
                    unit = new CompUnit(10, value);
                    this.print("        P is column");
                    break;
                }
                this.scanner.error("invalid column input");
                break;
            }
            case 6: {
                this.scanner.consumeToken();
                this.print("        P is (E)");
                unit = this.E();
                if (this.scanner.getToken() != 7) {
                    this.scanner.error("        Missing )");
                    break;
                }
                this.scanner.consumeToken();
                break;
            }
            case 1: {
                this.scanner.consumeToken();
                this.print("        P is -T");
                unit = MathOperations.negate(this.T());
                break;
            }
            case 12: {
                double num = this.scanner.consumeConstant();
                unit = new CompUnit(8, num);
                this.print("        P is a constant");
                break;
            }
            case 9: {
                int function = this.scanner.consumeFunction();
                if (this.scanner.getToken() != 6) {
                    this.scanner.error("        function name must be followed by (");
                    break;
                }
                this.scanner.consumeToken();
                CompUnit argument = this.E();
                if (argument == null) break;
                this.print("        P is f(E)");
                if (this.scanner.getToken() != 7) {
                    this.scanner.error("        missing ) after function argument");
                    break;
                }
                switch (function) {
                    case 0: {
                        this.print("sin of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(0, this.isRadian));
                        break;
                    }
                    case 1: {
                        this.print("cos of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(1, this.isRadian));
                        break;
                    }
                    case 2: {
                        this.print("exp of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(2, this.isRadian));
                        break;
                    }
                    case 3: {
                        this.print("abs of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(3, this.isRadian));
                        break;
                    }
                    case 4: {
                        this.print("tan of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(4, this.isRadian));
                        break;
                    }
                    case 5: {
                        this.print("acos of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(5, this.isRadian));
                        break;
                    }
                    case 6: {
                        this.print("asin of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(6, this.isRadian));
                        break;
                    }
                    case 7: {
                        this.print("atan of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(7, this.isRadian));
                        break;
                    }
                    case 8: {
                        this.print("ceil of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(8, this.isRadian));
                        break;
                    }
                    case 9: {
                        this.print("floor of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(9, this.isRadian));
                        break;
                    }
                    case 10: {
                        this.print("log of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(10, this.isRadian));
                        break;
                    }
                    case 11: {
                        this.print("round of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(11, this.isRadian));
                        break;
                    }
                    case 12: {
                        this.print("sqrt of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(12, this.isRadian));
                        break;
                    }
                    case 13: {
                        this.print("ln of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(13, this.isRadian));
                        break;
                    }
                    case 14: {
                        this.print("factorial of " + argument);
                        unit = MathOperations.functionCall(argument, new MathFunction(14, this.isRadian));
                    }
                }
                this.scanner.consumeToken();
                break;
            }
        }
        this.print("        P = " + unit);
        if (unit == null) {
            this.scanner.error("Unexpected token");
        }
        return unit;
    }

    private void print(String msg) {
    }
}

