/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import sharptools.CellRange;
import sharptools.HistoDialog;
import sharptools.HistoPanel;
import sharptools.Histogram;
import sharptools.ParserException;
import sharptools.SharpTableModel;
import sharptools.SharpTools;

public class TabPanel
extends JPanel {
    private Histogram owner;
    private SharpTableModel model;
    private JTabbedPane tab;
    private HistoPanel histo;
    private CellRange range;
    private Float startvalue;
    private Float endvalue;
    private Float bucketvalue;
    private Float xmin;
    private Float xmax;
    private Float ymin;
    private Float ymax;
    private Float xunit;
    private Float yunit;
    private boolean bypercentage = true;

    TabPanel(SharpTableModel tableModel, CellRange range, Histogram frame, JTabbedPane pane) {
        this.owner = frame;
        this.model = tableModel;
        this.tab = pane;
        this.range = range;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.histo = new HistoPanel();
        this.histo.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.histo, "Center");
        JPanel south = new JPanel();
        south.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        south.setLayout(new FlowLayout(1, 10, 0));
        JButton closeButton = new JButton("Remove", SharpTools.getImageIcon("no.gif"));
        closeButton.setMnemonic(82);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabPanel.this.tab.remove(TabPanel.this.tab.getSelectedComponent());
                if (TabPanel.this.tab.getTabCount() == 0) {
                    TabPanel.this.owner.hide();
                }
            }
        });
        JButton optionButton = new JButton("Options...", SharpTools.getImageIcon("options.gif"));
        optionButton.setMnemonic(79);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabPanel.this.getOptions(false);
            }
        });
        JButton updateButton = new JButton("Update", SharpTools.getImageIcon("refresh.gif"));
        updateButton.setMnemonic(85);
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabPanel.this.updateData();
                TabPanel.this.histo.paintImmediately(0, 0, TabPanel.this.histo.getWidth(), TabPanel.this.histo.getHeight());
            }
        });
        south.add(updateButton);
        south.add(optionButton);
        south.add(closeButton);
        this.add((Component)south, "South");
    }

    void getOptions(boolean firstTime) {
        HistoDialog option = new HistoDialog(this.owner);
        option.pack();
        option.setLocationRelativeTo(this.owner);
        option.setTitleField(this.tab.getTitleAt(this.tab.getSelectedIndex()));
        if (firstTime) {
            option.setCellRange(this.range);
            float[] minmax = TabPanel.getValueMinMax(this.model, this.range);
            int min = (int)minmax[0];
            int max = (int)minmax[1];
            this.startvalue = new Float(min);
            this.endvalue = new Float(max);
            int power = 0;
            if (max > min) {
                power = (int)(Math.log(max - min) / Math.log(10.0));
            }
            if (power < 0) {
                --power;
            }
            this.xunit = this.bucketvalue = new Float(Math.pow(10.0, power));
            this.xmin = new Float(min);
            this.xmax = new Float(max);
            this.ymin = new Float(0.0f);
            this.ymax = new Float(100.0f);
            this.yunit = new Float(10.0f);
        }
        option.setCellRange(this.range);
        option.setStartValue(this.startvalue);
        option.setEndValue(this.endvalue);
        option.setBucket(this.bucketvalue);
        option.setXMin(this.xmin);
        option.setXMax(this.xmax);
        option.setXUnit(this.xunit);
        option.setYMin(this.ymin);
        option.setYMax(this.ymax);
        option.setYUnit(this.yunit);
        option.setByPercentage(this.bypercentage);
        option.setVisible(true);
        if (!option.isCancelled()) {
            this.tab.setTitleAt(this.tab.getSelectedIndex(), option.getTitleField());
            this.range = option.getCellRange();
            this.startvalue = option.getStartValue();
            this.endvalue = option.getEndValue();
            this.bucketvalue = option.getBucket();
            this.xmin = option.getXMin();
            this.xmax = option.getXMax();
            this.ymin = option.getYMin();
            this.ymax = option.getYMax();
            this.xunit = option.getXUnit();
            this.yunit = option.getYUnit();
            this.bypercentage = option.getByPercentage();
            this.update();
        }
    }

    static float[] getValueMinMax(SharpTableModel model, CellRange range) {
        float[] values = new float[]{Float.MAX_VALUE, Float.MIN_VALUE};
        for (int i = range.getStartRow(); i <= range.getEndRow(); ++i) {
            for (int j = range.getStartCol(); j <= range.getEndCol(); ++j) {
                float v;
                try {
                    v = model.getNumericValueAt(i, j).floatValue();
                }
                catch (ParserException e) {
                    v = 0.0f;
                }
                values[0] = Math.min(values[0], v);
                values[1] = Math.max(values[1], v);
            }
        }
        return values;
    }

    public void update() {
        float bucket;
        float start = this.startvalue.floatValue();
        float end = this.endvalue.floatValue();
        float nb = (end - start) / (bucket = this.bucketvalue.floatValue());
        int nbars = (int)nb;
        if (nbars > nbars) {
            ++nbars;
        }
        float[] data = new float[nbars += 2];
        this.histo.setData(data);
        this.updateData();
        this.histo.setStartEndPoints(start, end, bucket);
        this.histo.setXYAxis(this.xmin.floatValue(), this.xmax.floatValue(), this.xunit.floatValue(), this.ymin.floatValue(), this.ymax.floatValue(), this.yunit.floatValue());
        this.histo.setByPercentage(this.bypercentage);
        this.histo.paintImmediately(0, 0, this.histo.getWidth(), this.histo.getHeight());
    }

    private void updateData() {
        float start = this.startvalue.floatValue();
        float end = this.endvalue.floatValue();
        float bucket = this.bucketvalue.floatValue();
        float[] data = this.histo.getData();
        for (int k = 0; k < data.length; ++k) {
            data[k] = 0.0f;
        }
        for (int i = this.range.getStartRow(); i <= this.range.getEndRow(); ++i) {
            for (int j = this.range.getStartCol(); j <= this.range.getEndCol(); ++j) {
                int index;
                float value = 0.0f;
                try {
                    value = this.model.getNumericValueAt(i, j).floatValue();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (value < start) {
                    data[0] = data[0] + 1.0f;
                    continue;
                }
                if (value > end) {
                    int n = data.length - 1;
                    data[n] = data[n] + 1.0f;
                    continue;
                }
                int n = index = (int)((value - start) / bucket) + 1;
                data[n] = data[n] + 1.0f;
            }
        }
        if (this.bypercentage) {
            int nums = this.range.getWidth() * this.range.getHeight();
            for (int k = 0; k < data.length; ++k) {
                data[k] = data[k] * 100.0f / (float)nums;
            }
        }
    }
}

