/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphCoverageMapping;
import org.apache.fop.complexscripts.fonts.GlyphMappingTable;

public final class GlyphCoverageTable
extends GlyphMappingTable
implements GlyphCoverageMapping {
    private static final Log log = LogFactory.getLog(GlyphCoverageTable.class);
    public static final int GLYPH_COVERAGE_TYPE_EMPTY = 0;
    public static final int GLYPH_COVERAGE_TYPE_MAPPED = 1;
    public static final int GLYPH_COVERAGE_TYPE_RANGE = 2;
    private GlyphCoverageMapping cm;

    private GlyphCoverageTable(GlyphCoverageMapping cm) {
        assert (cm != null);
        assert (cm instanceof GlyphMappingTable);
        this.cm = cm;
    }

    public int getType() {
        return ((GlyphMappingTable)((Object)this.cm)).getType();
    }

    public List getEntries() {
        return ((GlyphMappingTable)((Object)this.cm)).getEntries();
    }

    public int getCoverageSize() {
        return this.cm.getCoverageSize();
    }

    public int getCoverageIndex(int gid) {
        return this.cm.getCoverageIndex(gid);
    }

    public static GlyphCoverageTable createCoverageTable(List entries) {
        GlyphMappingTable cm = entries == null || entries.size() == 0 ? new EmptyCoverageTable(entries) : (GlyphCoverageTable.isMappedCoverage(entries) ? new MappedCoverageTable(entries) : (GlyphCoverageTable.isRangeCoverage(entries) ? new RangeCoverageTable(entries) : null));
        assert (cm != null) : "unknown coverage type";
        return new GlyphCoverageTable((GlyphCoverageMapping)((Object)cm));
    }

    private static boolean isMappedCoverage(List entries) {
        if (entries == null || entries.size() == 0) {
            return false;
        }
        for (Object o : entries) {
            if (o instanceof Integer) continue;
            return false;
        }
        return true;
    }

    private static boolean isRangeCoverage(List entries) {
        if (entries == null || entries.size() == 0) {
            return false;
        }
        for (Object o : entries) {
            if (o instanceof GlyphMappingTable.MappingRange) continue;
            return false;
        }
        return true;
    }

    private static class RangeCoverageTable
    extends GlyphMappingTable.RangeMappingTable
    implements GlyphCoverageMapping {
        public RangeCoverageTable(List entries) {
            super(entries);
        }

        public int getMappedIndex(int gid, int s, int m) {
            return m + gid - s;
        }

        public int getCoverageSize() {
            return this.getMappingSize();
        }

        public int getCoverageIndex(int gid) {
            return this.getMappedIndex(gid);
        }
    }

    private static class MappedCoverageTable
    extends GlyphMappingTable.MappedMappingTable
    implements GlyphCoverageMapping {
        private int[] map;

        public MappedCoverageTable(List entries) {
            this.populate(entries);
        }

        public List getEntries() {
            ArrayList<Integer> entries = new ArrayList<Integer>();
            if (this.map != null) {
                int n = this.map.length;
                for (int i = 0; i < n; ++i) {
                    entries.add(this.map[i]);
                }
            }
            return entries;
        }

        public int getMappingSize() {
            return this.map != null ? this.map.length : 0;
        }

        public int getMappedIndex(int gid) {
            int i = Arrays.binarySearch(this.map, gid);
            if (i >= 0) {
                return i;
            }
            return -1;
        }

        public int getCoverageSize() {
            return this.getMappingSize();
        }

        public int getCoverageIndex(int gid) {
            return this.getMappedIndex(gid);
        }

        private void populate(List entries) {
            int i = 0;
            int skipped = 0;
            int n = entries.size();
            int gidMax = -1;
            int[] map = new int[n];
            for (Object o : entries) {
                if (o instanceof Integer) {
                    int gid = (Integer)o;
                    if (gid >= 0 && gid < 65536) {
                        if (gid > gidMax) {
                            map[i++] = gidMax = gid;
                            continue;
                        }
                        log.info("ignoring out of order or duplicate glyph index: " + gid);
                        ++skipped;
                        continue;
                    }
                    throw new AdvancedTypographicTableFormatException("illegal glyph index: " + gid);
                }
                throw new AdvancedTypographicTableFormatException("illegal coverage entry, must be Integer: " + o);
            }
            assert (i + skipped == n);
            assert (this.map == null);
            this.map = map;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            int n = this.map.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(Integer.toString(this.map[i]));
            }
            sb.append('}');
            return sb.toString();
        }
    }

    private static class EmptyCoverageTable
    extends GlyphMappingTable.EmptyMappingTable
    implements GlyphCoverageMapping {
        public EmptyCoverageTable(List entries) {
            super(entries);
        }

        public int getCoverageSize() {
            return 0;
        }

        public int getCoverageIndex(int gid) {
            return -1;
        }
    }
}

