/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import jscl.math.Literal;
import jscl.math.NotDivisibleException;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Pow;
import jscl.math.polynomial.BooleanMonomial;
import jscl.math.polynomial.DefinedBooleanMonomial;
import jscl.math.polynomial.DegreeReverseLexicographic;
import jscl.math.polynomial.KthElimination;
import jscl.math.polynomial.Lexicographic;
import jscl.math.polynomial.MonomialDivisor;
import jscl.math.polynomial.MonomialIterator;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.SmallMonomial;
import jscl.math.polynomial.TotalDegreeLexicographic;
import jscl.mathml.MathML;

public class Monomial
implements Comparable {
    public static final Ordering lexicographic = Lexicographic.ordering;
    public static final Ordering totalDegreeLexicographic = TotalDegreeLexicographic.ordering;
    public static final Ordering degreeReverseLexicographic = DegreeReverseLexicographic.ordering;
    public static final Ordering iteratorOrdering = totalDegreeLexicographic;
    final Variable[] unknown;
    final Ordering ordering;
    final int[] element;
    int degree;

    Monomial(Variable[] unknown, Ordering ordering) {
        this(unknown.length, unknown, ordering);
    }

    Monomial(int length, Variable[] unknown, Ordering ordering) {
        this.unknown = unknown;
        this.ordering = ordering;
        this.element = new int[length];
    }

    public static Ordering kthElimination(int k) {
        return new KthElimination(k, 1);
    }

    public Variable[] unknown() {
        return this.unknown;
    }

    public Ordering ordering() {
        return this.ordering;
    }

    public Monomial multiply(Monomial monomial) {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            m.element[i] = this.element[i] + monomial.element[i];
        }
        m.degree = this.degree + monomial.degree;
        return m;
    }

    public boolean multiple(Monomial monomial) {
        return this.multiple(monomial, false);
    }

    public boolean multiple(Monomial monomial, boolean strict) {
        boolean equal = true;
        for (int i = 0; i < this.unknown.length; ++i) {
            if (this.element[i] < monomial.element[i]) {
                return false;
            }
            equal &= this.element[i] == monomial.element[i];
        }
        return strict ? !equal : true;
    }

    public Monomial divide(Monomial monomial) throws ArithmeticException {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = this.element[i] - monomial.element[i];
            if (n < 0) {
                throw new NotDivisibleException();
            }
            m.element[i] = n;
        }
        m.degree = this.degree - monomial.degree;
        return m;
    }

    public Monomial gcd(Monomial monomial) {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n;
            m.element[i] = n = Math.min(this.element[i], monomial.element[i]);
            m.degree += n;
        }
        return m;
    }

    public Monomial scm(Monomial monomial) {
        Monomial m = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n;
            m.element[i] = n = Math.max(this.element[i], monomial.element[i]);
            m.degree += n;
        }
        return m;
    }

    public int degree() {
        return this.degree;
    }

    public Monomial valueof(Monomial monomial) {
        Monomial m = this.newinstance();
        System.arraycopy(monomial.element, 0, m.element, 0, m.element.length);
        m.degree = monomial.degree;
        return m;
    }

    public Monomial valueof(Literal literal) {
        Monomial m = this.newinstance();
        m.init(literal);
        return m;
    }

    public Literal literalValue() {
        return Literal.valueOf(this);
    }

    public int element(int n) {
        return this.element[n];
    }

    public Iterator iterator() {
        return this.iterator(this.newinstance());
    }

    public Iterator iterator(Monomial beginning) {
        return new MonomialIterator(beginning, this);
    }

    public Iterator divisor() {
        return this.divisor(this.newinstance());
    }

    public Iterator divisor(Monomial beginning) {
        return new MonomialDivisor(beginning, this);
    }

    static Monomial factory(Variable[] unknown) {
        return Monomial.factory(unknown, lexicographic);
    }

    static Monomial factory(Variable[] unknown, Ordering ordering) {
        return Monomial.factory(unknown, ordering, 0);
    }

    static Monomial factory(Variable[] unknown, Ordering ordering, int power_size) {
        switch (power_size) {
            case 16: {
                return new SmallMonomial(unknown, Monomial.small(ordering));
            }
            case 32: {
                return new BooleanMonomial(unknown, Monomial.small(ordering));
            }
            case 48: {
                return new DefinedBooleanMonomial(unknown, Monomial.small(ordering));
            }
        }
        return new Monomial(unknown, ordering);
    }

    static Ordering small(Ordering ordering) {
        if (ordering == lexicographic) {
            return SmallMonomial.lexicographic;
        }
        if (ordering == totalDegreeLexicographic) {
            return SmallMonomial.totalDegreeLexicographic;
        }
        if (ordering == degreeReverseLexicographic) {
            return SmallMonomial.degreeReverseLexicographic;
        }
        throw new UnsupportedOperationException();
    }

    public int compareTo(Monomial monomial) {
        return this.ordering.compare(this, monomial);
    }

    public int compareTo(Object o) {
        return this.compareTo((Monomial)o);
    }

    void init(Literal literal) {
        int s = literal.size();
        for (int i = 0; i < s; ++i) {
            Variable v = literal.variable(i);
            int c = literal.power(i);
            int n = Monomial.variable(v, this.unknown);
            if (n >= this.unknown.length) continue;
            this.put(n, c);
        }
    }

    static int variable(Variable v, Variable[] unknown) {
        int i;
        for (i = 0; i < unknown.length && !unknown[i].equals(v); ++i) {
        }
        return i;
    }

    void put(int n, int integer) {
        int n2 = n;
        this.element[n2] = this.element[n2] + integer;
        this.degree += integer;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.degree == 0) {
            buffer.append("1");
        }
        boolean b = false;
        for (int i = 0; i < this.unknown.length; ++i) {
            int c = this.element(i);
            if (c <= 0) continue;
            if (b) {
                buffer.append("*");
            } else {
                b = true;
            }
            Variable v = this.unknown[i];
            if (c == 1) {
                buffer.append(v);
                continue;
            }
            if (v instanceof Frac || v instanceof Pow) {
                buffer.append("(").append(v).append(")");
            } else {
                buffer.append(v);
            }
            buffer.append("^").append(c);
        }
        return buffer.toString();
    }

    public void toMathML(MathML element, Object data) {
        if (this.degree == 0) {
            MathML e1 = element.element("mn");
            e1.appendChild(element.text("1"));
            element.appendChild(e1);
        }
        for (int i = 0; i < this.unknown.length; ++i) {
            int c = this.element(i);
            if (c <= 0) continue;
            this.unknown[i].toMathML(element, new Integer(c));
        }
    }

    protected Monomial newinstance() {
        return new Monomial(this.element.length, this.unknown, this.ordering);
    }
}

