/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Antiderivative;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Algebraic;
import jscl.math.function.Constant;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.math.function.Root;
import jscl.mathml.MathML;

public class Sqrt
extends Algebraic {
    public Sqrt(Generic generic) {
        super("sqrt", new Generic[]{generic});
    }

    @Override
    public Root rootValue() {
        return new Root(new Generic[]{this.parameter[0].negate(), JSCLInteger.valueOf(0L), JSCLInteger.valueOf(1L)}, 0);
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        Root r = this.rootValue();
        Generic[] g = r.parameters();
        if (g[0].isPolynomial(variable)) {
            return Antiderivative.compute(r, variable);
        }
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(int n) {
        return Constant.half.multiply(new Inv(this.evaluate()).evaluate());
    }

    public boolean imaginary() {
        return this.parameter[0].compareTo(JSCLInteger.valueOf(-1L)) == 0;
    }

    @Override
    public Generic evaluate() {
        try {
            JSCLInteger rt;
            JSCLInteger en = this.parameter[0].integerValue();
            if (en.signum() >= 0 && ((Generic)(rt = en.sqrt())).pow(2).compareTo(en) == 0) {
                return rt;
            }
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return this.evaluate();
    }

    @Override
    public Generic evalsimp() {
        try {
            JSCLInteger en = this.parameter[0].integerValue();
            if (en.signum() < 0) {
                return Constant.i.multiply(new Sqrt(en.negate()).evalsimp());
            }
            JSCLInteger rt = en.sqrt();
            if (((Generic)rt).pow(2).compareTo(en) == 0) {
                return rt;
            }
            Generic a = en.factorize();
            Generic[] p = a.productValue();
            Generic s = JSCLInteger.valueOf(1L);
            for (int i = 0; i < p.length; ++i) {
                Power o = p[i].powerValue();
                Generic q = o.value(true);
                int c = o.exponent();
                s = ((Generic)s).multiply(q.pow(c / 2).multiply(new Sqrt(q).expressionValue().pow(c % 2)));
            }
            return s;
        }
        catch (NotIntegerException e) {
            Generic[] n = Frac.separateCoefficient(this.parameter[0]);
            if (n[0].compareTo(JSCLInteger.valueOf(1L)) != 0 || n[1].compareTo(JSCLInteger.valueOf(1L)) != 0) {
                return new Sqrt(n[2]).evalsimp().multiply(new Frac(new Sqrt(n[0]).evalsimp(), new Sqrt(n[1]).evalsimp()).evalsimp());
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).sqrt();
    }

    @Override
    public String toJava() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(-1L)) == 0) {
            return "Complex.valueOf(0, 1)";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parameter[0].toJava());
        buffer.append(".").append(this.name).append("()");
        return buffer.toString();
    }

    @Override
    void bodyToMathML(MathML element, boolean fenced) {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(-1L)) == 0) {
            MathML e1 = element.element("mi");
            e1.appendChild(element.text("i"));
            element.appendChild(e1);
        } else {
            MathML e1 = element.element("msqrt");
            this.parameter[0].toMathML(e1, null);
            element.appendChild(e1);
        }
    }

    @Override
    protected Variable newinstance() {
        return new Sqrt(null);
    }
}

