/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Antiderivative;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Algebraic;
import jscl.math.function.Constant;
import jscl.math.function.Inv;
import jscl.math.function.Root;
import jscl.mathml.MathML;

public class Cubic
extends Algebraic {
    public Cubic(Generic generic) {
        super("cubic", new Generic[]{generic});
    }

    @Override
    public Root rootValue() {
        return new Root(new Generic[]{this.parameter[0].negate(), JSCLInteger.valueOf(0L), JSCLInteger.valueOf(0L), JSCLInteger.valueOf(1L)}, 0);
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        Root r = this.rootValue();
        Generic[] g = r.parameters();
        if (g[0].isPolynomial(variable)) {
            return Antiderivative.compute(r, variable);
        }
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(int n) {
        return Constant.third.multiply(new Inv(this.evaluate().pow(2)).evaluate());
    }

    @Override
    public Generic evaluate() {
        try {
            JSCLInteger rt;
            JSCLInteger en = this.parameter[0].integerValue();
            if (en.signum() >= 0 && ((Generic)(rt = en.nthrt(3))).pow(3).compareTo(en) == 0) {
                return rt;
            }
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return this.evaluate();
    }

    @Override
    public Generic evalsimp() {
        try {
            JSCLInteger en = this.parameter[0].integerValue();
            if (en.signum() < 0) {
                return new Cubic(en.negate()).evalsimp().negate();
            }
            JSCLInteger rt = en.nthrt(3);
            if (((Generic)rt).pow(3).compareTo(en) == 0) {
                return rt;
            }
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).nthrt(3);
    }

    @Override
    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.parameter[0].toJava());
        buffer.append(".pow(");
        buffer.append(Constant.third.toJava());
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    void bodyToMathML(MathML element, boolean fenced) {
        MathML e1 = element.element("mroot");
        this.parameter[0].toMathML(e1, null);
        JSCLInteger.valueOf(3L).toMathML(e1, null);
        element.appendChild(e1);
    }

    @Override
    protected Variable newinstance() {
        return new Cubic(null);
    }
}

