/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.NotDivisibleException;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Conjugate;
import jscl.math.function.Frac;
import jscl.math.function.trigonometric.Cos;
import jscl.math.function.trigonometric.Sin;
import jscl.mathml.MathML;
import jscl.util.ArrayComparator;

public class Matrix
extends Generic {
    protected final Generic[][] element;
    protected final int n;
    protected final int p;

    public Matrix(Generic[][] element) {
        this.element = element;
        this.n = element.length;
        this.p = element.length > 0 ? element[0].length : 0;
    }

    public Generic[][] elements() {
        return this.element;
    }

    public Matrix add(Matrix matrix) {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].add(matrix.element[i][j]);
            }
        }
        return m;
    }

    @Override
    public Generic add(Generic generic) {
        if (generic instanceof Matrix) {
            return this.add((Matrix)generic);
        }
        return this.add(this.valueof(generic));
    }

    public Matrix subtract(Matrix matrix) {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].subtract(matrix.element[i][j]);
            }
        }
        return m;
    }

    @Override
    public Generic subtract(Generic generic) {
        if (generic instanceof Matrix) {
            return this.subtract((Matrix)generic);
        }
        return this.subtract(this.valueof(generic));
    }

    public static boolean product(Generic a, Generic b) {
        return a instanceof Matrix && b instanceof Matrix || a instanceof Matrix && b instanceof JSCLVector || a instanceof JSCLVector && b instanceof Matrix;
    }

    public Matrix multiply(Matrix matrix) {
        if (this.p != matrix.n) {
            throw new ArithmeticException();
        }
        Matrix m = (Matrix)this.newinstance(new Generic[this.n][matrix.p]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < matrix.p; ++j) {
                m.element[i][j] = JSCLInteger.valueOf(0L);
                for (int k = 0; k < this.p; ++k) {
                    m.element[i][j] = m.element[i][j].add(this.element[i][k].multiply(matrix.element[k][j]));
                }
            }
        }
        return m;
    }

    @Override
    public Generic multiply(Generic generic) {
        if (generic instanceof Matrix) {
            return this.multiply((Matrix)generic);
        }
        if (generic instanceof JSCLVector) {
            JSCLVector v = (JSCLVector)((JSCLVector)generic).newinstance(new Generic[this.n]);
            JSCLVector v2 = (JSCLVector)generic;
            if (this.p != v2.n) {
                throw new ArithmeticException();
            }
            for (int i = 0; i < this.n; ++i) {
                v.element[i] = JSCLInteger.valueOf(0L);
                for (int k = 0; k < this.p; ++k) {
                    v.element[i] = v.element[i].add(this.element[i][k].multiply(v2.element[k]));
                }
            }
            return v;
        }
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].multiply(generic);
            }
        }
        return m;
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof Matrix) {
            return this.multiply(((Matrix)generic).inverse());
        }
        if (generic instanceof JSCLVector) {
            throw new ArithmeticException();
        }
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                try {
                    m.element[i][j] = this.element[i][j].divide(generic);
                    continue;
                }
                catch (NotDivisibleException e) {
                    m.element[i][j] = new Frac(this.element[i][j], generic).evaluate();
                }
            }
        }
        return m;
    }

    @Override
    public Generic gcd(Generic generic) {
        return null;
    }

    @Override
    public Generic gcd() {
        return null;
    }

    @Override
    public Generic negate() {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].negate();
            }
        }
        return m;
    }

    @Override
    public int signum() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                int c = this.element[i][j].signum();
                if (c < 0) {
                    return -1;
                }
                if (c <= 0) continue;
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int degree() {
        return 0;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].antiderivative(variable);
            }
        }
        return m;
    }

    @Override
    public Generic derivative(Variable variable) {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].derivative(variable);
            }
        }
        return m;
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].substitute(variable, generic);
            }
        }
        return m;
    }

    @Override
    public Generic expand() {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].expand();
            }
        }
        return m;
    }

    @Override
    public Generic factorize() {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].factorize();
            }
        }
        return m;
    }

    @Override
    public Generic elementary() {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].elementary();
            }
        }
        return m;
    }

    @Override
    public Generic simplify() {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = this.element[i][j].simplify();
            }
        }
        return m;
    }

    @Override
    public Generic numeric() {
        return new NumericWrapper(this);
    }

    @Override
    public Generic valueof(Generic generic) {
        if (generic instanceof Matrix || generic instanceof JSCLVector) {
            throw new ArithmeticException();
        }
        Matrix m = (Matrix)Matrix.identity(this.n, this.p).multiply(generic);
        return this.newinstance(m.element);
    }

    @Override
    public Generic[] sumValue() {
        return new Generic[]{this};
    }

    @Override
    public Generic[] productValue() throws NotProductException {
        return new Generic[]{this};
    }

    @Override
    public Power powerValue() throws NotPowerException {
        return new Power(this, 1);
    }

    @Override
    public Expression expressionValue() throws NotExpressionException {
        throw new NotExpressionException();
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        throw new NotIntegerException();
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        throw new NotVariableException();
    }

    @Override
    public Variable[] variables() {
        return null;
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        return false;
    }

    @Override
    public boolean isConstant(Variable variable) {
        return false;
    }

    public Generic[] vectors() {
        Generic[] v = new JSCLVector[this.n];
        for (int i = 0; i < this.n; ++i) {
            v[i] = new JSCLVector(new Generic[this.p]);
            for (int j = 0; j < this.p; ++j) {
                ((JSCLVector)v[i]).element[j] = this.element[i][j];
            }
        }
        return v;
    }

    public Generic tensorProduct(Matrix matrix) {
        Matrix m = (Matrix)this.newinstance(new Generic[this.n * matrix.n][this.p * matrix.p]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                for (int k = 0; k < matrix.n; ++k) {
                    for (int l = 0; l < matrix.p; ++l) {
                        m.element[i * matrix.n + k][j * matrix.p + l] = this.element[i][j].multiply(matrix.element[k][l]);
                    }
                }
            }
        }
        return m;
    }

    public Generic transpose() {
        Matrix m = (Matrix)this.newinstance(new Generic[this.p][this.n]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[j][i] = this.element[i][j];
            }
        }
        return m;
    }

    public Generic trace() {
        Generic s = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.n; ++i) {
            s = ((Generic)s).add(this.element[i][i]);
        }
        return s;
    }

    @Override
    public Generic inverse() {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                m.element[i][j] = this.inverseElement(i, j);
            }
        }
        return m.transpose().divide(this.determinant());
    }

    Generic inverseElement(int k, int l) {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                m.element[i][j] = i == k ? JSCLInteger.valueOf(j == l ? 1L : 0L) : this.element[i][j];
            }
        }
        return m.determinant();
    }

    public Generic determinant() {
        if (this.n > 1) {
            Generic a = JSCLInteger.valueOf(0L);
            for (int i = 0; i < this.n; ++i) {
                if (this.element[i][0].signum() == 0) continue;
                Matrix m = (Matrix)this.newinstance(new Generic[this.n - 1][this.n - 1]);
                for (int j = 0; j < this.n - 1; ++j) {
                    for (int k = 0; k < this.n - 1; ++k) {
                        m.element[j][k] = this.element[j < i ? j : j + 1][k + 1];
                    }
                }
                a = i % 2 == 0 ? ((Generic)a).add(this.element[i][0].multiply(m.determinant())) : ((Generic)a).subtract(this.element[i][0].multiply(m.determinant()));
            }
            return a;
        }
        if (this.n > 0) {
            return this.element[0][0];
        }
        return JSCLInteger.valueOf(0L);
    }

    public Generic conjugate() {
        Matrix m = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                m.element[i][j] = new Conjugate(this.element[i][j]).evaluate();
            }
        }
        return m;
    }

    public int compareTo(Matrix matrix) {
        return ArrayComparator.comparator.compare(this.vectors(), matrix.vectors());
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof Matrix) {
            return this.compareTo((Matrix)generic);
        }
        return this.compareTo(this.valueof(generic));
    }

    public static Matrix identity(int dimension) {
        return Matrix.identity(dimension, dimension);
    }

    public static Matrix identity(int n, int p) {
        Matrix m = new Matrix(new Generic[n][p]);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < p; ++j) {
                m.element[i][j] = i == j ? JSCLInteger.valueOf(1L) : JSCLInteger.valueOf(0L);
            }
        }
        return m;
    }

    public static Matrix frame(JSCLVector[] vector) {
        Matrix m = new Matrix(new Generic[vector.length > 0 ? vector[0].n : 0][vector.length]);
        for (int i = 0; i < m.n; ++i) {
            for (int j = 0; j < m.p; ++j) {
                m.element[i][j] = vector[j].element[i];
            }
        }
        return m;
    }

    public static Matrix rotation(int dimension, int plane, Generic angle) {
        return Matrix.rotation(dimension, plane, 2, angle);
    }

    public static Matrix rotation(int dimension, int axis1, int axis2, Generic angle) {
        Matrix m = new Matrix(new Generic[dimension][dimension]);
        for (int i = 0; i < m.n; ++i) {
            for (int j = 0; j < m.p; ++j) {
                m.element[i][j] = i == axis1 && j == axis1 ? new Cos(angle).evaluate() : (i == axis1 && j == axis2 ? new Sin(angle).evaluate().negate() : (i == axis2 && j == axis1 ? new Sin(angle).evaluate() : (i == axis2 && j == axis2 ? new Cos(angle).evaluate() : (i == j ? JSCLInteger.valueOf(1L) : JSCLInteger.valueOf(0L)))));
            }
        }
        return m;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (int i = 0; i < this.n; ++i) {
            buffer.append("{");
            for (int j = 0; j < this.p; ++j) {
                buffer.append(this.element[i][j]).append(j < this.p - 1 ? ", " : "");
            }
            buffer.append("}").append(i < this.n - 1 ? ",\n" : "");
        }
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public String toJava() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new NumericMatrix(new Numeric[][] {");
        for (int i = 0; i < this.n; ++i) {
            buffer.append("{");
            for (int j = 0; j < this.p; ++j) {
                buffer.append(this.element[i][j].toJava()).append(j < this.p - 1 ? ", " : "");
            }
            buffer.append("}").append(i < this.n - 1 ? ", " : "");
        }
        buffer.append("})");
        return buffer.toString();
    }

    @Override
    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element);
        } else {
            MathML e1 = element.element("msup");
            this.bodyToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    protected void bodyToMathML(MathML e0) {
        MathML e1 = e0.element("mfenced");
        MathML e2 = e0.element("mtable");
        for (int i = 0; i < this.n; ++i) {
            MathML e3 = e0.element("mtr");
            for (int j = 0; j < this.p; ++j) {
                MathML e4 = e0.element("mtd");
                this.element[i][j].toMathML(e4, null);
                e3.appendChild(e4);
            }
            e2.appendChild(e3);
        }
        e1.appendChild(e2);
        e0.appendChild(e1);
    }

    protected Generic newinstance() {
        return this.newinstance(new Generic[this.n][this.p]);
    }

    protected Generic newinstance(Generic[][] element) {
        return new Matrix(element);
    }
}

