/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

class Clifford {
    int p;
    int n;
    int[][] operator;

    Clifford(int[] algebra) {
        this(algebra[0], algebra[1]);
    }

    Clifford(int p, int q) {
        this.p = p;
        this.n = p + q;
        int m = 1 << this.n;
        this.operator = new int[m][m];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                int a = Clifford.combination(i, this.n);
                int b = Clifford.combination(j, this.n);
                int c = a ^ b;
                int l = Clifford.location(c, this.n);
                boolean s = this.sign(a, b);
                int k = l + 1;
                this.operator[i][j] = s ? -k : k;
            }
        }
    }

    boolean sign(int a, int b) {
        boolean s = false;
        for (int i = 0; i < this.n; ++i) {
            if ((b & 1 << i) <= 0) continue;
            for (int j = i; j < this.n; ++j) {
                if ((a & 1 << j) <= 0 || j <= i && i < this.p) continue;
                s = !s;
            }
        }
        return s;
    }

    static int combination(int l, int n) {
        if (n <= 2) {
            return l;
        }
        int[] b = new int[1];
        int l1 = Clifford.decimation(l, n, b);
        int c = Clifford.combination(l1, n - 1);
        return (c << 1) + b[0];
    }

    static int location(int c, int n) {
        if (n <= 2) {
            return c;
        }
        int c1 = c >> 1;
        int b = c & 1;
        int l1 = Clifford.location(c1, n - 1);
        return Clifford.dilatation(l1, n, new int[]{b});
    }

    static int decimation(int l, int n, int[] b) {
        int p = Clifford.grade(l, n - 1, 1);
        int p1 = p + 1 >> 1;
        b[0] = p & 1;
        return l - Clifford.sum(p1, n - 1);
    }

    static int dilatation(int l, int n, int[] b) {
        int p1 = Clifford.grade(l, n - 1);
        return l + Clifford.sum(p1 + b[0], n - 1);
    }

    static int grade(int l, int n) {
        return Clifford.grade(l, n, 0);
    }

    static int grade(int l, int n, int d) {
        int s = 0;
        int p = 0;
        while ((s += Clifford.binomial(n, p >> d)) <= l) {
            ++p;
        }
        return p;
    }

    static int sum(int p, int n) {
        int q = 0;
        int s = 0;
        while (q < p) {
            s += Clifford.binomial(n, q++);
        }
        return s;
    }

    static int binomial(int n, int p) {
        int i;
        int a = 1;
        int b = 1;
        for (i = n - p + 1; i <= n; ++i) {
            a *= i;
        }
        for (i = 2; i <= p; ++i) {
            b *= i;
        }
        return a / b;
    }

    static int log2e(int n) {
        int i = 0;
        while (n > 1) {
            ++i;
            n >>= 1;
        }
        return i;
    }

    int[][] operator() {
        return this.operator;
    }
}

