/*
 * Decompiled with CFR 0.152.
 */
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Variable;
import jscl.text.ParseException;
import junit.framework.Test;
import junit.framework.TestSuite;

public class integralTest
extends test {
    public static Test suite() {
        return new TestSuite(integralTest.class);
    }

    public void test1() throws ParseException {
        String s = "root[0](1, 0, 4)*log(1-2*x*root[0](1, 0, 4))+root[1](1, 0, 4)*log(1-2*x*root[1](1, 0, 4))";
        integralTest.assertEquals((String)s, (String)integralTest.expand("integral(1/(1+x^2),x)"));
        integralTest.assertEquals((String)"1/(1+x^2)", (String)integralTest.simplify(integralTest.expand("d(" + s + ",x)")));
    }

    public void test2() throws ParseException {
        String s = "root[0](1, -3, 3)*log(1+x-root[0](1, -3, 3)-2*x*root[0](1, -3, 3))+root[1](1, -3, 3)*log(1+x-root[1](1, -3, 3)-2*x*root[1](1, -3, 3))";
        integralTest.assertEquals((String)s, (String)integralTest.expand("integral((1+x)/(1+x+x^2),x)"));
        integralTest.assertEquals((String)"(1+x)/(1+x+x^2)", (String)integralTest.simplify(integralTest.expand("d(" + s + ",x)")));
    }

    public void test3() throws ParseException {
        String s = "-1/-2*log(1+x^2)";
        integralTest.assertEquals((String)s, (String)integralTest.expand("integral(x/(1+x^2),x)"));
        integralTest.assertEquals((String)"x/(1+x^2)", (String)integralTest.simplify(integralTest.expand("d(" + s + ",x)")));
    }

    public void test4() throws ParseException {
        String s = "x-log(1+x)";
        integralTest.assertEquals((String)s, (String)integralTest.expand("integral(x/(1+x),x)"));
        integralTest.assertEquals((String)"x/(1+x)", (String)integralTest.simplify(integralTest.expand("d(" + s + ",x)")));
    }

    public void test5() throws ParseException {
        String s = "1/(1+x)+log(1+x)";
        integralTest.assertEquals((String)s, (String)integralTest.expand("integral(x/(1+x)^2,x)"));
        integralTest.assertEquals((String)"x/(1+2*x+x^2)", (String)integralTest.simplify(integralTest.expand("d(" + s + ",x)")));
        integralTest.assertEquals((String)"x/(1+2*x+x^2)", (String)integralTest.simplify(integralTest.expand("d(log(sqrt((1+x)^2))+1/(1+x),x)")));
        integralTest.assertEquals((String)"x/(1+x)^2", (String)integralTest.factorize("x/(1+2*x+x^2)"));
    }

    public void test6() throws ParseException {
        integralTest.assertEquals((String)"7/5*x+1/2*x^2", (String)integralTest.expand("integral(x+7/5,x)"));
    }

    public void test7() throws ParseException {
        String s = "root[0](1, 0, 0, 27)*log(x+9*root[0](1, 0, 0, 27)^2)+root[1](1, 0, 0, 27)*log(x+9*root[1](1, 0, 0, 27)^2)+root[2](1, 0, 0, 27)*log(x+9*root[2](1, 0, 0, 27)^2)";
        integralTest.assertEquals((String)s, (String)integralTest.expand("integral(x/(x^3+1),x)"));
        integralTest.assertEquals((String)"x/(1+x^3)", (String)integralTest.simplify(integralTest.expand("d(" + s + ",x)")));
        integralTest.assertEquals((String)"x/(1+x^3)", (String)integralTest.simplify(integralTest.expand("d(-1/3*log(x+1)+1/6*log(x^2-x+1)+1/3*sqrt(3)*atan(1/3*(2*x-1)*sqrt(3)),x)")));
    }

    public void test8() throws ParseException {
        integralTest.assertEquals((String)"log(10)", (String)integralTest.expand("integral(1/x,x,1,10)"));
    }

    public void test9() throws ParseException {
        String s = "log(a+x)";
        integralTest.assertEquals((String)s, (String)integralTest.expand("integral(1/(x+a),x)"));
        integralTest.assertEquals((String)"1/(a+x)", (String)integralTest.expand("d(" + s + ",x)"));
    }

    public void test10() throws ParseException {
        String s = "x-a*log(a+x)";
        integralTest.assertEquals((String)s, (String)integralTest.expand("integral(x/(x+a),x)"));
        integralTest.assertEquals((String)"x/(a+x)", (String)integralTest.simplify(integralTest.expand("d(" + s + ",x)")));
    }

    public void test11() throws ParseException {
        String s = "a/(a+x)+log(a+x)";
        integralTest.assertEquals((String)s, (String)integralTest.expand("integral(x/(x+a)^2,x)"));
        integralTest.assertEquals((String)"x/(a^2+2*a*x+x^2)", (String)integralTest.simplify(integralTest.expand("d(" + s + ",x)")));
    }

    public void test12() throws ParseException {
        integralTest.assertEquals((String)"(3*1/7)/(1-2*x)+root[0](35*(1/7)^3, -26*(1/7)^2, 0, 147)*log(-3*(1/7)^2-9*(1/7)^2*x-2*1/7*root[0](35*(1/7)^3, -26*(1/7)^2, 0, 147)+3*1/7*x*root[0](35*(1/7)^3, -26*(1/7)^2, 0, 147)+19*root[0](35*(1/7)^3, -26*(1/7)^2, 0, 147)^2-10*x*root[0](35*(1/7)^3, -26*(1/7)^2, 0, 147)^2)+root[1](35*(1/7)^3, -26*(1/7)^2, 0, 147)*log(-3*(1/7)^2-9*(1/7)^2*x-2*1/7*root[1](35*(1/7)^3, -26*(1/7)^2, 0, 147)+3*1/7*x*root[1](35*(1/7)^3, -26*(1/7)^2, 0, 147)+19*root[1](35*(1/7)^3, -26*(1/7)^2, 0, 147)^2-10*x*root[1](35*(1/7)^3, -26*(1/7)^2, 0, 147)^2)+root[2](35*(1/7)^3, -26*(1/7)^2, 0, 147)*log(-3*(1/7)^2-9*(1/7)^2*x-2*1/7*root[2](35*(1/7)^3, -26*(1/7)^2, 0, 147)+3*1/7*x*root[2](35*(1/7)^3, -26*(1/7)^2, 0, 147)+19*root[2](35*(1/7)^3, -26*(1/7)^2, 0, 147)^2-10*x*root[2](35*(1/7)^3, -26*(1/7)^2, 0, 147)^2)", (String)integralTest.expand("integral((1+x)/((1+x+x^2)*(2*x-1)^2),x)"));
    }

    public void test13() throws ParseException {
        Variable x = Variable.valueOf("x");
        Expression a = Expression.valueOf("2*x + 2^x");
        Expression b = Expression.valueOf("2*x^2*1/2+2^x*1/log(2)");
        Generic c = ((Generic)a).antiderivative(x);
        integralTest.assertEquals((Object)b, (Object)c);
        integralTest.assertEquals((Object)a, (Object)c.derivative(x).simplify());
    }

    public void test14() throws ParseException {
        Generic a = Expression.valueOf("integral((-19*x^6 + 2*x^5 - 15*x^3 - 14*x^2 + 7)/(-10*x^18 + 5*x^17- 8*x^16 - 18*x^15 - x^14 + 7*x^13 - 11*x^12 - 10*x^11 + 14*x^10 + 19*x^8+ 18*x^6 + 16*x^5 - 8*x^3 - 19*x^2 - 17*x - 16),x)").expand();
        Generic b = Expression.valueOf("sum(    subst(        t*log(            - (28195776877858522276685275767788137489818378352734713313130*t^17+ 5463736986249140343103681022925097196229502805635042977045*t^16- 2899577469853806018666012098763126154591861838726009428964*t^15- 518428495070146912880912757450768033907455955577972577106*t^14+ 17461549892736990575046935275791246610941876787861628377*t^13+ 10191231322995629895475648412897177084720846466550776379*t^12+ 1339133785263787706210355274130624708684187857150658520*t^11+ 94586614367778113589846279438174614038455743961860390*t^10+ 3378560342867660767579248932537361042669934855715877*t^9+ 20546782526177116028623496372252682396683018432234*t^8- 3785340318502016983507695678396090655992159422277*t^7- 121322058544958730346909887825774011043044027366*t^6+ 3569432271953902328301941175606030812290079601*t^5+ 146147583087041406745621538929157697656912567*t^4- 4807337974435255192524724876186761420027130*t^3- 127083905012885852130932827688244454074465*t^2+ 5584974378522238566895223638692462046875*t- 48295786049746263357025480730000000000            )*x + (8268779594276442997150950092142039416886519771176898576420*t^17- 14174275255487653353094902663442736480322032565594005177410*t^16- 1993343262883435179154081579667729655984401313574116198306*t^15+ 344421471224707899413638573757027173823948465339670953334*t^14+ 55527140646163955356201831842571142192072640513377005732*t^13+ 888950947358645329753438388373110758542443079308557016*t^12- 424524281590778555628758056157631523560276137699496643*t^11- 62953393543944503921680304361025372685163839850059095*t^10- 3712433259975946855150193684252675825429359712643028*t^9- 102646978908464371257683094954414740928456333648139*t^8+ 242553260216446770654626708848927890608423028343*t^7+ 128696116841113116426138061922966199974719890223*t^6+ 359688053911576932491455029077882206638506521*t^5- 168420098860970354379846120741277795393764498*t^4- 211272187774682226043015091253286755657574*t^3+ 230937604863505539430768429093185675958109*t^2- 4846427517329657185335912259151042728125*t+ 28233482055189734415416681398000000000            )        ),        t,        root[i](17147155153808406124893742450242000000000,-1945805641606900163917345532462669148334375,61889567329194292883184955532295652068938386,-53241232918284877748334165207885839857596144,-29952044649984424543855375559613411035167691857,95158203641331782489017137311731580540763859110,20775574298550190315238421903597371616501667861123,409021930894294992384211793577698362998365079736703,11740526548904428976277763958071858702354056610868581,142586817423214680841340178408361196573900514343915097,-637009561826655173595265343730577162368476063424467572,-83469785668407468785948772925847870841444868731835094113,-3318697020862422234923935885658495326449790670842292630644,-50166810101798200095304490432851206258301211055617965948139,-525413079800249081578516648381286806298044252679104053814109,-2572788817808797629836331780649117909269086906492845566015320,4890542686492319368575336133030597437753811662925419340235310,0,-511624331134804517474055699978772374832715233614992591409797725        )    ),    i,    0,    17)").expand();
        integralTest.assertEquals((Object)JSCLInteger.valueOf(0L), (Object)a.subtract(b));
    }

    public void test15() throws ParseException {
        String s = "-1/b*log(4*cos(a+b*x))";
        integralTest.assertEquals((String)s, (String)integralTest.expand("integral(tan(a+b*x),x)"));
        integralTest.assertEquals((String)"sin(a+b*x)/cos(a+b*x)", (String)integralTest.simplify(integralTest.expand("d(" + s + ",x)")));
    }

    public void test16() throws ParseException {
        integralTest.assertEquals((String)"-(1+4*x-x^4-4*x^2*log(x))/(2*x^2)", (String)integralTest.simplify(integralTest.expand("integral((x^4 + 2*x^2 + 2*x + 1) / x^3, x)")));
    }

    public void test17() throws ParseException {
        integralTest.assertEquals((String)"-1/(2+2*z)", (String)integralTest.simplify(integralTest.expand("integral(1/(2*(1+z)^2),z)")));
    }
}

