/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.xml;

import functionplotter.xml.XmlUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlWriter {
    public static final int INDENT_INCREMENT = 2;
    private static final String DEFAULT_LINE_SEPARATOR = "\n";
    private static final String VERSION_STR = " version=";
    private static final String ENCODING_STR = " encoding=";
    private static final String STANDALONE_STR = " standalone=";
    private static final String DOCTYPE_STR = "<!DOCTYPE ";
    private static final String PUBLIC_STR = "PUBLIC ";
    private static final String SYSTEM_STR = "SYSTEM ";
    private static final String NO_STR = "no";
    private static final String YES_STR = "yes";
    private FileOutputStream fileOutStream;
    private Writer outStream;
    private StringBuilder outBuffer;
    private String lineSeparator;

    public XmlWriter(File file, String string) throws FileNotFoundException, SecurityException, UnsupportedEncodingException {
        this.fileOutStream = new FileOutputStream(file);
        this.init(new BufferedWriter(new OutputStreamWriter((OutputStream)this.fileOutStream, string)));
    }

    public XmlWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.init(new BufferedWriter(new OutputStreamWriter(outputStream, string)));
    }

    public XmlWriter(Writer writer) {
        this.init(writer);
    }

    public static List<Attribute> createAttributeList(Element element) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            Attribute attribute = new Attribute(node.getNodeName(), node.getNodeValue(), true);
            if (node.getNodeName().startsWith("xmlns")) {
                arrayList.add(0, attribute);
                continue;
            }
            arrayList.add(attribute);
        }
        return arrayList;
    }

    public FileOutputStream getFileOutStream() {
        return this.fileOutStream;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public int getOutLength() {
        return this.outBuffer.length();
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string == null ? System.getProperty("line.separator", DEFAULT_LINE_SEPARATOR) : string;
    }

    public void close() throws IOException {
        try {
            if (this.outStream != null) {
                this.outStream.append(this.outBuffer);
                this.outStream.close();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            this.outStream = null;
            this.outBuffer.setLength(0);
        }
    }

    public void writeXmlDeclaration(CharSequence charSequence, CharSequence charSequence2, Standalone standalone) throws IOException {
        this.write("<?functionplotter.xml");
        if (charSequence != null) {
            this.write(VERSION_STR);
            this.writeQuoted(charSequence);
        }
        if (charSequence2 != null) {
            this.write(ENCODING_STR);
            this.writeQuoted(charSequence2);
        }
        if (standalone != Standalone.NONE) {
            this.write(STANDALONE_STR);
            this.writeQuoted(standalone == Standalone.NO ? NO_STR : YES_STR);
        }
        this.write("?>");
        this.writeLineSeparator();
    }

    public void writeDocumentType(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) throws IOException {
        this.write(DOCTYPE_STR);
        this.write(charSequence);
        this.writeLineSeparator();
        this.writeSpaces(DOCTYPE_STR.length());
        if (charSequence3 != null) {
            this.write(PUBLIC_STR);
            this.writeQuoted(charSequence3);
            this.writeLineSeparator();
            this.writeSpaces(DOCTYPE_STR.length());
        } else {
            this.write(SYSTEM_STR);
        }
        this.writeQuoted(charSequence2);
        this.write('>');
        this.writeLineSeparator();
    }

    public void writeProcessingInstruction(CharSequence charSequence, CharSequence charSequence2) throws IOException {
        this.write("<?");
        this.write(charSequence);
        this.write(' ');
        this.write(charSequence2);
        this.write("?>");
        this.writeLineSeparator();
    }

    public void writeElementStart(CharSequence charSequence, int n, boolean bl) throws IOException {
        this.writeElementStart(charSequence, null, n, bl, false);
    }

    public void writeElementStart(CharSequence charSequence, List<Attribute> list, int n, boolean bl, boolean bl2) throws IOException {
        this.writeSpaces(n);
        this.write('<');
        this.write(charSequence);
        if (list != null) {
            this.writeAttributes(list, bl2 ? n + charSequence.length() + 2 : 0);
        }
        this.write('>');
        if (bl) {
            this.writeLineSeparator();
        }
    }

    public void writeEndTag(CharSequence charSequence) throws IOException {
        this.write("</");
        this.write(charSequence);
        this.write('>');
    }

    public void writeElementEnd(CharSequence charSequence, int n) throws IOException {
        if (n > 0) {
            this.writeSpaces(n);
        }
        this.writeEndTag(charSequence);
        this.writeLineSeparator();
    }

    public void writeEmptyElement(CharSequence charSequence, List<Attribute> list, int n, boolean bl) throws IOException {
        this.writeSpaces(n);
        this.write('<');
        this.write(charSequence);
        if (list != null) {
            this.writeAttributes(list, bl ? n + charSequence.length() + 2 : 0);
        }
        this.write("/>");
        this.writeLineSeparator();
    }

    public void writeEscapedTextElement(CharSequence charSequence, int n, String string) throws IOException {
        this.writeElementStart(charSequence, n, false);
        this.writeEscaped(string);
        this.writeElementEnd(charSequence, 0);
    }

    public void writeComment(CharSequence charSequence, int n) throws IOException {
        this.writeSpaces(n);
        this.write("<!-- ");
        this.write(charSequence);
        this.write(" -->");
        this.writeLineSeparator();
    }

    public void writeSpaces(int n) throws IOException {
        this.writeChars(' ', n);
    }

    public void write(char c) throws IOException {
        if (c == '\n') {
            this.outBuffer.append(this.lineSeparator);
            this.outStream.append(this.outBuffer);
            this.outBuffer.setLength(0);
        } else {
            this.outBuffer.append(c);
        }
    }

    public void write(CharSequence charSequence) throws IOException {
        for (int i = 0; i < charSequence.length(); ++i) {
            this.write(charSequence.charAt(i));
        }
    }

    public void writeEscaped(CharSequence charSequence) throws IOException {
        this.write(XmlUtilities.escape(charSequence));
    }

    public void writeQuoted(CharSequence charSequence) throws IOException {
        this.write('\"');
        this.write(charSequence);
        this.write('\"');
    }

    public void writeLineSeparator() throws IOException {
        this.write('\n');
    }

    public void writeChars(char c, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.write(c);
        }
    }

    public void writeElement(Element element, int n) throws IOException {
        List<Attribute> list = XmlWriter.createAttributeList(element);
        if (element.hasChildNodes()) {
            boolean bl = XmlUtilities.hasChildren(element, 1);
            this.writeElementStart(element.getTagName(), list, n, bl, false);
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    this.writeElement((Element)node, n + 2);
                    continue;
                }
                if (node.getNodeType() != 3) continue;
                this.write(node.getNodeValue());
            }
            this.writeElementEnd(element.getTagName(), bl ? n : 0);
        } else {
            this.writeEmptyElement(element.getTagName(), list, n, false);
        }
    }

    private void init(Writer writer) {
        this.outStream = writer;
        this.outBuffer = new StringBuilder(256);
        this.lineSeparator = DEFAULT_LINE_SEPARATOR;
    }

    private void writeAttributes(List<Attribute> list, int n) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                this.write(' ');
            } else if (n > 0) {
                this.writeLineSeparator();
                this.writeSpaces(n);
            } else {
                this.write(' ');
            }
            Attribute attribute = list.get(i);
            this.write(attribute.name);
            this.write('=');
            this.writeQuoted(attribute.value);
        }
    }

    public static class Attribute {
        String name;
        String value;

        public Attribute(String string, boolean bl) {
            this(string, bl ? XmlWriter.YES_STR : XmlWriter.NO_STR);
        }

        public Attribute(String string, int n) {
            this(string, Integer.toString(n));
        }

        public Attribute(String string, long l) {
            this(string, Long.toString(l));
        }

        public Attribute(String string, double d) {
            this(string, Double.toString(d));
        }

        public Attribute(String string, Object object) {
            this(string, object.toString());
        }

        public Attribute(String string, Object object, boolean bl) {
            this(string, object.toString(), bl);
        }

        public Attribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public Attribute(String string, String string2, boolean bl) {
            this(string, bl ? XmlUtilities.escape(string2) : string2);
        }
    }

    private static interface AttrName {
        public static final String XMLNS = "xmlns";
    }

    public static enum Standalone {
        NONE,
        NO,
        YES;

    }
}

