/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.xml;

import functionplotter.exception.AppException;
import functionplotter.exception.FileException;
import functionplotter.exception.TempFileException;
import functionplotter.exception.UrlException;
import functionplotter.xml.XmlUtilities;
import functionplotter.xml.XmlValidationException;
import functionplotter.xml.XmlWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlFile {
    private static final String XML_VERSION_STR = "1.0";

    private XmlFile() {
    }

    public static Document read(File file) throws AppException {
        return XmlFile.read(file, null, false);
    }

    public static Document read(File file, URI uRI) throws AppException {
        return XmlFile.read(file, uRI, false);
    }

    public static Document read(File file, URI uRI, boolean bl) throws AppException {
        FileInputStream fileInputStream = null;
        try {
            try {
                if (!file.isFile()) {
                    throw new FileException((AppException.Id)ErrorId.FILE_DOES_NOT_EXIST, file);
                }
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, file);
            }
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, file);
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, file);
            }
            try {
                if (fileInputStream.getChannel().tryLock(0L, Long.MAX_VALUE, true) == null) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, file);
                }
            }
            catch (Exception exception) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, file, exception);
            }
            try {
                if (!XmlUtilities.isXml(file)) {
                    throw new FileException((AppException.Id)ErrorId.UNEXPECTED_DOCUMENT_FORMAT, file);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, file, fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.ERROR_READING_FILE, file, iOException);
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, file, securityException);
            }
            XmlUtilities.getErrorHandler().clear();
            Document document = null;
            try {
                document = XmlUtilities.createDocument(fileInputStream, uRI, bl);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new FileException((AppException.Id)ErrorId.NOT_ENOUGH_MEMORY, file);
            }
            catch (AppException appException) {
                throw new FileException(appException, file);
            }
            if (!XmlUtilities.getErrorHandler().isEmpty()) {
                throw new XmlValidationException((AppException.Id)ErrorId.INVALID_DOCUMENT, file, XmlUtilities.getErrorHandler().getErrorStrings());
            }
            try {
                fileInputStream.close();
                fileInputStream = null;
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_CLOSE_FILE, file);
            }
            return document;
        }
        catch (AppException appException) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw appException;
        }
    }

    public static Document read(URL uRL) throws AppException {
        return XmlFile.read(uRL, null, false);
    }

    public static Document read(URL uRL, URI uRI) throws AppException {
        return XmlFile.read(uRL, uRI, false);
    }

    public static Document read(URL uRL, URI uRI, boolean bl) throws AppException {
        InputStream inputStream = null;
        try {
            try {
                inputStream = uRL.openStream();
            }
            catch (SecurityException securityException) {
                throw new UrlException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, uRL);
            }
            catch (IOException iOException) {
                throw new UrlException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, uRL);
            }
            XmlUtilities.getErrorHandler().clear();
            Document document = null;
            try {
                document = XmlUtilities.createDocument(inputStream, uRI, bl);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new UrlException((AppException.Id)ErrorId.NOT_ENOUGH_MEMORY, uRL);
            }
            catch (AppException appException) {
                throw new UrlException(appException, uRL);
            }
            if (!XmlUtilities.getErrorHandler().isEmpty()) {
                throw new XmlValidationException((AppException.Id)ErrorId.INVALID_DOCUMENT, uRL, XmlUtilities.getErrorHandler().getErrorStrings());
            }
            try {
                inputStream.close();
                inputStream = null;
            }
            catch (IOException iOException) {
                throw new UrlException((AppException.Id)ErrorId.FAILED_TO_CLOSE_FILE, uRL);
            }
            return document;
        }
        catch (AppException appException) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw appException;
        }
    }

    public static void write(File file, Document document, ElementWriter elementWriter) throws AppException, IllegalArgumentException {
        XmlFile.write(file, document, XmlWriter.Standalone.NONE, elementWriter);
    }

    public static void write(File file, Document document, XmlWriter.Standalone standalone, ElementWriter elementWriter) throws AppException, IllegalArgumentException {
        if (file == null || document == null) {
            throw new IllegalArgumentException();
        }
        File file2 = null;
        XmlWriter xmlWriter = null;
        boolean bl = false;
        try {
            try {
                file2 = File.createTempFile("_$_", null, file.getAbsoluteFile().getParentFile());
            }
            catch (Exception exception) {
                throw new AppException((AppException.Id)ErrorId.FAILED_TO_CREATE_TEMPORARY_FILE, (Throwable)exception);
            }
            try {
                xmlWriter = new XmlWriter(file2, "UTF-8");
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_OPEN_FILE, file2, fileNotFoundException);
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FILE_ACCESS_NOT_PERMITTED, file2, securityException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AppException((AppException.Id)ErrorId.UTF8_ENCODING_NOT_SUPPORTED, (Throwable)unsupportedEncodingException);
            }
            try {
                if (xmlWriter.getFileOutStream().getChannel().tryLock() == null) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, file2);
                }
            }
            catch (Exception exception) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_LOCK_FILE, file2, exception);
            }
            try {
                xmlWriter.writeXmlDeclaration(XML_VERSION_STR, "UTF-8", standalone);
                elementWriter.writeElement(xmlWriter, document.getDocumentElement(), 0);
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.ERROR_WRITING_FILE, file2, iOException);
            }
            try {
                xmlWriter.close();
                xmlWriter = null;
            }
            catch (IOException iOException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_CLOSE_FILE, file2, iOException);
            }
            try {
                if (file.exists() && !file.delete()) {
                    throw new FileException((AppException.Id)ErrorId.FAILED_TO_DELETE_FILE, file);
                }
                bl = true;
            }
            catch (SecurityException securityException) {
                throw new FileException((AppException.Id)ErrorId.FAILED_TO_DELETE_FILE, file);
            }
            try {
                if (!file2.renameTo(file)) {
                    throw new TempFileException((AppException.Id)ErrorId.FAILED_TO_RENAME_FILE, file, file2);
                }
            }
            catch (SecurityException securityException) {
                throw new TempFileException((AppException.Id)ErrorId.FAILED_TO_RENAME_FILE, file, file2);
            }
        }
        catch (AppException appException) {
            try {
                if (xmlWriter != null) {
                    xmlWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!bl && file2 != null && file2.exists()) {
                    file2.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw appException;
        }
    }

    public static interface ElementWriter {
        public void writeElement(XmlWriter var1, Element var2, int var3) throws IOException;
    }

    private static enum ErrorId implements AppException.Id
    {
        FILE_DOES_NOT_EXIST("The %1 does not exist."),
        FAILED_TO_OPEN_FILE("Failed to open the %1."),
        FAILED_TO_CLOSE_FILE("Failed to close the %1."),
        FAILED_TO_LOCK_FILE("Failed to lock the %1."),
        ERROR_READING_FILE("An error occurred while reading the %1."),
        ERROR_WRITING_FILE("An error occurred while writing the %1."),
        FILE_ACCESS_NOT_PERMITTED("Access to the %1 was not permitted."),
        FAILED_TO_CREATE_TEMPORARY_FILE("Failed to create a temporary %1."),
        FAILED_TO_DELETE_FILE("Failed to delete the existing %1."),
        FAILED_TO_RENAME_FILE("Failed to rename the temporary %1."),
        NOT_ENOUGH_MEMORY("There was not enough memory to read the %1."),
        UTF8_ENCODING_NOT_SUPPORTED("This implementation of Java does not support the UTF-8 character encoding."),
        INVALID_DOCUMENT("The document is not valid."),
        UNEXPECTED_DOCUMENT_FORMAT("The document does not have the expected format.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

