/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.util;

import java.awt.event.InputEvent;

public enum InputModifiers {
    NONE(0),
    SHIFT(64),
    CTRL(128),
    ALT(512),
    CTRL_SHIFT(192),
    ALT_SHIFT(576),
    ALT_CTRL(640),
    ALT_CTRL_SHIFT(704),
    UNRECOGNISED(0);

    public static final int MASK = 9152;
    private int value;

    private InputModifiers(int n2) {
        this.value = n2;
    }

    public static InputModifiers get(int n) {
        int n2 = n & 0x23C0;
        for (InputModifiers inputModifiers : InputModifiers.values()) {
            if (inputModifiers.value != n2) continue;
            return inputModifiers;
        }
        return UNRECOGNISED;
    }

    public static InputModifiers get(InputEvent inputEvent) {
        return InputModifiers.get(inputEvent.getModifiersEx());
    }

    public boolean isShift() {
        return (this.value & 0x40) != 0;
    }

    public boolean isControl() {
        return (this.value & 0x80) != 0;
    }

    public boolean isAlt() {
        return (this.value & 0x200) != 0;
    }
}

