/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.exception.AppException;
import functionplotter.gui.FButton;
import functionplotter.gui.FLabel;
import functionplotter.gui.GuiUtilities;
import functionplotter.gui.ProgressView;
import functionplotter.gui.TextRendering;
import functionplotter.util.KeyAction;
import functionplotter.util.Numeric;
import functionplotter.util.Operation;
import functionplotter.util.ProgressListener;
import functionplotter.util.TextUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class OperationDialog
extends JDialog
implements ActionListener,
ProgressListener,
ProgressView {
    private static final int INFO_FIELD_WIDTH = 480;
    private static final int PROGRESS_BAR_WIDTH = 480;
    private static final int PROGRESS_BAR_HEIGHT = 15;
    private static final int PROGRESS_BAR_MAX_VALUE = 10000;
    private static final String TIME_ELAPSED_STR = "Time elapsed:";
    private static final String TIME_REMAINING_STR = "Estimated time remaining:";
    private static Point location;
    private boolean stopped;
    private State state;
    private long startTime;
    private long updateTime;
    private InfoField infoField;
    private JProgressBar[] progressBars;
    private TimeField timeElapsedField;
    private TimeField timeRemainingField;
    private JButton cancelButton;

    protected OperationDialog(Window window, String string, Operation operation, int n, int n2, boolean bl, boolean bl2) throws AppException {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        JComponent jComponent;
        JComponent jComponent2;
        if (window != null) {
            this.setIconImages(window.getIconImages());
        }
        this.infoField = new InfoField();
        this.progressBars = new JProgressBar[n2];
        for (int i = 0; i < this.progressBars.length; ++i) {
            this.progressBars[i] = new JProgressBar(0, 10000);
            this.progressBars[i].setPreferredSize(new Dimension(480, 15));
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n3 = 0;
        JPanel jPanel = null;
        if (bl) {
            jPanel = new JPanel(gridBagLayout);
            jComponent2 = new FLabel(TIME_ELAPSED_STR);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 22;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
            jPanel.add(jComponent2);
            this.timeElapsedField = new TimeField();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n3++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 4, 0, 0);
            gridBagLayout.setConstraints(this.timeElapsedField, gridBagConstraints);
            jPanel.add(this.timeElapsedField);
            jComponent = new FLabel(TIME_REMAINING_STR);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 22;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(1, 0, 0, 0);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
            this.timeRemainingField = new TimeField();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n3++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(1, 4, 0, 0);
            gridBagLayout.setConstraints(this.timeRemainingField, gridBagConstraints);
            jPanel.add(this.timeRemainingField);
        }
        jComponent2 = null;
        if (bl2) {
            jComponent2 = new JPanel(new GridLayout(1, 0, 0, 0));
            this.cancelButton = new FButton("Cancel");
            this.cancelButton.setActionCommand("close");
            this.cancelButton.addActionListener(this);
            jComponent2.add(this.cancelButton);
        }
        jComponent = null;
        if (bl && bl2) {
            jComponent = new JPanel(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            jComponent.add(jPanel);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
            jComponent.add(jComponent2);
        } else if (bl && !bl2) {
            jComponent = jPanel;
        } else if (!bl && bl2) {
            jComponent = jComponent2;
        }
        if (jComponent == null) {
            jComponent = GuiUtilities.createFiller();
        } else {
            jComponent.setBorder(BorderFactory.createEmptyBorder(2, 8, 3, 8));
        }
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
        n3 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 2, 6, 2);
        gridBagLayout.setConstraints(this.infoField, gridBagConstraints);
        jPanel2.add(this.infoField);
        for (int i = 0; i < this.progressBars.length; ++i) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n3++;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            gridBagLayout.setConstraints(this.progressBars[i], gridBagConstraints);
            jPanel2.add(this.progressBars[i]);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n3++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = bl ? 2 : 0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel2.add(jComponent);
        KeyAction.create(jPanel2, 1, KeyStroke.getKeyStroke(27, 0), "close", this);
        this.setContentPane(jPanel2);
        this.applyOrientation();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowEventHandler());
        this.setResizable(false);
        this.pack();
        if (location == null) {
            location = GuiUtilities.getComponentLocation((Component)this, window);
        }
        this.setLocation(location);
        this.getRootPane().setDefaultButton(this.cancelButton);
        Operation.setProgressView(this);
        Operation.setException(null, true);
        Operation.setTerminated(false);
        operation.start();
        long l = System.currentTimeMillis() + (long)n;
        while (!this.stopped) {
            if (System.currentTimeMillis() >= l) {
                this.setVisible(true);
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Operation.throwOnException();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("close")) {
            this.doClose();
        }
    }

    @Override
    public void setInfo(String string) {
        this.setInfo(string, null);
    }

    @Override
    public void setInfo(String string, File file) {
        if (this.isVisible()) {
            try {
                SwingUtilities.invokeAndWait(new DoSetInfo(string, file));
            }
            catch (Exception exception) {}
        } else {
            if (this.state == null) {
                this.state = new State();
            }
            this.state.text = string;
            this.state.file = file;
        }
    }

    @Override
    public void setProgress(int n, double d) {
        if (this.isVisible()) {
            try {
                SwingUtilities.invokeAndWait(new DoSetProgress(n, d));
            }
            catch (Exception exception) {}
        } else {
            if (this.state == null) {
                this.state = new State();
            }
            ((State)this.state).progresses[n] = d;
        }
    }

    @Override
    public void close() {
        this.stopped = true;
        if (this.isVisible()) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }

    @Override
    public void setProgress(double d) {
        this.setProgress(0, d);
    }

    @Override
    public boolean isOperationTerminated() {
        return Operation.isTerminated();
    }

    protected String getPathname(File file) {
        String string = null;
        try {
            try {
                string = file.getCanonicalPath();
            }
            catch (Exception exception) {
                string = file.getAbsolutePath();
            }
        }
        catch (SecurityException securityException) {
            string = file.getPath();
        }
        return string;
    }

    protected char getFileSeparatorChar() {
        return File.separatorChar;
    }

    protected void applyOrientation() {
    }

    private void doClose() {
        this.cancelButton.setEnabled(false);
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (OperationDialog.this.stopped) {
                location = OperationDialog.this.getLocation();
                OperationDialog.this.dispose();
            } else {
                Operation.setTerminated(true);
            }
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            if (OperationDialog.this.state != null) {
                OperationDialog.this.state.update();
            }
        }
    }

    private class State {
        private String text;
        private File file;
        private double[] progresses;

        private State() {
            this.progresses = new double[OperationDialog.this.progressBars.length];
        }

        private void update() {
            new DoSetInfo(this.text, this.file).run();
            for (int i = 0; i < this.progresses.length; ++i) {
                if (this.progresses[i] > 0.0) {
                    new DoSetProgress(i, 0.0).run();
                }
                new DoSetProgress(i, this.progresses[i]).run();
            }
        }
    }

    private class DoSetProgress
    implements Runnable {
        private static final int UPDATE_INTERVAL = 500;
        private int index;
        private double value;

        private DoSetProgress(int n, double d) {
            this.index = n;
            this.value = d;
        }

        @Override
        public void run() {
            if (this.value < 0.0) {
                OperationDialog.this.progressBars[this.index].setIndeterminate(true);
                if (OperationDialog.this.timeElapsedField != null) {
                    OperationDialog.this.timeElapsedField.setText(null);
                    OperationDialog.this.timeRemainingField.setText(null);
                }
            } else {
                if (OperationDialog.this.progressBars[this.index].isIndeterminate()) {
                    OperationDialog.this.progressBars[this.index].setIndeterminate(false);
                }
                OperationDialog.this.progressBars[this.index].setValue((int)Math.round(this.value * 10000.0));
                if (OperationDialog.this.timeElapsedField != null) {
                    if (this.value == 0.0) {
                        OperationDialog.this.startTime = System.currentTimeMillis();
                        OperationDialog.this.timeElapsedField.setTime(0);
                        OperationDialog.this.timeRemainingField.setText(null);
                    } else {
                        long l = System.currentTimeMillis();
                        if (l >= OperationDialog.this.updateTime) {
                            long l2 = l - OperationDialog.this.startTime;
                            OperationDialog.this.timeElapsedField.setTime((int)l2);
                            OperationDialog.this.timeRemainingField.setTime((int)Math.round((1.0 / this.value - 1.0) * (double)l2) + 999);
                            OperationDialog.this.updateTime = l + 500L;
                        }
                    }
                }
            }
        }
    }

    private class DoSetInfo
    implements Runnable {
        private String str;
        private File file;

        private DoSetInfo(String string, File file) {
            this.str = string;
            this.file = file;
        }

        @Override
        public void run() {
            if (this.file == null) {
                OperationDialog.this.infoField.setText(this.str);
            } else {
                FontMetrics fontMetrics = OperationDialog.this.infoField.getFontMetrics(OperationDialog.this.infoField.getFont());
                int n = OperationDialog.this.infoField.getWidth() - (this.str == null ? 0 : fontMetrics.stringWidth(this.str + " "));
                String string = TextUtilities.getLimitedWidthPathname(OperationDialog.this.getPathname(this.file), fontMetrics, n, OperationDialog.this.getFileSeparatorChar());
                OperationDialog.this.infoField.setText(this.str == null ? string : this.str + " " + string);
            }
        }
    }

    private static class TimeField
    extends JComponent {
        private static final String PROTOTYPE_STR = "000:00";
        private static final Color TEXT_COLOUR = new Color(0, 0, 144);
        private String text;

        private TimeField() {
            GuiUtilities.setFont("MAIN", this);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.setPreferredSize(new Dimension(fontMetrics.stringWidth(PROTOTYPE_STR), fontMetrics.getAscent() + fontMetrics.getDescent()));
            this.setOpaque(true);
            this.setFocusable(false);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics = graphics.create();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.text != null) {
                TextRendering.setHints((Graphics2D)graphics);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = this.getComponentOrientation().isLeftToRight() ? this.getWidth() - fontMetrics.stringWidth(this.text) : 0;
                graphics.setColor(TEXT_COLOUR);
                graphics.drawString(this.text, n, fontMetrics.getAscent());
            }
        }

        public void setTime(int n) {
            int n2 = n / 1000;
            int n3 = n2 / 60;
            this.setText(n3 + ":" + Numeric.uIntToDecString(n2 % 60, 2, '0'));
        }

        public void setText(String string) {
            if (this.text == null && string != null || this.text != null && !this.text.equals(string)) {
                this.text = string;
                this.repaint();
            }
        }
    }

    private static class InfoField
    extends JComponent {
        private String text;

        private InfoField() {
            GuiUtilities.setFont("MAIN", this);
            this.setPreferredSize(new Dimension(480, this.getFontMetrics(this.getFont()).getHeight()));
            this.setOpaque(true);
            this.setFocusable(false);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics = graphics.create();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.text != null) {
                TextRendering.setHints((Graphics2D)graphics);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = this.getComponentOrientation().isLeftToRight() ? 0 : this.getWidth() - fontMetrics.stringWidth(this.text);
                graphics.setColor(Color.BLACK);
                graphics.drawString(this.text, n, fontMetrics.getAscent());
            }
        }

        public void setText(String string) {
            if (this.text == null && string != null || this.text != null && !this.text.equals(string)) {
                this.text = string;
                this.repaint();
            }
        }
    }

    private static interface Command {
        public static final String CLOSE = "close";
    }
}

