/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import java.awt.Point;
import java.awt.Rectangle;

public enum CornerKind {
    TOP_LEFT{

        @Override
        public Rectangle getRectangle(Rectangle rectangle, int n) {
            int n2 = Math.min(rectangle.width, n);
            int n3 = Math.min(rectangle.height, n);
            return new Rectangle(rectangle.x, rectangle.y, n2, n3);
        }

        @Override
        public Point getLocation(Rectangle rectangle, Rectangle rectangle2, int n) {
            return new Point(CornerKind.getCoord(rectangle.x, rectangle2.x, rectangle2.width, n), CornerKind.getCoord(rectangle.y, rectangle2.y, rectangle2.height, n));
        }
    }
    ,
    TOP_RIGHT{

        @Override
        public Rectangle getRectangle(Rectangle rectangle, int n) {
            int n2 = Math.min(rectangle.width, n);
            int n3 = Math.min(rectangle.height, n);
            return new Rectangle(rectangle.x + rectangle.width - n2, rectangle.y, n2, n3);
        }

        @Override
        public Point getLocation(Rectangle rectangle, Rectangle rectangle2, int n) {
            return new Point(CornerKind.getCoord(rectangle.x, rectangle.width, rectangle2.x, rectangle2.width, n), CornerKind.getCoord(rectangle.y, rectangle2.y, rectangle2.height, n));
        }
    }
    ,
    BOTTOM_LEFT{

        @Override
        public Rectangle getRectangle(Rectangle rectangle, int n) {
            int n2 = Math.min(rectangle.width, n);
            int n3 = Math.min(rectangle.height, n);
            return new Rectangle(rectangle.x, rectangle.y + rectangle.height - n3, n2, n3);
        }

        @Override
        public Point getLocation(Rectangle rectangle, Rectangle rectangle2, int n) {
            return new Point(CornerKind.getCoord(rectangle.x, rectangle2.x, rectangle2.width, n), CornerKind.getCoord(rectangle.y, rectangle.height, rectangle2.y, rectangle2.height, n));
        }
    }
    ,
    BOTTOM_RIGHT{

        @Override
        public Rectangle getRectangle(Rectangle rectangle, int n) {
            int n2 = Math.min(rectangle.width, n);
            int n3 = Math.min(rectangle.height, n);
            return new Rectangle(rectangle.x + rectangle.width - n2, rectangle.y + rectangle.height - n3, n2, n3);
        }

        @Override
        public Point getLocation(Rectangle rectangle, Rectangle rectangle2, int n) {
            return new Point(CornerKind.getCoord(rectangle.x, rectangle.width, rectangle2.x, rectangle2.width, n), CornerKind.getCoord(rectangle.y, rectangle.height, rectangle2.y, rectangle2.height, n));
        }
    };

    public static final CornerKind[] TOP_CORNERS;
    public static final CornerKind[] BOTTOM_CORNERS;
    public static final CornerKind[] LEFT_CORNERS;
    public static final CornerKind[] RIGHT_CORNERS;

    private static int getCoord(int n, int n2, int n3, int n4) {
        return Math.max(n2, Math.min(n, n2 + n3 - n4));
    }

    private static int getCoord(int n, int n2, int n3, int n4, int n5) {
        return Math.min(Math.max(n3 + n5, n + n2), n3 + n4) - n2;
    }

    public abstract Rectangle getRectangle(Rectangle var1, int var2);

    public abstract Point getLocation(Rectangle var1, Rectangle var2, int var3);

    static {
        TOP_CORNERS = new CornerKind[]{TOP_LEFT, TOP_RIGHT};
        BOTTOM_CORNERS = new CornerKind[]{BOTTOM_LEFT, BOTTOM_RIGHT};
        LEFT_CORNERS = new CornerKind[]{TOP_LEFT, BOTTOM_LEFT};
        RIGHT_CORNERS = new CornerKind[]{TOP_RIGHT, BOTTOM_RIGHT};
    }
}

