/*
 * Decompiled with CFR 0.152.
 */
package functionplotter.gui;

import functionplotter.util.StringKeyed;
import functionplotter.util.StringUtilities;
import java.awt.Color;

public class Colours {
    public static final Color BACKGROUND = new Color(248, 248, 240);
    public static final Color FOREGROUND = Color.BLACK;
    public static final Color SELECTION_BACKGROUND = new Color(224, 224, 216);
    public static final Color SELECTION_FOREGROUND = FOREGROUND;
    public static final Color FOCUSED_SELECTION_BACKGROUND = new Color(252, 192, 80);
    public static final Color FOCUSED_SELECTION_FOREGROUND = FOREGROUND;
    public static final Color LINE_BORDER = new Color(160, 160, 160);
    public static final Color FOCUSED_CELL_BORDER = new Color(0, 0, 176);
    public static final String BACKGROUND_KEY = "background";
    public static final String FOREGROUND_KEY = "foreground";
    public static final String SELECTION_BACKGROUND_KEY = "selectionBackground";
    public static final String SELECTION_FOREGROUND_KEY = "selectionForeground";
    public static final String FOCUSED_SELECTION_BACKGROUND_KEY = "focusedSelectionBackground";
    public static final String FOCUSED_SELECTION_FOREGROUND_KEY = "focusedSelectionForeground";
    public static final String FOCUSED_CELL_BORDER_KEY = "focusedCellBorder";
    public static final String DRAG_BAR_KEY = "dragBar";
    public static final String GRID_KEY = "grid";
    public static final String HEADER_BORDER_KEY = "headerBorder";
    public static final String FOCUSED_HEADER_BORDER_KEY = "focusedHeaderBorder";
    public static final String HEADER_BACKGROUND_KEY = "headerBackground";
    public static final String FOCUSED_HEADER_BACKGROUND_KEY = "focusedHeaderBackground";
    public static final String EDITABLE_CELL_BACKGROUND_KEY = "editableCellBackground";

    public static Color get(String string) {
        Color color = null;
        int n = string.indexOf(46);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.equals(Colours.classToPrefix(List.class))) {
                color = List.get(string3);
            } else if (string2.equals(Colours.classToPrefix(Table.class))) {
                color = Table.get(string3);
            } else if (string2.equals(Colours.classToPrefix(TextArea.class))) {
                color = TextArea.get(string3);
            }
        }
        return color;
    }

    private static String classToPrefix(Class<?> clazz) {
        String string = clazz.getSimpleName();
        return StringUtilities.firstCharToLowerCase(string);
    }

    public static enum TextArea implements StringKeyed
    {
        BACKGROUND("background", BACKGROUND),
        FOREGROUND("foreground", FOREGROUND),
        SELECTION_BACKGROUND("selectionBackground", SELECTION_BACKGROUND),
        SELECTION_FOREGROUND("selectionForeground", SELECTION_FOREGROUND),
        FOCUSED_SELECTION_BACKGROUND("focusedSelectionBackground", FOCUSED_SELECTION_BACKGROUND),
        FOCUSED_SELECTION_FOREGROUND("focusedSelectionForeground", FOCUSED_SELECTION_FOREGROUND);

        private String key;
        private Color colour;

        private TextArea(String string2, Color color) {
            this.key = string2;
            this.colour = color;
        }

        public static Color get(String string) {
            for (TextArea textArea : TextArea.values()) {
                if (!textArea.key.equals(string)) continue;
                return textArea.colour;
            }
            return null;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String getPrefixedKey() {
            return Colours.classToPrefix(TextArea.class) + "." + this.key;
        }

        public Color getColour() {
            return this.colour;
        }
    }

    public static enum Table implements StringKeyed
    {
        BACKGROUND("background", BACKGROUND),
        FOREGROUND("foreground", FOREGROUND),
        SELECTION_BACKGROUND("selectionBackground", SELECTION_BACKGROUND),
        SELECTION_FOREGROUND("selectionForeground", SELECTION_FOREGROUND),
        FOCUSED_SELECTION_BACKGROUND("focusedSelectionBackground", FOCUSED_SELECTION_BACKGROUND),
        FOCUSED_SELECTION_FOREGROUND("focusedSelectionForeground", FOCUSED_SELECTION_FOREGROUND),
        GRID("grid", new Color(208, 208, 208)),
        HEADER_BORDER("headerBorder", new Color(184, 184, 184)),
        FOCUSED_HEADER_BORDER("focusedHeaderBorder", new Color(224, 144, 88)),
        HEADER_BACKGROUND("headerBackground", new Color(216, 216, 216)),
        FOCUSED_HEADER_BACKGROUND("focusedHeaderBackground", new Color(240, 224, 176)),
        FOCUSED_CELL_BORDER("focusedCellBorder", FOCUSED_CELL_BORDER),
        EDITABLE_CELL_BACKGROUND("editableCellBackground", new Color(255, 224, 128));

        private String key;
        private Color colour;

        private Table(String string2, Color color) {
            this.key = string2;
            this.colour = color;
        }

        public static Color get(String string) {
            for (Table table : Table.values()) {
                if (!table.key.equals(string)) continue;
                return table.colour;
            }
            return null;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String getPrefixedKey() {
            return Colours.classToPrefix(Table.class) + "." + this.key;
        }

        public Color getColour() {
            return this.colour;
        }
    }

    public static enum List implements StringKeyed
    {
        BACKGROUND("background", BACKGROUND),
        FOREGROUND("foreground", FOREGROUND),
        SELECTION_BACKGROUND("selectionBackground", SELECTION_BACKGROUND),
        SELECTION_FOREGROUND("selectionForeground", SELECTION_FOREGROUND),
        FOCUSED_SELECTION_BACKGROUND("focusedSelectionBackground", FOCUSED_SELECTION_BACKGROUND),
        FOCUSED_SELECTION_FOREGROUND("focusedSelectionForeground", FOCUSED_SELECTION_FOREGROUND),
        FOCUSED_CELL_BORDER("focusedCellBorder", FOCUSED_CELL_BORDER),
        DRAG_BAR("dragBar", FOREGROUND);

        private String key;
        private Color colour;

        private List(String string2, Color color) {
            this.key = string2;
            this.colour = color;
        }

        public static Color get(String string) {
            for (List list : List.values()) {
                if (!list.key.equals(string)) continue;
                return list.colour;
            }
            return null;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String getPrefixedKey() {
            return Colours.classToPrefix(List.class) + "." + this.key;
        }

        public Color getColour() {
            return this.colour;
        }
    }
}

