/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.AppConfig;
import functionplotter.util.IntegerRange;
import functionplotter.util.StringUtilities;
import java.math.BigDecimal;

class PlotInterval {
    public static final double MIN_VALUE = -1.0E100;
    public static final double MAX_VALUE = 1.0E100;
    public static final int MAX_NUM_SIGNIFICANT_DIGITS = 12;
    private static final String DEFAULT_LOWER_EP_STR = "-1.0";
    private static final String DEFAULT_UPPER_EP_STR = "1.0";
    private static final double ONE_OVER_LOG_10 = 1.0 / Math.log(10.0);
    private static final String FIXED_ZERO_STR = "0.0";
    private static final String FIXED_MINUS_ZERO_STR = "-0.0";
    private static final String SCIENTIFIC_ZERO_STR = "0.0E0";
    private static final String SCIENTIFIC_MINUS_ZERO_STR = "-0.0E0";
    private BigDecimal lowerEndpoint;
    private BigDecimal upperEndpoint;

    public PlotInterval() {
        this(DEFAULT_LOWER_EP_STR, DEFAULT_UPPER_EP_STR);
    }

    public PlotInterval(double d, double d2) {
        this(Double.toString(d), Double.toString(d2));
    }

    public PlotInterval(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this.lowerEndpoint = bigDecimal;
        this.upperEndpoint = bigDecimal2;
        this.lowerEndpoint = new BigDecimal(this.getLowerEndpointString());
        this.upperEndpoint = new BigDecimal(this.getUpperEndpointString());
    }

    public PlotInterval(String string, String string2) throws NumberFormatException {
        this(new BigDecimal(string), new BigDecimal(string2));
    }

    public PlotInterval(PlotInterval plotInterval) {
        this(plotInterval.lowerEndpoint, plotInterval.upperEndpoint);
    }

    public static boolean hasTooManySignificantDigits(String string) {
        int n;
        int n2;
        int n3 = (string = string.toUpperCase()).indexOf(69);
        if (n3 < 0) {
            n3 = string.length();
        }
        if ((n2 = string.indexOf(46)) >= 0 && n2 < n3) {
            n = n2;
            while (++n < n3 && string.charAt(n) == '0') {
            }
            if (n == n3) {
                n3 = n2;
            }
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '0' && n == 0 || c < '0' || c > '9') continue;
            ++n;
        }
        return n > 12;
    }

    public static String doubleToString(double d, int n, IntegerRange integerRange, boolean bl, int n2) {
        String string;
        int n3;
        boolean bl2;
        if (d == 0.0) {
            return FIXED_ZERO_STR;
        }
        boolean bl3 = bl2 = d < 0.0;
        if (bl2) {
            d = -d;
        }
        int n4 = (int)Math.floor(Math.log(d) * ONE_OVER_LOG_10);
        String string2 = Long.toString((long)(d * Math.pow(10.0, 13 - n4)));
        n4 += string2.length() - 13;
        int n5 = 0;
        while (n5 < string2.length()) {
            --n4;
            if (string2.charAt(n5++) == '0') continue;
        }
        if (bl) {
            n5 += n4 - n2;
            n4 = n2;
        }
        if (integerRange.contains(n4)) {
            n5 += n4;
            n4 = 0;
        }
        StringBuilder stringBuilder = new StringBuilder(24);
        if (n5 < 0) {
            stringBuilder.append(StringUtilities.createCharArray('0', -n5));
            n5 = 0;
        }
        stringBuilder.append(string2);
        int n6 = Math.min(n5 + n, stringBuilder.length() - 2);
        if (n5 > stringBuilder.length()) {
            stringBuilder.append(StringUtilities.createCharArray('0', n5 - stringBuilder.length()));
        }
        if (stringBuilder.charAt(n3 = n6) >= '5') {
            while (--n3 >= 0) {
                char c = stringBuilder.charAt(n3);
                if (c == '9') {
                    stringBuilder.setCharAt(n3, '0');
                    continue;
                }
                c = (char)(c + '\u0001');
                stringBuilder.setCharAt(n3, c);
                break;
            }
            if (n3 < 0) {
                stringBuilder.insert(0, '1');
                if (bl) {
                    ++n5;
                } else if (integerRange.contains(++n4)) {
                    n5 += n4;
                    n4 = 0;
                }
            }
        }
        stringBuilder.setLength(n6);
        if (n5 < 0) {
            stringBuilder.insert(0, StringUtilities.createCharArray('0', -n5));
            n5 = 0;
        }
        if (n5 > stringBuilder.length()) {
            stringBuilder.append(StringUtilities.createCharArray('0', n5 - stringBuilder.length()));
        }
        stringBuilder.insert(n5, '.');
        n3 = 0;
        while (stringBuilder.charAt(n3) == '0') {
            ++n3;
        }
        if (stringBuilder.charAt(n3) == '.') {
            if (n3 == 0) {
                stringBuilder.insert(0, '0');
            } else {
                --n3;
            }
        }
        stringBuilder.delete(0, n3);
        n3 = stringBuilder.length();
        while (stringBuilder.charAt(--n3) == '0') {
        }
        stringBuilder.setLength(++n3);
        if (stringBuilder.charAt(n3 - 1) == '.') {
            stringBuilder.append('0');
        }
        if (bl2) {
            stringBuilder.insert(0, '-');
        }
        if (n4 != 0) {
            stringBuilder.append('E');
            stringBuilder.append(Integer.toString(n4));
        }
        if ((string = stringBuilder.toString()).equals(FIXED_MINUS_ZERO_STR) || string.equals(SCIENTIFIC_ZERO_STR) || string.equals(SCIENTIFIC_MINUS_ZERO_STR)) {
            string = FIXED_ZERO_STR;
        }
        return string;
    }

    public String toString() {
        return new String(this.lowerEndpoint + ", " + this.upperEndpoint);
    }

    public double getLowerEndpoint() {
        return this.lowerEndpoint.doubleValue();
    }

    public double getUpperEndpoint() {
        return this.upperEndpoint.doubleValue();
    }

    public String getLowerEndpointString() {
        return this.coordToString(this.getLowerEndpoint());
    }

    public String getUpperEndpointString() {
        return this.coordToString(this.getUpperEndpoint());
    }

    public double getInterval() {
        return this.upperEndpoint.doubleValue() - this.lowerEndpoint.doubleValue();
    }

    public double getHalfInterval() {
        return 0.5 * (this.upperEndpoint.doubleValue() - this.lowerEndpoint.doubleValue());
    }

    public double getMedian() {
        return 0.5 * (this.upperEndpoint.doubleValue() + this.lowerEndpoint.doubleValue());
    }

    public boolean isValid() {
        double d = this.getLowerEndpoint();
        double d2 = this.getUpperEndpoint();
        return d >= -1.0E100 && d <= 1.0E100 && d2 >= -1.0E100 && d2 <= 1.0E100 && d < d2;
    }

    public boolean equals(PlotInterval plotInterval) {
        return plotInterval != null && this.lowerEndpoint.equals(plotInterval.lowerEndpoint) && this.upperEndpoint.equals(plotInterval.upperEndpoint);
    }

    public String coordToString(double d) {
        AppConfig appConfig = AppConfig.getInstance();
        return PlotInterval.doubleToString(d, appConfig.getNumFractionDigits(), appConfig.getFixedPointExponentRange(), !appConfig.isNormaliseScientificNotation(), this.getExponent());
    }

    public int getExponent() {
        int n;
        double d = Math.min(Math.abs(this.getLowerEndpoint()), Math.abs(this.getUpperEndpoint()));
        int n2 = n = d == 0.0 ? 0 : (int)Math.floor(Math.log(d) * ONE_OVER_LOG_10);
        if (d * Math.pow(10.0, -n) >= 10.0) {
            ++n;
        }
        return n;
    }
}

