/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.App;
import functionplotter.AppConfig;
import functionplotter.AppConstants;
import functionplotter.AppIcon;
import functionplotter.Expression;
import functionplotter.Function;
import functionplotter.FunctionDocument;
import functionplotter.SurrogateMinus;
import functionplotter.exception.AppException;
import functionplotter.gui.ColourSampleIcon;
import functionplotter.gui.FButton;
import functionplotter.gui.FLabel;
import functionplotter.gui.GuiUtilities;
import functionplotter.util.KeyAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class FunctionDialog
extends JDialog
implements ActionListener,
FlavorListener {
    private static final int COLOUR_BUTTON_ICON_WIDTH = 40;
    private static final int COLOUR_BUTTON_ICON_HEIGHT = 16;
    private static final Insets COLOUR_BUTTON_MARGINS = new Insets(2, 2, 2, 2);
    private static final int EXPRESSION_FIELD_LENGTH = 512;
    private static final String COLOUR_STR = "Colour:";
    private static final String EXPRESSION_STR = "Expression:";
    private static final String COPY_STR = "Copy";
    private static final String PASTE_STR = "Paste";
    private static final String CLEAR_STR = "Clear";
    private static final String COLOUR_TITLE_STR = "Colour of Plotted Function";
    private static final String COPY_TOOLTIP_STR = "Copy expression to clipboard";
    private static final String PASTE_TOOLTIP_STR = "Replace expression with text from clipboard";
    private static final String CLEAR_TOOLTIP_STR = "Clear expression (Ctrl+Delete)";
    private static final String SYNTAX_ERROR_STR = "Syntax Error";
    private static final KeyAction.CommandMap[] KEY_COMMANDS = new KeyAction.CommandMap[]{new KeyAction.CommandMap(KeyStroke.getKeyStroke(127, 128), "clear"), new KeyAction.CommandMap(KeyStroke.getKeyStroke(27, 0), "close")};
    private static Point location;
    private ExpressionField expressionField;
    private JButton colourButton;
    private ColourButton[] functionColourButtons;
    private JButton pasteButton;
    private boolean accepted;

    private FunctionDialog(Window window, String string, Color color, String string2) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        Object object;
        JComponent jComponent;
        this.setIconImages(AppIcon.getAppIconImages());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        GuiUtilities.setPaddedLineBorder(jPanel);
        int n = 0;
        FLabel fLabel = new FLabel(COLOUR_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(fLabel, gridBagConstraints);
        jPanel.add(fLabel);
        JPanel jPanel2 = new JPanel(gridBagLayout);
        this.colourButton = new JButton(new ColourSampleIcon(40, 16));
        this.colourButton.setMargin(COLOUR_BUTTON_MARGINS);
        this.colourButton.setForeground(color);
        this.colourButton.setActionCommand("chooseColour");
        this.colourButton.addActionListener(this);
        fLabel.setDisplayedMnemonic(76);
        fLabel.setLabelFor(this.colourButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.colourButton, gridBagConstraints);
        jPanel2.add(this.colourButton);
        int n2 = 0;
        FunctionDocument functionDocument = App.getInstance().getDocument();
        if (functionDocument != null) {
            n2 = functionDocument.getNumFunctions();
        }
        if (n2 > 0) {
            jComponent = new JPanel(new GridLayout(1, 0, 0, 0));
            this.functionColourButtons = new ColourButton[n2];
            for (int i = 0; i < this.functionColourButtons.length; ++i) {
                object = functionDocument.getFunction(i);
                this.functionColourButtons[i] = new ColourButton(((Function)object).getColour());
                this.functionColourButtons[i].setToolTipText(((Function)object).getExpression().toString());
                this.functionColourButtons[i].setActionCommand("setToFunctionColour" + i);
                this.functionColourButtons[i].addActionListener(this);
                jComponent.add(this.functionColourButtons[i]);
            }
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel2.add(jComponent);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        jComponent = new FLabel(EXPRESSION_STR);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        this.expressionField = new ExpressionField(512, string2);
        ((JLabel)jComponent).setDisplayedMnemonic(69);
        ((JLabel)jComponent).setLabelFor(this.expressionField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = AppConstants.COMPONENT_INSETS;
        gridBagLayout.setConstraints(this.expressionField, gridBagConstraints);
        jPanel.add(this.expressionField);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 0, 8, 0));
        object = new FButton(COPY_STR);
        ((AbstractButton)object).setMnemonic(67);
        ((JComponent)object).setToolTipText(COPY_TOOLTIP_STR);
        ((AbstractButton)object).setActionCommand("copy");
        ((AbstractButton)object).addActionListener(this);
        if (!AppConfig.getInstance().hasPermissionAccessClipboard()) {
            ((AbstractButton)object).setEnabled(false);
        }
        jPanel3.add((Component)object);
        this.pasteButton = new FButton(PASTE_STR);
        this.pasteButton.setMnemonic(80);
        this.pasteButton.setToolTipText(PASTE_TOOLTIP_STR);
        this.pasteButton.setActionCommand("paste");
        this.pasteButton.addActionListener(this);
        this.pasteButton.setEnabled(false);
        this.flavorsChanged(null);
        jPanel3.add(this.pasteButton);
        FButton fButton = new FButton(CLEAR_STR);
        fButton.setMnemonic(69);
        fButton.setToolTipText(CLEAR_TOOLTIP_STR);
        fButton.setActionCommand("clear");
        fButton.addActionListener(this);
        jPanel3.add(fButton);
        JPanel jPanel4 = new JPanel(new GridLayout(1, 0, 8, 0));
        FButton fButton2 = new FButton("OK");
        fButton2.setActionCommand("accept");
        fButton2.addActionListener(this);
        jPanel4.add(fButton2);
        FButton fButton3 = new FButton("Cancel");
        fButton3.setActionCommand("close");
        fButton3.addActionListener(this);
        jPanel4.add(fButton3);
        JPanel jPanel5 = new JPanel(gridBagLayout);
        jPanel5.setBorder(BorderFactory.createEmptyBorder(2, 24, 3, 24));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel5.add(jPanel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel5.add(jPanel4);
        JPanel jPanel6 = new JPanel(gridBagLayout);
        jPanel6.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel6.add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel6.add(jPanel5);
        KeyAction.create((JComponent)jPanel6, 1, KEY_COMMANDS, (ActionListener)this);
        this.setContentPane(jPanel6);
        App.applyOrientationByLocale(this);
        try {
            this.getToolkit().getSystemClipboard().addFlavorListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowEventHandler());
        this.setResizable(false);
        this.pack();
        if (location == null) {
            location = GuiUtilities.getComponentLocation((Component)this, window);
        }
        this.setLocation(location);
        this.getRootPane().setDefaultButton(fButton2);
        this.expressionField.requestFocusInWindow();
        this.setVisible(true);
    }

    public static FunctionDialog showDialog(Component component, String string, Color color, String string2) {
        return new FunctionDialog(GuiUtilities.getWindow(component), string, color, string2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("chooseColour")) {
            this.doChooseColour();
        } else if (string.startsWith("setToFunctionColour")) {
            this.doSetToFunctionColour(string.substring("setToFunctionColour".length()));
        } else if (string.equals("copy")) {
            this.doCopy();
        } else if (string.equals("paste")) {
            this.doPaste();
        } else if (string.equals("clear")) {
            this.doClear();
        } else if (string.equals("accept")) {
            this.doAccept();
        } else if (string.equals("close")) {
            this.doClose();
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        try {
            this.pasteButton.setEnabled(this.getToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public Color getColour() {
        return this.colourButton.getForeground();
    }

    public Expression getExpression() {
        Expression expression = null;
        try {
            expression = this.expressionField.getExpression();
        }
        catch (Expression.Exception exception) {
            exception.printStackTrace();
        }
        return expression;
    }

    private void validateValues() throws AppException {
        try {
            this.expressionField.getExpression();
        }
        catch (Expression.Exception exception) {
            this.expressionField.requestFocusInWindow();
            this.expressionField.setCaretPosition(exception.getPos());
            throw exception;
        }
    }

    private void doChooseColour() {
        Color color = JColorChooser.showDialog(this, COLOUR_TITLE_STR, this.colourButton.getForeground());
        if (color != null) {
            this.colourButton.setForeground(color);
        }
    }

    private void doSetToFunctionColour(String string) {
        this.colourButton.setForeground(this.functionColourButtons[Integer.parseInt(string)].getForeground());
    }

    private void doCopy() {
        try {
            try {
                StringSelection stringSelection = new StringSelection(this.expressionField.getText());
                this.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
            catch (IllegalStateException illegalStateException) {
                throw new AppException(ErrorId.CLIPBOARD_UNAVAILABLE);
            }
        }
        catch (AppException appException) {
            JOptionPane.showMessageDialog(this, appException, "FuncPlotter", 0);
        }
    }

    private void doPaste() {
        try {
            try {
                this.expressionField.setText((String)this.getToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor));
            }
            catch (IllegalStateException illegalStateException) {
                throw new AppException(ErrorId.CLIPBOARD_UNAVAILABLE);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                throw new AppException(ErrorId.NO_TEXT_ON_CLIPBOARD);
            }
            catch (IOException iOException) {
                throw new AppException((AppException.Id)ErrorId.FAILED_TO_GET_CLIPBOARD_DATA, (Throwable)iOException);
            }
        }
        catch (AppException appException) {
            JOptionPane.showMessageDialog(this, appException, "FuncPlotter", 0);
        }
    }

    private void doClear() {
        this.expressionField.setText(null);
    }

    private void doAccept() {
        try {
            this.validateValues();
            this.accepted = true;
            this.doClose();
        }
        catch (AppException appException) {
            JOptionPane.showMessageDialog(this, appException, "FuncPlotter | Syntax Error", 0);
        }
    }

    private void doClose() {
        try {
            this.getToolkit().getSystemClipboard().removeFlavorListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        location = this.getLocation();
        this.setVisible(false);
        this.dispose();
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            FunctionDialog.this.doClose();
        }
    }

    private static class ExpressionField
    extends SurrogateMinus.Field {
        private static final int NUM_COLUMNS = 80;
        private static final String VALID_CHARS = " %()*+./\\^";

        public ExpressionField(int n) {
            super(n, 80);
        }

        public ExpressionField(int n, String string) {
            this(n);
            this.setText(string);
        }

        @Override
        protected int getColumnWidth() {
            return GuiUtilities.getCharWidth(48, this.getFontMetrics(this.getFont()));
        }

        @Override
        protected String translateInsertString(String string, int n) {
            return super.translateInsertString(string, n).toLowerCase();
        }

        @Override
        protected boolean acceptCharacter(char c, int n) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || this.isMinusCharacter(c) || VALID_CHARS.indexOf(c) >= 0;
        }

        public Expression getExpression() throws Expression.Exception {
            return new Expression(this.getText());
        }
    }

    private static class ColourButton
    extends JButton {
        private static final int WIDTH = 18;
        private static final int HEIGHT = 18;
        private static final Color BORDER_COLOUR = Color.GRAY;
        private static final Color FOCUSED_BORDER_COLOUR1 = new Color(192, 0, 80);
        private static final Color FOCUSED_BORDER_COLOUR2 = Color.WHITE;

        private ColourButton(Color color) {
            this.setBorder(null);
            this.setForeground(color);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(18, 18);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(this.getForeground());
            graphics.fillRect(2, 2, n - 4, n2 - 4);
            graphics.setColor(this.isFocusOwner() ? FOCUSED_BORDER_COLOUR1 : this.getBackground());
            graphics.drawRect(0, 0, n - 1, n2 - 1);
            graphics.setColor(this.isFocusOwner() ? FOCUSED_BORDER_COLOUR2 : BORDER_COLOUR);
            graphics.drawRect(1, 1, n - 3, n2 - 3);
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        CLIPBOARD_UNAVAILABLE("The clipboard is currently unavailable."),
        NO_TEXT_ON_CLIPBOARD("There is no text on the clipboard."),
        FAILED_TO_GET_CLIPBOARD_DATA("Failed to get data from the clipboard.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    private static interface Command {
        public static final String CHOOSE_COLOUR = "chooseColour";
        public static final String SET_TO_FUNCTION_COLOUR = "setToFunctionColour";
        public static final String COPY = "copy";
        public static final String PASTE = "paste";
        public static final String CLEAR = "clear";
        public static final String ACCEPT = "accept";
        public static final String CLOSE = "close";
    }
}

