/*
 * Decompiled with CFR 0.152.
 */
package smile.wavelet;

import java.util.Arrays;
import smile.math.Math;

public class Wavelet {
    private int ncof;
    private int ioff;
    private int joff;
    private double[] cc;
    private double[] cr;
    private double[] workspace = new double[1024];

    public Wavelet(double[] coefficients) {
        this.ncof = coefficients.length;
        this.ioff = this.joff = -(this.ncof >> 1);
        this.cc = coefficients;
        double sig = -1.0;
        this.cr = new double[this.ncof];
        for (int i = 0; i < this.ncof; ++i) {
            this.cr[this.ncof - 1 - i] = sig * this.cc[i];
            sig = -sig;
        }
    }

    void forward(double[] a, int n) {
        if (n < this.ncof) {
            return;
        }
        if (n > this.workspace.length) {
            this.workspace = new double[n];
        } else {
            Arrays.fill(this.workspace, 0, n, 0.0);
        }
        int nmod = this.ncof * n;
        int n1 = n - 1;
        int nh = n >> 1;
        int ii = 0;
        int i = 0;
        while (i < n) {
            int ni = i + 1 + nmod + this.ioff;
            int nj = i + 1 + nmod + this.joff;
            for (int k = 0; k < this.ncof; ++k) {
                int jf = n1 & ni + k + 1;
                int jr = n1 & nj + k + 1;
                int n2 = ii;
                this.workspace[n2] = this.workspace[n2] + this.cc[k] * a[jf];
                int n3 = ii + nh;
                this.workspace[n3] = this.workspace[n3] + this.cr[k] * a[jr];
            }
            i += 2;
            ++ii;
        }
        System.arraycopy(this.workspace, 0, a, 0, n);
    }

    void backward(double[] a, int n) {
        if (n < this.ncof) {
            return;
        }
        if (n > this.workspace.length) {
            this.workspace = new double[n];
        } else {
            Arrays.fill(this.workspace, 0, n, 0.0);
        }
        int nmod = this.ncof * n;
        int n1 = n - 1;
        int nh = n >> 1;
        int ii = 0;
        int i = 0;
        while (i < n) {
            double ai = a[ii];
            double ai1 = a[ii + nh];
            int ni = i + 1 + nmod + this.ioff;
            int nj = i + 1 + nmod + this.joff;
            for (int k = 0; k < this.ncof; ++k) {
                int jf = n1 & ni + k + 1;
                int jr = n1 & nj + k + 1;
                int n2 = jf;
                this.workspace[n2] = this.workspace[n2] + this.cc[k] * ai;
                int n3 = jr;
                this.workspace[n3] = this.workspace[n3] + this.cr[k] * ai1;
            }
            i += 2;
            ++ii;
        }
        System.arraycopy(this.workspace, 0, a, 0, n);
    }

    public void transform(double[] a) {
        int n = a.length;
        if (!Math.isPower2(n)) {
            throw new IllegalArgumentException("The data vector size is not a power of 2.");
        }
        if (n < this.ncof) {
            throw new IllegalArgumentException("The data vector size is less than wavelet coefficient size.");
        }
        for (int nn = n; nn >= this.ncof; nn >>= 1) {
            this.forward(a, nn);
        }
    }

    public void inverse(double[] a) {
        int start;
        int n = a.length;
        if (!Math.isPower2(n)) {
            throw new IllegalArgumentException("The data vector size is not a power of 2.");
        }
        if (n < this.ncof) {
            throw new IllegalArgumentException("The data vector size is less than wavelet coefficient size.");
        }
        for (int nn = start = n >> (int)Math.floor(Math.log2(n / (this.ncof - 1))); nn <= n; nn <<= 1) {
            this.backward(a, nn);
        }
    }
}

