/*
 * Decompiled with CFR 0.152.
 */
package smile.vq;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import smile.clustering.Clustering;
import smile.clustering.HierarchicalClustering;
import smile.clustering.linkage.UPGMALinkage;
import smile.math.Math;
import smile.sort.HeapSelect;
import smile.stat.distribution.GaussianDistribution;

public class NeuralMap
implements Clustering<double[]> {
    private int d;
    private double r;
    private double epsBest = 0.05;
    private double epsNeighbor = 6.0E-4;
    private LSH lsh;
    private List<Neuron> neurons = new ArrayList<Neuron>();

    public NeuralMap(int d, double r, double epsBest, double epsNeighbor, int L, int k) {
        this.d = d;
        this.r = r;
        this.epsBest = epsBest;
        this.epsNeighbor = epsNeighbor;
        this.lsh = new LSH(L, k, 4.0 * r);
    }

    public void update(double[] x) {
        Neighbor[] top2 = new Neighbor[2];
        int k = this.lsh.knn(x, top2);
        double dist = Double.MAX_VALUE;
        Neuron neuron = null;
        if (k == 0) {
            neuron = new Neuron((double[])x.clone());
            this.lsh.add(neuron);
            this.neurons.add(neuron);
            return;
        }
        if (k == 1) {
            dist = top2[0].distance;
            if (dist <= this.r) {
                neuron = top2[0].neuron;
                ++neuron.n;
                this.lsh.remove(neuron);
                for (int i = 0; i < this.d; ++i) {
                    int n = i;
                    neuron.w[n] = neuron.w[n] + this.epsBest * (x[i] - neuron.w[i]);
                }
                this.lsh.add(neuron);
            } else {
                neuron = new Neuron((double[])x.clone());
                this.lsh.add(neuron);
                this.neurons.add(neuron);
                Neuron second = top2[0].neuron;
                neuron.neighbors.add(second);
                second.neighbors.add(neuron);
            }
        } else {
            dist = top2[1].distance;
            if (dist <= this.r) {
                neuron = top2[1].neuron;
                this.lsh.remove(neuron);
                for (int i = 0; i < this.d; ++i) {
                    int n = i;
                    neuron.w[n] = neuron.w[n] + this.epsBest * (x[i] - neuron.w[i]);
                }
                this.lsh.add(neuron);
                Neuron second = top2[0].neuron;
                ++second.n;
                boolean connected = false;
                for (Neuron neighbor : neuron.neighbors) {
                    if (neighbor != second) continue;
                    connected = true;
                    break;
                }
                if (!connected) {
                    neuron.neighbors.add(second);
                    second.neighbors.add(neuron);
                }
            } else {
                neuron = new Neuron((double[])x.clone());
                this.lsh.add(neuron);
                this.neurons.add(neuron);
                Neuron second = top2[1].neuron;
                neuron.neighbors.add(second);
                second.neighbors.add(neuron);
            }
        }
        Iterator iter = neuron.neighbors.iterator();
        while (iter.hasNext()) {
            Neuron neighbor = (Neuron)iter.next();
            this.lsh.remove(neighbor);
            for (int i = 0; i < this.d; ++i) {
                int n = i;
                neighbor.w[n] = neighbor.w[n] + this.epsNeighbor * (x[i] - neighbor.w[i]);
            }
            if (Math.distance(neuron.w, neighbor.w) > 2.0 * this.r) {
                neighbor.neighbors.remove(neuron);
                iter.remove();
            }
            if (!neighbor.neighbors.isEmpty()) {
                this.lsh.add(neighbor);
                continue;
            }
            this.neurons.remove(neighbor);
        }
        if (neuron.neighbors.isEmpty()) {
            this.lsh.remove(neuron);
            this.neurons.remove(neuron);
        }
    }

    public List<Neuron> neurons() {
        return this.neurons;
    }

    public int purge(int minPts) {
        ArrayList<Neuron> outliers = new ArrayList<Neuron>();
        for (Neuron neuron : this.neurons) {
            if (neuron.n >= minPts) continue;
            outliers.add(neuron);
        }
        this.neurons.removeAll(outliers);
        for (Neuron neuron : this.neurons) {
            neuron.neighbors.removeAll(outliers);
        }
        outliers.clear();
        for (Neuron neuron : this.neurons) {
            if (!neuron.neighbors.isEmpty()) continue;
            outliers.add(neuron);
        }
        this.neurons.removeAll(outliers);
        return this.neurons.size();
    }

    public void partition(int k) {
        this.partition(k, 0);
    }

    public int partition(int k, int minPts) {
        ArrayList<Neuron> data = new ArrayList<Neuron>();
        for (Neuron neuron : this.neurons) {
            neuron.y = Integer.MAX_VALUE;
            if (neuron.n < minPts) continue;
            data.add(neuron);
        }
        double[][] proximity = new double[data.size()][];
        for (int i = 0; i < data.size(); ++i) {
            proximity[i] = new double[i + 1];
            for (int j = 0; j < i; ++j) {
                proximity[i][j] = Math.distance(((Neuron)data.get((int)i)).w, ((Neuron)data.get((int)j)).w);
            }
        }
        UPGMALinkage linkage = new UPGMALinkage(proximity);
        HierarchicalClustering hc = new HierarchicalClustering(linkage);
        int[] y = hc.partition(k);
        for (int i = 0; i < data.size(); ++i) {
            ((Neuron)data.get((int)i)).y = y[i];
        }
        return data.size();
    }

    @Override
    public int predict(double[] x) {
        double minDist = Double.MAX_VALUE;
        int bestCluster = 0;
        for (Neuron neuron : this.neurons) {
            double dist = Math.squaredDistance(x, neuron.w);
            if (!(dist < minDist)) continue;
            minDist = dist;
            bestCluster = neuron.y;
        }
        return bestCluster;
    }

    class LSH {
        Hash[] hash;
        int H;
        int k;
        double w;
        int[] c;
        int P = Integer.MAX_VALUE;

        LSH(int L, int k, double w) {
            this(L, k, w, 1017881);
        }

        LSH(int L, int k, double w, int H) {
            int i;
            this.k = k;
            this.w = w;
            this.H = H;
            this.hash = new Hash[L];
            this.c = new int[k];
            for (i = 0; i < this.c.length; ++i) {
                this.c[i] = Math.randomInt(this.P);
            }
            for (i = 0; i < L; ++i) {
                this.hash[i] = new Hash();
            }
        }

        void add(Neuron neuron) {
            for (int i = 0; i < this.hash.length; ++i) {
                this.hash[i].add(neuron);
            }
        }

        void remove(Neuron neuron) {
            block0: for (int i = 0; i < this.hash.length; ++i) {
                int bucket = this.hash[i].hash(neuron.w);
                LinkedList<Hash.Item> bin = this.hash[i].table[bucket % this.H];
                if (bin == null) continue;
                for (Hash.Item e : bin) {
                    if (e.bucket != bucket || e.neuron != neuron) continue;
                    bin.remove(e);
                    continue block0;
                }
            }
        }

        Neighbor nearest(double[] x) {
            Neighbor neighbor = new Neighbor(null, Double.MAX_VALUE);
            for (int i = 0; i < this.hash.length; ++i) {
                int bucket = this.hash[i].hash(x);
                LinkedList<Hash.Item> bin = this.hash[i].table[bucket % this.H];
                if (bin == null) continue;
                for (Hash.Item e : bin) {
                    double distance;
                    if (e.bucket != bucket || !((distance = Math.distance(x, e.neuron.w)) < neighbor.distance)) continue;
                    neighbor.distance = distance;
                    neighbor.neuron = e.neuron;
                }
            }
            return neighbor;
        }

        int knn(double[] x, Neighbor[] neighbors) {
            int hit = 0;
            HeapSelect heap = new HeapSelect((Comparable[])neighbors);
            for (int i = 0; i < this.hash.length; ++i) {
                int bucket = this.hash[i].hash(x);
                LinkedList<Hash.Item> bin = this.hash[i].table[bucket % this.H];
                if (bin == null) continue;
                for (Hash.Item e : bin) {
                    if (e.bucket != bucket) continue;
                    boolean existed = false;
                    for (Neighbor n : neighbors) {
                        if (n == null || e.neuron != n.neuron) continue;
                        existed = true;
                        break;
                    }
                    if (existed) continue;
                    double distance = Math.distance(x, e.neuron.w);
                    if (heap.peek() != null && !(distance < ((Neighbor)heap.peek()).distance)) continue;
                    heap.add(new Neighbor(e.neuron, distance));
                    ++hit;
                }
            }
            return hit;
        }

        class Hash {
            double[][] a;
            double[] b;
            LinkedList<Item>[] table;

            Hash() {
                this.a = new double[LSH.this.k][NeuralMap.this.d];
                this.b = new double[LSH.this.k];
                for (int i = 0; i < LSH.this.k; ++i) {
                    for (int j = 0; j < NeuralMap.this.d; ++j) {
                        this.a[i][j] = GaussianDistribution.getInstance().rand();
                    }
                    this.b[i] = Math.random(0.0, LSH.this.w);
                }
                LinkedList list = new LinkedList();
                this.table = (LinkedList[])Array.newInstance(list.getClass(), LSH.this.H);
            }

            double hash(double[] x, int m) {
                double r = this.b[m];
                for (int j = 0; j < NeuralMap.this.d; ++j) {
                    r += this.a[m][j] * x[j];
                }
                return r / LSH.this.w;
            }

            int hash(double[] x) {
                long r = 0L;
                for (int i = 0; i < LSH.this.k; ++i) {
                    double ri = this.hash(x, i);
                    r += (long)(LSH.this.c[i] * (int)Math.floor(ri));
                }
                int h = (int)(r % (long)LSH.this.P);
                if (h < 0) {
                    h += LSH.this.P;
                }
                return h;
            }

            void add(Neuron neuron) {
                int bucket = this.hash(neuron.w);
                int i = bucket % LSH.this.H;
                if (this.table[i] == null) {
                    this.table[i] = new LinkedList();
                }
                this.table[i].add(new Item(bucket, neuron));
            }

            class Item {
                int bucket;
                Neuron neuron;

                Item(int bucket, Neuron neuron) {
                    this.bucket = bucket;
                    this.neuron = neuron;
                }
            }
        }
    }

    class Neighbor
    implements Comparable<Neighbor> {
        Neuron neuron;
        double distance;

        Neighbor(Neuron neuron, double distance) {
            this.neuron = neuron;
            this.distance = distance;
        }

        @Override
        public int compareTo(Neighbor o) {
            return (int)Math.signum(this.distance - o.distance);
        }
    }

    public static class Neuron {
        public int n = 1;
        public int y = Integer.MAX_VALUE;
        public final double[] w;
        public final LinkedList<Neuron> neighbors = new LinkedList();

        public Neuron(double[] w) {
            this.w = w;
        }
    }
}

