/*
 * Decompiled with CFR 0.152.
 */
package smile.symbolic.internal;

import smile.symbolic.internal.BinaryNode;
import smile.symbolic.internal.Constant;
import smile.symbolic.internal.Difference;
import smile.symbolic.internal.Expression;
import smile.symbolic.internal.Product;

public class Quotient
extends BinaryNode {
    public Quotient(Expression left, Expression right) {
        super(left, right, Expression.BinaryOperator.DIVIDE);
    }

    @Override
    public Expression derive() {
        return new Quotient(new Difference(new Product(this.left.derive(), this.right), new Product(this.left, this.right.derive())), new Product(this.right, this.right));
    }

    @Override
    public Expression reduce() {
        Expression n = this.left.reduce();
        Expression d = this.right.reduce();
        if (n.getType().equals("0") || d.getType().equals("1")) {
            return n;
        }
        if (n.equals(d)) {
            return new Constant(1.0);
        }
        if (d instanceof Quotient) {
            if (n instanceof Quotient) {
                return new Quotient(new Product(n.getLeftChild(), d.getRightChild()), new Product(d.getLeftChild(), n.getRightChild())).reduce();
            }
            return new Quotient(new Product(n, d.getRightChild()), d.getRightChild()).reduce();
        }
        if (n instanceof Quotient) {
            return new Quotient(n.getLeftChild(), new Product(d, n.getRightChild())).reduce();
        }
        return new Quotient(n, d);
    }

    @Override
    public double getValue() {
        return 0.0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Expression)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Expression t = this.reduce();
        Expression o = ((Expression)object).reduce();
        if (!(t instanceof Quotient)) {
            return t.equals(o);
        }
        if (!(o instanceof Quotient)) {
            return false;
        }
        Quotient qt = (Quotient)t;
        Quotient qo = (Quotient)o;
        return qt.getLeftChild().equals(qo.getLeftChild()) && qt.getRightChild().equals(qo.getRightChild());
    }
}

