/*
 * Decompiled with CFR 0.152.
 */
package smile.symbolic.internal;

import smile.symbolic.internal.BinaryNode;
import smile.symbolic.internal.Constant;
import smile.symbolic.internal.Exponent;
import smile.symbolic.internal.Expression;
import smile.symbolic.internal.Quotient;
import smile.symbolic.internal.Sum;

public class Product
extends BinaryNode {
    public Product(Expression left, Expression right) {
        super(left, right, Expression.BinaryOperator.MULTIPLY);
    }

    @Override
    public Expression derive() {
        Expression l = this.left.derive();
        Expression r = this.right.derive();
        return new Sum(new Product(l, this.right), new Product(this.left, r));
    }

    @Override
    public Expression reduce() {
        Expression tmp;
        Expression l = this.left.reduce();
        Expression r = this.right.reduce();
        if (l instanceof Constant || r instanceof Constant) {
            if (l.getType().equals("1")) {
                return r;
            }
            if (r.getType().equals("1")) {
                return l;
            }
            if (l.getType().equals("0")) {
                return l;
            }
            if (r.getType().equals("0")) {
                return r;
            }
            if (l instanceof Constant && r instanceof Constant) {
                return new Constant(l.getValue() * r.getValue());
            }
            if (!(l instanceof Constant)) {
                tmp = l;
                l = r;
                r = tmp;
            }
        }
        if (l instanceof Exponent) {
            tmp = l;
            l = r;
            r = tmp;
        }
        if (!(r instanceof Product) || l instanceof Product) {
            // empty if block
        }
        if (r instanceof Product && l instanceof Constant) {
            if (r.getLeftChild() instanceof Constant) {
                return new Product(new Constant(l.getValue() * r.getLeftChild().getValue()), r.getRightChild());
            }
            if (r.getRightChild() instanceof Constant) {
                return new Product(new Constant(l.getValue() * r.getRightChild().getValue()), r.getLeftChild());
            }
        }
        if (l instanceof Product && r instanceof Constant) {
            if (l.getLeftChild() instanceof Constant) {
                return new Product(new Constant(r.getValue() * l.getLeftChild().getValue()), l.getRightChild());
            }
            if (l.getRightChild() instanceof Constant) {
                return new Product(new Constant(r.getValue() * l.getRightChild().getValue()), l.getLeftChild());
            }
        }
        if (r instanceof Quotient) {
            Expression numerator = r.getLeftChild().getType().equals("1") ? this.left : new Product(this.left, r.getLeftChild());
            return new Quotient(numerator, r.getRightChild());
        }
        return new Product(l, r);
    }

    @Override
    public double getValue() {
        if (this.left instanceof Constant) {
            return this.left.getValue();
        }
        if (this.right instanceof Constant) {
            return this.right.getValue();
        }
        return 0.0;
    }
}

