/*
 * Decompiled with CFR 0.152.
 */
package smile.swing.table;

import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;

public class NumberCellRenderer
extends DefaultTableCellRenderer {
    public static final NumberCellRenderer INTEGER = new NumberCellRenderer(NumberFormat.getIntegerInstance());
    public static final NumberCellRenderer NUMBER = new NumberCellRenderer(NumberFormat.getNumberInstance());
    public static final NumberCellRenderer PERCENT = new NumberCellRenderer(NumberFormat.getPercentInstance());
    public static final NumberCellRenderer CURRENCY = new NumberCellRenderer(NumberFormat.getCurrencyInstance());
    private NumberFormat numberFormat;

    public NumberCellRenderer() {
        this.numberFormat = NumberFormat.getInstance();
        this.init();
    }

    public NumberCellRenderer(int precision) {
        this.numberFormat = NumberFormat.getNumberInstance();
        this.init();
        this.numberFormat.setMinimumFractionDigits(precision);
    }

    public NumberCellRenderer(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.init();
    }

    private void init() {
        this.setHorizontalAlignment(4);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public void setValue(Object value) {
        this.setText(value == null ? "" : this.numberFormat.format(value));
    }
}

