/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.io.Serializable;
import smile.math.Math;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;
import smile.math.special.Beta;
import smile.regression.Regression;
import smile.regression.RegressionTrainer;

public class RidgeRegression
implements Regression<double[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int p;
    private double lambda;
    private double b;
    private double[] w;
    private double ym;
    private double[] center;
    private double[] scale;
    private double[][] coefficients;
    private double[] residuals;
    private double RSS;
    private double error;
    private int df;
    private double RSquared;
    private double adjustedRSquared;
    private double F;
    private double pvalue;

    public RidgeRegression(double[][] x, double[] y, double lambda) {
        int i;
        int j;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("Invalid shrinkage/regularization parameter lambda = " + lambda);
        }
        int n = x.length;
        this.p = x[0].length;
        if (n <= this.p) {
            throw new IllegalArgumentException(String.format("The input matrix is not over determined: %d rows, %d columns", n, this.p));
        }
        this.ym = Math.mean(y);
        this.center = Math.colMeans(x);
        DenseMatrix X = Matrix.zeros(n, this.p);
        for (int i2 = 0; i2 < n; ++i2) {
            for (int j2 = 0; j2 < this.p; ++j2) {
                X.set(i2, j2, x[i2][j2] - this.center[j2]);
            }
        }
        this.scale = new double[this.p];
        for (j = 0; j < this.p; ++j) {
            for (i = 0; i < n; ++i) {
                int n2 = j;
                this.scale[n2] = this.scale[n2] + Math.sqr(X.get(i, j));
            }
            this.scale[j] = Math.sqrt(this.scale[j] / (double)n);
        }
        for (j = 0; j < this.p; ++j) {
            if (Math.isZero(this.scale[j])) continue;
            for (i = 0; i < n; ++i) {
                X.div(i, j, this.scale[j]);
            }
        }
        this.w = new double[this.p];
        X.atx(y, this.w);
        DenseMatrix XtX = X.ata();
        for (i = 0; i < this.p; ++i) {
            XtX.add(i, i, lambda);
        }
        Cholesky cholesky = XtX.cholesky();
        cholesky.solve(this.w);
        for (int j3 = 0; j3 < this.p; ++j3) {
            if (Math.isZero(this.scale[j3])) continue;
            int n3 = j3;
            this.w[n3] = this.w[n3] / this.scale[j3];
        }
        this.b = this.ym - Math.dot(this.w, this.center);
        double[] yhat = new double[n];
        Matrix.newInstance(x).ax(this.w, yhat);
        double TSS = 0.0;
        this.RSS = 0.0;
        double ybar = Math.mean(y);
        this.residuals = new double[n];
        for (int i3 = 0; i3 < n; ++i3) {
            double r;
            this.residuals[i3] = r = y[i3] - yhat[i3] - this.b;
            this.RSS += Math.sqr(r);
            TSS += Math.sqr(y[i3] - ybar);
        }
        this.error = Math.sqrt(this.RSS / (double)(n - this.p - 1));
        this.df = n - this.p - 1;
        this.RSquared = 1.0 - this.RSS / TSS;
        this.adjustedRSquared = 1.0 - (1.0 - this.RSquared) * (double)(n - 1) / (double)(n - this.p - 1);
        this.F = (TSS - this.RSS) * (double)(n - this.p - 1) / (this.RSS * (double)this.p);
        int df1 = this.p;
        int df2 = n - this.p - 1;
        this.pvalue = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df2, 0.5 * (double)df1, (double)df2 / ((double)df2 + (double)df1 * this.F));
        DenseMatrix inv = cholesky.inverse();
        this.coefficients = new double[this.p][4];
        for (int i4 = 0; i4 < this.p; ++i4) {
            double t;
            double se;
            this.coefficients[i4][0] = this.w[i4];
            this.coefficients[i4][1] = se = this.error * Math.sqrt(inv.get(i4, i4));
            this.coefficients[i4][2] = t = this.w[i4] / se;
            this.coefficients[i4][3] = Beta.regularizedIncompleteBetaFunction(0.5 * (double)this.df, 0.5, (double)this.df / ((double)this.df + t * t));
        }
    }

    public double[] coefficients() {
        return this.w;
    }

    public double intercept() {
        return this.b;
    }

    public double shrinkage() {
        return this.lambda;
    }

    @Override
    public double predict(double[] x) {
        if (x.length != this.p) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.p));
        }
        return Math.dot(x, this.w) + this.b;
    }

    public double[][] ttest() {
        return this.coefficients;
    }

    public double[] residuals() {
        return this.residuals;
    }

    public double RSS() {
        return this.RSS;
    }

    public double error() {
        return this.error;
    }

    public int df() {
        return this.df;
    }

    public double RSquared() {
        return this.RSquared;
    }

    public double adjustedRSquared() {
        return this.adjustedRSquared;
    }

    public double ftest() {
        return this.F;
    }

    public double pvalue() {
        return this.pvalue;
    }

    private String significance(double pvalue) {
        if (pvalue < 0.001) {
            return "***";
        }
        if (pvalue < 0.01) {
            return "**";
        }
        if (pvalue < 0.05) {
            return "*";
        }
        if (pvalue < 0.1) {
            return ".";
        }
        return "";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Ridge Regression:\n");
        double[] r = (double[])this.residuals.clone();
        builder.append("\nResiduals:\n");
        builder.append("\t       Min\t        1Q\t    Median\t        3Q\t       Max\n");
        builder.append(String.format("\t%10.4f\t%10.4f\t%10.4f\t%10.4f\t%10.4f%n", Math.min(r), Math.q1(r), Math.median(r), Math.q3(r), Math.max(r)));
        builder.append("\nCoefficients:\n");
        builder.append("            Estimate        Std. Error        t value        Pr(>|t|)\n");
        builder.append(String.format("Intercept%11.4f                NA             NA              NA%n", this.b));
        for (int i = 0; i < this.p; ++i) {
            builder.append(String.format("Var %d\t %11.4f%18.4f%15.4f%16.4f %s%n", i + 1, this.coefficients[i][0], this.coefficients[i][1], this.coefficients[i][2], this.coefficients[i][3], this.significance(this.coefficients[i][3])));
        }
        builder.append("---------------------------------------------------------------------\n");
        builder.append("Significance codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1\n");
        builder.append(String.format("\nResidual standard error: %.4f on %d degrees of freedom%n", this.error, this.df));
        builder.append(String.format("Multiple R-squared: %.4f,    Adjusted R-squared: %.4f%n", this.RSquared, this.adjustedRSquared));
        builder.append(String.format("F-statistic: %.4f on %d and %d DF,  p-value: %.4g%n", this.F, this.p, this.df, this.pvalue));
        return builder.toString();
    }

    public static class Trainer
    extends RegressionTrainer<double[]> {
        private double lambda;

        public Trainer(double lambda) {
            if (lambda < 0.0) {
                throw new IllegalArgumentException("Invalid shrinkage/regularization parameter lambda = " + lambda);
            }
            this.lambda = lambda;
        }

        public RidgeRegression train(double[][] x, double[] y) {
            return new RidgeRegression(x, y, this.lambda);
        }
    }
}

