/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.parser.ArffParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.math.kernel.GaussianKernel;
import smile.math.kernel.MercerKernel;
import smile.projection.KPCA;

public class KPCATest {
    double[] latent = new double[]{0.324837733, 0.1190608662, 0.0354473602, 0.0248222741, 0.020681794, 0.0126434107, 0.0086918118, 0.0049665015, 0.0038173621, 0.0036946774, 0.0033387912, 0.0027999074, 0.002019376, 0.0013370193, 0.0012813389, 9.629088E-4, 9.310069E-4, 6.368355E-4, 4.813594E-4, 3.700926E-4, 3.220757E-4, 3.185161E-4, 2.594431E-4, 2.08769E-4, 1.859915E-4, 1.488966E-4, 1.421597E-4, 1.217172E-4, 1.156592E-4};
    double[][] scores = new double[][]{{-10.0979791656324, -0.692997265933912, 1.12969329653961, 0.649047148659402, -0.29310715534842, -0.239283255731145, -0.047274246806631, -0.077057777763598, -5.13445947576114E-4, 0.2928685362469, -0.0779406198264998, -0.249395416211564, -0.748843863949876, 0.374921852403731, -0.111931518607156, 0.100916844855065, 0.0708176432546577, 0.120859517180095, 0.0510705717408816, -0.160315822709653, -0.0352792239571769, -0.0724108995063577, 0.00394399131546079, -0.00466107081548298, 0.0253713395874898, 0.0346452072389977, 4.64714413056402E-4, -0.0347210080082545, 0.00920459078277162}, {-9.80577882574642, -0.444228718369616, -0.00816467174850868, -2.44526015680566, 1.48913292098369, 0.0505679416815199, 0.142774139540507, 0.134688782898112, -0.109027023568503, 1.35671785459491, 0.772599876031108, -0.0441293165932329, -0.334941426958855, -0.0285096885181663, 0.091044030670192, 0.0212112796161966, -0.0134955898064987, -0.030273398065606, 0.097441964969689, -0.271926809146569, -0.0639479472913199, -0.062563156918859, 0.0106545596911825, -0.00324484166624383, -0.183307730073134, -0.120219105866759, 0.11237391240539, 0.140786799016373, 0.186217079383599}, {-9.95221332926393, -0.859295558422995, 0.458670646883854, -2.51951509759249, 1.51710067999055, -0.236739071215125, -0.664027441812176, -0.461466282086972, 0.0582844953062473, -0.170823052045553, -0.241155764051138, 0.246085824160139, -0.459589499903796, 0.0406861401264391, -0.30270676241284, -0.00127849558167842, 0.00759439695994068, 0.057965005964771, -0.0196084022084887, 0.0228106013044832, -0.020253346935135, 0.00647338869443356, 0.00939129276784039, 0.0228618934885304, -0.0491307434103525, -0.0294493941022816, 0.0604197168211751, 0.0632053658760128, 0.123681436555483}, {-9.70782086681865, -0.461037945620176, -0.186299234905717, -3.193232602946, 1.80087531086424, 0.103270416387538, -0.287298170639277, 0.138955574776676, -0.0433762337840109, -0.420440926987484, -0.309729562826799, -0.100208755268945, 0.431617893559552, -0.07086667291833, 0.382588226335266, 0.0124356675260138, 0.129143740030059, 0.00252537622776539, 0.0562858489021309, 0.237323448764194, 0.211457548726782, 0.18093993242954, -0.0742220294994654, 0.123805732497819, -0.239471136069057, -0.0455022190312964, -0.0385398084099797, -0.0633850526275117, -0.0458697959629962}, {-10.0996775695659, -0.80485423875739, 1.23830408590069, 0.646123316843043, -0.339479619475624, -0.315143898053108, -0.31718282707147, -0.230584997613147, 0.075447969617991, -0.557549200451468, -0.607768407348382, -0.207182777484128, -0.590723815926886, 0.426800465254533, -0.131796155670958, 0.155693018806911, 0.0905265473003332, 0.103713604898382, 0.0368969388648281, -0.266883560273971, -0.0570587015346534, -0.0915391206939914, -0.0301975410325121, -0.0189361998759995, 0.0144996337658687, 0.0323559983318382, -0.0337309652231159, -0.0545986669855906, -0.0384280143207517}, {-9.1221441524404, -0.128655293939811, 1.18446002948979, 3.94638809584403, -2.1377695304572, 0.216409368119366, 0.429626490176872, 0.532704087666936, -0.161491534123783, -0.448440836254916, -0.182051344708842, -0.184874877783385, 1.04003965779476, -0.56421306210317, 0.1064180451815, -0.271515429531966, -0.252454020953428, -0.351091357759978, -0.0300176640790097, 0.142254862174602, -0.330759763489132, 0.0479666063111849, 0.145944243768914, 0.0120284867887048, 0.306547181835701, 0.046725288660855, 0.0560634068710735, 0.0802058624713928, 0.244486140069951}, {-9.91405887798145, -0.776348891090729, 0.525161590315062, -1.9625615116874, 1.0916743959673, -0.159564930568388, -0.747423605155669, -0.251060867504693, 0.0222756773865353, -1.52637549468065, -1.14884352372417, -0.106448087773225, 0.0669088795115406, 0.0817353242202505, -0.559679070213352, -0.0558313425566516, -0.332407356912822, -0.0742748280564511, -0.125965829784593, 0.192902509262711, 0.111716660337104, 0.124066430209955, -0.0177030144330519, 0.0846829786233024, -0.0606739781791931, -0.0176070344366343, -0.110962419872354, -0.0872734063701695, -0.154063886564751}, {-10.0785508310838, -0.454345394745687, 0.726656599904068, -0.184146637137241, 0.166380629404614, -0.0212848257094857, 0.092852435314594, 0.317325855496212, -0.130500349030537, 0.198834696716121, -0.275741768589902, -0.574874446891082, -0.358972227881504, 0.336033142375354, 0.18760683083785, 0.0555331232714551, 0.12620728681198, 0.0529264282827867, 0.0668435054956571, -0.0781590808551468, -0.0194654623329028, -0.0225333527709008, -0.016711992049469, 0.0109453993732984, -0.0343677806389803, 6.10288263516828E-4, 0.008467071167676, -0.0105629622572911, 0.0303659382548436}, {-9.21203910521835, -0.66349261812197, -0.582658857671111, -4.61907060340832, 2.63335025955876, 0.0297484614178161, -0.681158899355994, -0.415440113045078, 0.132302776227917, -0.459248903410298, 0.140322084108785, 0.798245285438928, 0.881942968015786, -0.618281424564167, 0.361968402679501, -0.0851177827158627, 0.144169474574133, -0.0704639337449072, 0.0197132945519881, 0.414148410388974, 0.179293808463233, 0.247263106321442, -0.0423772195513936, 0.0901146202498355, -0.0422504738212608, 0.0448808604992123, -0.0626666768194935, -0.137035879158561, -0.101746001889252}, {-9.87384503653197, -0.378520996328206, 0.091927533178001, -1.99421608279801, 1.22504614271717, 0.0728570313411145, 0.177535355514623, 0.324654572086644, -0.119637333530845, 0.992131637673205, 0.301252682698415, -0.377480891100445, -0.273634689929278, 0.293357659136179, 0.767947577957208, 0.112248531940932, 0.509906916146054, 0.127270055712126, 0.144626291455361, -0.0961541605403955, 0.00124473104680597, -0.0615096688788872, -0.0565285354528543, 0.0168545026885762, -0.20756740277824, -0.113716418044344, 0.0909272833322382, 0.126783723976427, 0.184137355756427}, {-9.64975811072074, -0.538520625015615, 1.37076500446408, 2.93491078540385, -1.54922168090106, -0.179147505947504, 0.345478565941435, 0.0269497595574481, 0.0338040734285699, 0.632929605398797, 0.370151293375317, -0.0578283023124318, -0.310799674952526, 0.149353397791884, 0.323939397486146, 0.0241039142619057, 0.293854100016201, 0.117291584338654, 0.0447313862314212, 0.136953223488327, -0.042315241749641, -0.00929335701665772, 2.1775444790536E-4, -0.0336833947698394, 0.254843456553245, 0.137905870752935, -0.0484458787988082, -0.0940843270343703, -0.0559293655050893}, {-9.96181028732276, -0.340052886907838, 0.396806652862297, -1.00676636679852, 0.547409356387922, 0.116259276777592, -0.0577891169805184, 0.521714682866157, -0.155477355623899, -0.772162870506852, -0.924417754356474, -0.781274848725945, 0.223396929283256, 0.324529195860562, 0.49182094970943, 0.0494455656871773, 0.200874267073718, 0.0253507523255806, 0.0734965095339888, 0.0627524931182498, 0.104683220014712, 0.0507241058875918, -0.0491594790615541, 0.0563514761910233, -0.127392195694093, -0.0133477024974374, -0.0411247158120768, -0.0878470289090933, -0.091583628002881}, {-9.770067994984, -0.579089715939744, -0.00285946338162428, -2.8897120568245, 1.74845757715816, -0.0310530263259475, -0.134603058174427, -0.056565207702839, -0.0242502295861455, 0.991730270828872, 0.510500269612099, 0.0881789582378859, -0.282145109729974, 0.0655922606915108, 0.569575211280975, 0.08252968314933, 0.436248277019921, 0.0960515570397019, 0.154167696463333, -0.155376178383803, -0.0510954422577173, -0.0741556453984683, -0.0246271548316623, 0.00485362568633991, -0.194566321307639, -0.118068911485846, 0.141475859235108, 0.144780387192344, 0.253725518572314}, {-9.06398822335438, -1.27732194197529, 0.0140619558767589, -4.62958076432196, 2.81935256506716, -0.456980660508129, -1.69702820622754, -1.58410171364801, 0.355085954237378, -0.815198580266669, -0.252435401945989, 1.69365815181846, 0.0304584381927383, -0.625290981008267, -0.169835000178682, -0.230985854389351, 0.564693575065646, 0.122341898672551, -0.225098273643131, 0.74242417756952, -0.185153880235293, -0.00937168409103956, 0.0516298036761726, -0.179008951325401, 0.543405432983491, 0.130436911866241, 0.16220386428364, 0.157388838665561, 0.235458858582121}, {-8.58966843562756, -1.15497167293183, 1.80323030806025, 5.02771374972929, -2.88835085047828, -0.755776055089853, 0.063119546117566, -1.45918510519665, 0.73583605086782, 0.815091858795201, 1.89246801725762, 1.90831475654699, -0.461150008003749, -0.272647297035201, -0.0413423725719265, 0.246718572949428, 0.299321744827743, 0.502427695719276, -0.00753697812953086, 0.640623246508066, 0.810340518865815, 0.220695222605374, -0.116660277307088, 0.134023323373091, -0.357453310527941, 0.0705225020337569, -0.0984174867292015, -0.300153097591612, -0.558918231400663}, {-7.92235711731788, -0.89282024540157, 1.63442851863339, 6.03799070531467, -3.50946667237162, -0.420144317049612, -0.053121733517995, -1.11279116149088, 0.679234011127925, -1.21663910205986, 0.903133826260012, 2.00035145656098, 1.75868087636036, -1.21178926213681, 0.358126614033816, 0.0590996034909119, -0.0328533192447587, -0.324551487740051, 0.0193545814125325, 0.026054874503183, 0.0707302386935431, 0.260201913458919, -0.0784782288307803, 0.113058067389405, -0.607883776202711, -0.383268051877139, 0.251501768683112, 0.435195911853891, 0.563224496041646}, {-9.4345213841142, -0.9231569085643, 1.71872437499588, 3.60966981611959, -2.07800034247791, -0.480350912591558, -0.0667061262734402, -0.733496688647285, 0.325656779433361, -0.266314808225478, 0.462235189240754, 0.770728300908779, -0.287285107162735, -0.2561125432752, -0.984607844283527, 0.082132834658603, -0.671496213632517, -0.105909756255267, -0.104219265427448, -0.151925143597022, 0.14760932582776, 0.137356492394879, 0.080315724410843, 0.117552610736934, -0.225433370773909, -0.0724635063189488, -0.0469639187110009, -0.055714803809998, -0.079742726715441}, {-10.0732808896247, -0.61521072699972, 1.06796382941686, 0.693956136650091, -0.337292978498938, -0.163681162992408, 0.0221199354076388, 0.023178083271206, -0.0607150087239084, 0.218392506063207, -0.0520788779195706, -0.277919356948783, -0.585796528584203, 0.168947007087005, -0.577861550054845, 0.00294874794921383, -0.381026905020934, -0.0429821591805232, -0.0202451560610824, -0.147481349983933, -0.0264918293690499, 0.00814371388165318, 0.0581696594063204, 0.0373218490430461, -0.0149106855753834, 0.00562489849282745, -0.0139592710141719, -0.0363323592590314, -0.00243588376401976}, {-8.73066355814028, -0.0376031672308371, 1.11640348368332, 4.63602860621192, -2.29382538849912, 0.218545887212297, 0.825060122025352, 0.409688529240142, -0.145215436678046, 1.16244285152755, 0.875022749951454, 0.188241761525393, 0.766579855944553, -0.532129965552563, 0.564884129422714, -0.440886992477316, 0.322611335113969, -0.0505106979834452, -0.168271876186253, 0.974080488570548, -0.212744718646081, 0.15333259113612, 0.0758506874311181, 0.009745766202586, 0.60568632939121, 0.174247476916784, -0.0723522616005121, 0.0537684368063062, 0.142643062669328}, {-9.82933332054077, -0.649943880730139, 1.36101428588647, 2.10179604783352, -1.22193667160137, -0.199228749924733, -0.139490459800439, -0.016954956593794, 0.050514258031674, -1.09602034959505, -0.76915025416472, -0.249365228571389, 0.0755169723928181, 0.121158192488967, -0.193663977877977, 0.0779504033632028, -0.211424919843763, -0.143065845108707, 0.0213156213510195, -0.365522874832868, -0.143113597969002, -0.0436225831495414, 0.0234449579442854, -0.0222499023013054, 0.055015968169391, 0.0156927479016869, -0.0440364420088226, -0.0682002654645149, -0.0445805938175135}, {-9.46907077787977, 0.19651161743955, 0.481949915441497, 1.81631524138901, -0.76799195198029, 0.360538873823016, 1.0538965431521, 0.99401840133185, -0.369703365306011, 1.76871269524432, 0.532327117503354, -0.825101730124338, -0.0228544309143142, 0.193588800266212, 0.737273122567703, -0.197513972142399, 0.452674543924165, 0.0483212663546284, -0.102479829069753, 0.424161294767149, -0.154952302737883, -0.0437083743836875, 0.0076837187901519, -0.108590762066896, 0.388527239719894, 0.0638098715547437, -0.0475633448868215, 0.106612102451432, 0.0206012178711325}, {-9.86250815856518, -0.489459000323549, 1.15537386812605, 1.71275546964708, -0.9903586897482, -0.0499384631026385, 0.028376366210506, 0.217401200766175, -0.0941985777788986, -0.757214666970051, -0.569168769537515, -0.396472279305096, 0.10891656188484, -0.0742433702278918, -0.70090759479659, -0.0738666013310473, -0.684089724640399, -0.276754030935372, -0.0508503979823736, -0.212983997925592, -0.0975010303802948, 0.0539838000723647, 0.0950235036841618, 0.0461367238762983, 0.0020231523284546, -0.0156299928269088, -0.0360759337553697, -0.057301644103793, -0.0167218701526062}, {-9.66968891449916, -1.52291436102903, 1.28902514310631, -1.31226153615601, 0.825164186805184, -0.861675891671766, -1.71535404048593, -1.85167826425391, 0.50987578299151, -1.89408557054637, -1.25926347116999, 1.18112412685899, -1.33972111988223, 0.465734504396993, -1.46927923890701, 0.152477496101379, 0.0172320499607917, 0.365361944773142, -0.4668282302748, -0.108949976726149, -0.152019570358518, -0.337294183100209, -0.0200142979838099, -0.172906725310292, 0.293992952720623, 0.00852535015083424, -0.063228158804661, 0.305528854993109, 0.00141965286450673}, {-9.54439408160453, 0.468809054153949, -0.115608470777445, 0.132342334930891, -0.066730761317567, 0.666931187703297, 0.976758642299883, 1.35530679996433, -0.555357142924757, 0.578920615708004, 0.0820687973860217, -1.0704683869125, 0.597120084592075, -0.329815116072608, -0.74689490101665, -0.294560347199536, -0.935923652563107, -0.342202382204932, -0.113791531641548, 0.11125176695227, 0.0401241212926702, 0.105584930340303, -3.26701524651564E-4, -0.00549584381958488, -0.0618041640547727, -0.020904230367235, -0.0102043391648923, 0.0352359818598907, -0.0429567053274071}, {-9.44290785475154, 0.385031753896588, -0.296741366913535, -0.733198543612184, 0.285599833173578, 0.626294379664867, 0.482189952305893, 1.47465514218732, -0.349436245631884, -1.05034445204633, -1.23344205293991, -1.41838274218185, 1.08727180661314, 0.302967395911145, 1.34778614658852, -0.00125615863878235, 0.43363090196022, 0.0639542034743251, 0.0705775565490125, 0.230803510562637, 0.289981484799228, 0.0383458795425351, 0.0444261506411482, 0.0463781380320408, -0.142504561788801, -0.00478234517344144, -0.0412857235999313, -0.12585002293163, -0.286141920433224}, {-9.6389815567954, 0.0801126566792378, -0.378491858402424, -1.84765736688826, 1.12225867815723, 0.374050221927663, 0.800736149452688, 0.836164704760991, -0.26914398143658, 1.6074624187727, 0.745681429536552, -0.609345378040652, 0.0687668966008522, 0.121295860140493, 0.584755681417801, 0.0596023805095649, 0.151066681686141, -0.0403339898595095, 0.0501310520961053, -0.175910561975139, 0.0131063736326044, -0.0316841573194438, -0.0734075368181221, -0.00250510671232012, -0.243178913261566, -0.166144031598332, 0.0371356542888427, 0.194812549216573, 0.103067913098752}, {-9.88442273335576, -0.0422660260176372, 0.373235845652048, -0.0119779343064513, -0.00121145563394405, 0.317615779615286, 0.429058639996971, 0.851790448312718, -0.34339057132956, -0.0578968683651144, -0.337753549257383, -0.870590550008251, 0.277704644262167, -0.0860367834902726, -0.491140017253932, -0.156012217526464, -0.665195491295903, -0.249662469269151, -0.0380291608886011, 3.41060943111702E-4, 0.03506721642493, 0.108577559212692, 0.0405381816412999, 0.0496837795793269, -0.0787876524713256, -0.0154386521573308, -0.0216469232941644, -0.0386466366089147, -0.0506333114395365}, {-9.9715971786012, -0.445358775203272, 1.00815095923869, 1.19123360713351, -0.570656867813965, -0.0656750420697606, 0.299684958780082, 0.28494207357085, -0.110558992716776, 0.660223295610056, 0.0816209237715758, -0.476999924409249, -0.487577797371231, 0.317724887558462, 0.205190639238632, 0.0320552743141061, 0.177245894975506, 0.0841424780454046, 0.0548492116559452, -0.0157199488405211, -0.0597246660104734, -0.0464188112433461, 0.0053927363939186, -0.022472234941928, 0.117340672506703, 0.0594493851218801, -0.00808057906738264, -0.0326151449968892, 0.00855798618745694}, {-10.0246754301772, -0.580754329268413, 0.989325349834762, 0.651512283156238, -0.24467998983385, -0.165075432569084, 0.222340464588469, 0.0527564081297668, -0.0697892929086073, 1.13974758518393, 0.457423256652272, -0.266920201534428, -0.88185877765298, 0.331860406702708, -0.0945657134961572, 0.0390912340158587, 0.0582426278770644, 0.133763702965505, 0.0477014359952235, -0.0561905294103933, -0.0247882836968251, -0.078201583938527, 0.0318809383190728, -0.00763575900899472, 0.0528061187345478, 0.0234830099407952, 0.0224438555300475, -0.00606844841714599, 0.0367784498366776}, {-9.80453075477742, -0.248155101074374, -0.0997702694626051, -2.31198268180717, 1.27270220983075, 0.220449025764165, 0.00757653414982217, 0.546034691150011, -0.148413585431463, -0.453402781403616, -0.539568684327919, -0.588434337209246, 0.443058937977307, 0.142183008291171, 0.580725148674351, 0.044669207182726, 0.180107951946138, 0.0231338753750865, 0.0770623200763897, 0.182886204854979, 0.232648844473645, 0.148299493741857, -0.0766256665198461, 0.118724405188638, -0.272991685354957, -0.055703501219218, -0.0454699460029256, -0.0682919477518361, -0.0827967863353479}, {-9.76309467495537, -0.111973449730751, -0.255487204494273, -2.31137852817997, 1.30662517408868, 0.294654644256181, 0.31771919764802, 0.675290134409728, -0.192985375103317, 0.356456045711983, -7.90808616263045E-4, -0.580049027657749, 0.331175424895319, 0.0985136112350466, 0.606440092416137, 0.0634821359656696, 0.158760654155397, -0.00313668249858291, 0.0863932918066754, 0.0226747740730496, 0.164119029040357, 0.101119374089003, -0.0748372986474486, 0.087762042667776, -0.297450391089229, -0.0943093275469267, -0.00435065496897642, 0.0308491666692458, 0.00622068076622207}, {-9.62390937133784, -0.110797333418694, 0.726123641661443, 1.72754444246763, -0.796542641037873, 0.181069647010386, 0.837112711513152, 0.561378148161951, -0.319310424383688, 1.74705442877186, 0.935976087584593, -0.424036087262507, -0.33427118444265, -0.158839494417967, -0.74506049845352, -0.286605587348683, -0.626288725314127, -0.166230200186937, -0.14382339646158, 0.322461726527076, -0.047447485348717, 0.0758506507086058, 0.081861290707568, 0.0166671627715584, 0.156427409074224, 0.00628752838637273, -0.040584905740137, 0.00610983281395027, 0.0131394302220575}, {-9.31678723797633, -0.981612274944455, 1.7310640337311, 3.56761985748237, -2.11705315813526, -0.527694954153335, -0.398225916879949, -0.684866498720425, 0.459653274859434, -1.75163944247589, -0.790023942345313, 0.455999163807883, 0.307229421401725, 0.318532776969798, 0.884267712806496, 0.42661215791799, 0.769844753317403, 0.119620870019353, 0.199660395741669, -0.83009176035907, -0.219341895709986, -0.306737061408194, -0.213660228611419, -0.2621212344013, 0.105659651309688, 0.071180695474712, -0.0353638354927046, -0.0552005556773401, -0.120968181591203}, {-8.82667756731917, -1.0577423977595, 1.86079970122497, 4.93506214265037, -2.90049340422925, -0.629661581914003, -0.188845352421077, -1.11171191321938, 0.664289525678455, -1.04190649347566, 0.393386919595281, 1.37557655356305, 0.464242456169631, -0.270738860703186, 0.465021398395759, 0.371384169510616, 0.423848064157004, 0.0878053652372863, 0.117008466646908, -0.418238136866443, 0.12000452226017, -0.00372924788816078, -0.200862449721156, -0.0942805702141368, -0.248076712051209, -0.0499598624732294, 0.0239915525296674, 0.0269408815913836, -0.0536585217491665}, {-9.8814559387119, -0.286318988493474, 0.023958960271832, -1.9633250030966, 1.1796260380227, 0.149819752804128, 0.269803997559086, 0.433765423160552, -0.172596043231799, 0.910812416121033, 0.334369768244237, -0.411624452560437, -0.135172510807453, 0.111760096359572, 0.302388872406504, 0.0410432960945735, 0.0765927504982482, -0.00643835076392562, 0.084535144299561, -0.116163331063881, 0.0267814248536054, 0.0103723075940558, -0.0358359734167874, 0.0348857235964542, -0.211785031504644, -0.0995317514856874, 0.0540564966854686, 0.092353970175818, 0.110352055750265}, {-10.0183334927806, -0.913848449882882, 0.800741928272649, -1.29705090061357, 0.880234642928278, -0.35397358778768, -0.344641459258984, -0.54912679658343, 0.0572984043984063, 1.19713411479162, 0.658847083882864, 0.319894517273453, -1.27736433727668, 0.180150376025702, -0.624348435954478, 0.0273832272627146, -0.136727162106492, 0.152573873651642, 0.023994014305398, -0.284176500111198, -0.0925513337166357, -0.183909124582033, 0.123610452877301, -0.0288846537874463, -0.0222993781747609, -0.0445648877864033, 0.150055058676757, 0.115478025886517, 0.19155075636867}, {-9.64466443271201, -0.751483090288223, 1.33672742836283, 2.30864846317339, -1.15458165539857, -0.362770042290937, 0.357286896779454, -0.375690744618725, 0.0977354311049889, 1.95556099985189, 1.3595631715103, 0.311837813204386, -1.2443016491447, 0.260444593745496, -0.287668566766801, 0.00432517016727656, 0.0616851388323537, 0.313728222166414, -5.97740438450679E-4, 0.304351933025279, 0.184527734751975, -0.0589472027438151, 0.0777551631430537, 0.0227790564049867, 0.160338941396482, 0.105545014254914, -0.0472146145298545, -0.153805335454165, -0.185837638461179}, {-10.0846556121812, -0.917206234379372, 1.21703319422458, 0.150095201479097, -0.0561152680677283, -0.394712018644921, -0.55591189781475, -0.392611103574068, 0.145160531543581, -0.910840225411772, -0.931488684490599, -0.174990239143976, -0.639957778369383, 0.651780401398232, 0.292875603174588, 0.249027909567471, 0.548384175844148, 0.260516196138573, 0.0845367106939884, -0.262393039648445, -0.0702900706254594, -0.186087981392229, -0.115572982653392, -0.0695654198828367, 0.0376124948920034, 0.0484423528826425, -0.0332700731273832, -0.0491085757208066, -0.0378075666363487}, {-9.36263181905062, -0.890071255154325, -0.204642765555517, -4.33256564810613, 2.53091564305908, -0.155296075043484, -1.01666549122966, -0.743565257859351, 0.16825809105778, -0.689748751038804, -0.172115930707281, 0.90792112936481, 0.448510635637729, -0.525290639467613, -0.0248932478510508, -0.140635225013189, 0.129238090881912, -0.0329682385809627, -0.0768444149875221, 0.493984598195064, 0.070512296273887, 0.18397311705574, -0.00806436660438078, 0.0288725222424804, 0.102698637801308, 0.054929410548497, -0.00460365929613053, -0.0492886734668811, -0.00886774360021778}, {-10.0394537779632, -0.408070141166111, 0.7788831491062, 0.277289879412735, -0.0637083253485479, -0.0103206252499614, 0.260133299115489, 0.359809497836437, -0.150716420558092, 0.640846821754234, 0.00970762073260851, -0.566451073575702, -0.46540037837853, 0.328360576751852, 0.190538088227609, 0.0352909334130916, 0.136424602951393, 0.0648040868146255, 0.0609004962766609, -0.0531670103201002, -0.0409303010427492, -0.0391789527719381, -0.00295090852630948, -0.00594359087813261, 0.0205343506617966, 0.0124444128589496, 0.0135002724340043, 0.0028890153632634, 0.0424277210334112}, {-10.122431120225, -0.850432226987367, 1.15984084957312, 0.156905267578216, -0.0449367575825356, -0.332990468737973, -0.339947493245907, -0.365269726568544, 0.0562418216209925, -0.148277225169123, -0.22058255876375, -8.6705676087116E-4, -0.823772170202235, 0.211021184492008, -0.893091372498992, 0.0468037635259532, -0.463419315001816, -0.0021998056912141, -0.0696537946118649, -0.243780330512412, -0.019960728320733, -0.025720884609187, 0.0707044524647924, 0.0402996678340085, -0.0519854751950576, -0.0142013395104268, -0.0162117386032714, -0.0125980818850115, -0.0100640496916006}, {-7.95113826581482, -0.486988083632148, -1.67352480796282, -5.60640469473299, 3.1494922355678, 0.207298278689994, -0.0858133041415214, -0.662679723719461, 0.317375243497868, 1.51853541843438, 2.56942159235841, 2.0752649010867, 1.79766646425489, -1.62941632771343, 0.446713566834258, -0.019216597828433, -0.369751965724504, -0.549294788152164, 0.216756271710243, -1.24561120120415, -0.455852708887264, -0.253788395882568, 0.142626254971183, -0.266116152181475, 0.396331306132259, 0.197778123350314, -0.133477872599965, -0.292326750069749, -0.404423910586181}, {-9.5635185492341, -0.993596292019045, 0.181803320884686, -3.60542828569943, 2.10756575500658, -0.269120243184352, -1.20180728000261, -0.809559794309193, 0.175144876467949, -1.39836176869192, -0.879445230082946, 0.642213459269577, 0.17055843489244, -0.177485144231889, -0.240415730722106, -0.112973615527861, 0.149957460176188, 0.0522248145848687, -0.169993801541203, 0.617124627532997, 0.10128271899583, 0.155555765385495, -0.04801043038057, 0.0432475787862176, 0.11216333930956, 0.0368702543001723, -0.0569339135201404, -0.0259021264550063, -0.048643365262896}, {-9.65339652938329, 0.0383930104419029, 0.374983747139258, 0.523624854893753, -0.382151235907565, 0.421911968019416, 0.396892665014565, 0.916168937748487, -0.429192483802088, -0.629661166062847, -0.474910316883734, -0.847174180019592, 0.662566903028499, -0.472316308477552, -1.44589281816565, -0.354993336987758, -1.49963704015109, -0.518836107629187, -0.124718881664336, -4.42173138842336E-4, 0.0381395541161636, 0.147356006708175, 0.12528684080227, 0.0781537383886178, -0.10750178149244, -0.0415374497094174, -0.0271480524044262, -0.0749409491330752, -0.0788856093083714}, {-9.14060348294048, 0.345292823115219, 0.529497159736725, 2.41524420026557, -1.39756570148662, 0.627616021364269, 0.402611403222233, 1.36704638535903, -0.437721137204779, -1.40686791980871, -1.27229211107356, -1.12735441801973, 1.4884779790431, -0.362743026549391, 0.48413232683485, -0.306349189229314, -0.22053943048647, -0.361844759153437, 0.0363075457724248, -0.0578708703632009, -0.292391275890517, -0.145196354587852, 0.2407493766552, -0.0628911931878577, 0.339114965043659, 0.0644402282585027, 0.0982808071439443, -0.00290302834759456, 0.0185920029240212}, {-9.7563462409608, -0.41316945722408, -0.146289833760444, -2.82702783958489, 1.65049061383981, 0.110387793920724, 0.0494503647048103, 0.145908770845161, -0.115660971475751, 0.825018997973731, 0.59014757902543, 0.0256827878488055, 1.18321753438297E-4, -0.269080413308873, -0.333965985327755, -0.051846651826643, -0.425938676487925, -0.163875301854101, 0.033001492119223, -0.214182186897097, 0.00917033645520012, 0.0564347960089693, 0.0155951769066026, 0.0331276584446654, -0.189688537935982, -0.0760470521856271, 0.0443684088912545, 0.0556476254322368, 0.0604824869185911}, {-9.76424330386904, -0.528772911935442, 1.25616308789472, 2.13448951916875, -1.2208324354168, -0.109131474047536, -0.0464283575117118, 0.215332522938514, 0.0093307308165328, -1.08237988355115, -0.933806922785083, -0.480514880878864, 0.256002083744345, 0.279459620048808, 0.568843212901397, 0.115371717459932, 0.316265727677719, -0.0334749842940195, 0.111575954802634, -0.326905796666837, -0.197003092171174, -0.127549374058346, -0.0177626644479945, -0.0935289204403828, 0.188771008508464, 0.0851080635607717, -0.0310497719167353, -0.0898161533084593, -0.0600753141267935}, {-9.8475236312517, -0.722769084560277, 0.211519484720305, -2.85616878135214, 1.65439676343902, -0.103922209674809, -0.62380702024626, -0.231377010823682, 0.0240336210419969, -0.686374539591948, -0.564411117859175, 0.0657115597356922, 0.0409086585451054, 0.0132330087771423, 0.0139084844324457, -0.0100259473180359, 0.0924142947772754, 0.0320517680224315, -0.00878248438579607, 0.233333110598023, 0.107920018510425, 0.117463163385409, -0.0492924317449652, 0.0790384463921451, -0.113180433946484, -0.0241739549659076, -0.0156992698006823, -0.0269253222250395, 0.00405127662356146}, {-9.78220627363072, -0.571504274305803, 1.3562071159665, 2.51295721887422, -1.34539031301679, -0.188710689888959, 0.210784773973131, 0.0410788950951101, 0.0300503215150982, 0.228272430093749, 0.0338708812592463, -0.177731439394647, -0.299958416050316, 0.223531702757341, 0.290148535186943, 0.0726653709705562, 0.257736987134901, 0.088256557279655, 0.0660993300515226, -0.0386668603818279, -0.0759649653169002, -0.0417214200500721, -0.00751052834379387, -0.042045938521821, 0.198433010770606, 0.115014888456601, -0.0368405327746571, -0.0858509106079362, -0.0426061282693758}, {-10.0982892704148, -0.593066807544387, 0.704603764977402, -0.718310934139241, 0.502725384404461, -0.11866847110038, -0.00240992373602105, 0.0580352096635407, -0.0824886100331715, 0.67773729606648, 0.124661736919715, -0.29684344726772, -0.688528129566927, 0.284812797193138, -0.0874176344147981, 0.050012640778399, 0.0252474169713652, 0.0793516755378349, 0.0580144878537988, -0.133314157213993, -0.0301694628993505, -0.0537950613233186, 0.0116326777483936, 0.0122372371399109, -0.0665360442997288, -0.0293891872340345, 0.0521292552282765, 0.0405232804314339, 0.09904611810788}, {5.57580427487942, -0.830232500231638, 1.51947704461481, 2.76270015097128, 4.93011610992094, 1.21326932128081, 0.246786354345496, -0.0910637838431422, 0.637237527064745, -0.963364550489471, 1.36848103599181, 0.0023528226917238, 0.269796772947967, 1.00339855714748, 0.147595203815577, -1.1854144647262, -0.107013204515903, 0.145817727594966, -0.370289334275597, -0.0435455731830603, -0.172072037272852, -0.125119985667685, 0.0500562708760684, 0.045689818897207, -0.182264896811459, 0.13991512174242, 0.47279451010978, 0.0221133975363674, -0.161017700433686}, {5.78019403201538, 2.09828549581773, 2.07889761619916, 1.67170369456851, 2.60610872240089, 1.92570782077362, -0.921071860508738, 0.224084906425754, -0.270233459236258, -0.0434471173341687, 0.318566268954788, 0.317228339233815, 0.311720055480604, 0.357338937637376, -0.0863775512601996, 0.135707104639438, -0.0522010981626889, 0.220541467966381, 0.0755027869259515, 0.116507028925611, -0.449621027455316, -0.0584350853323941, 0.041151988920447, 0.292645812404864, -0.163116026671976, 0.0829647017969199, -0.0764154597349271, -0.0125627144292667, -0.038111004093937}, {6.1259005399183, -1.58023299839506, 1.6348433147371, 2.01155318544857, 4.05443723252512, 0.529192117860848, 0.489552451538651, 0.244888131297491, 0.681681139957671, -0.926593184916733, 1.11669151899277, -0.190578178097041, -0.0741809104799452, 0.532361019933089, 0.105629060791021, -0.504990710256506, -0.103968186731748, -0.0569870888963368, -0.121434594688762, -0.0517049156430457, 0.0656457222141907, 0.0284145410717285, -0.00432176487216857, -0.104551471709603, 0.0101594279563569, 0.107029560148571, 0.358701879646048, 0.115686037881788, -0.0820122715663732}, {2.99308385262855, 7.04364340419872, -3.04507308411483, -0.553287929655876, -1.22658748447895, -1.06320284556279, 0.864919778464053, -1.32801977766951, 0.287085359857615, -0.244584260592821, 0.0161731066330782, -0.169260386270756, -0.545970717597347, 0.17347844343953, -0.100577609834583, 0.086778440212806, 0.0301347874100487, -0.461210732296306, 0.444448159029871, 0.138047119724187, -0.476618348522673, 0.225227372255368, -0.130301395565968, 0.106992736483087, -0.130575167729127, 0.23654182880646, 0.246065245842723, -0.174005930991906, 0.105638302523958}, {6.14385255070645, 1.82173844397341, 1.81342553766694, 1.35791477122007, 2.81521772126917, -0.522996486128346, 0.485969520316608, -0.638661440637413, -0.38249495076962, -0.0545988769662911, 0.0814153370190703, -0.218088436504453, 0.227285914734897, 0.134328470227833, -0.100362228261608, 0.0180414159905923, -0.0543118104122247, 0.129680046687776, 0.299207046444607, -0.107493431646316, 0.244837751099896, 0.177835278245295, -0.0615700701934075, -0.0871820463372464, 0.121096429921999, -0.0721022705209322, -0.122840426106834, -0.100624119017325, 0.155380401021552}, {5.03335585336895, 5.25477454383039, 0.178476869770204, -0.175265568633768, -0.632711089706774, -0.562304480170733, -1.58344455075028, 0.501015912564497, 0.594351438312114, 0.209075316706812, -0.335654308700247, 0.0468363522399003, -0.525066940309244, -0.321759168417022, 0.588844808520813, 0.0720407477485174, -0.468248908539007, -0.0143349507427658, -0.189181950878915, -0.10081659607236, 0.142765821342111, 0.173385800214925, 0.12314189100655, -0.0389445031919534, -0.0199208094287119, 0.100883509677548, 0.00764558272374988, -0.0376322046361631, 0.0291360920096088}, {6.12710448271877, 1.11260272262185, 2.47647156341701, 0.861405348533802, 1.57664733241974, 2.25803429457303, -1.34615313097712, 0.681349597320451, 0.172969391720378, -0.0944062578504598, 0.448011793984197, 0.338855454736116, 0.149172698563373, 0.404258092250882, -0.00355165929062231, 0.610561296333949, -0.182164340199809, -0.0902293586840398, 0.116134196762215, 0.222676918220362, -0.40982496209908, -0.174516520977951, 0.0079030509385964, 0.298923042255001, -0.0911385962427708, 0.037916252398216, 0.0614386168181604, 0.111096466854388, -0.161537847713376}, {-1.44932610454163, 6.46110688878855, -5.88908689426994, -1.68716313210515, -1.39932445355556, 1.35478633720712, 2.3797455830902, 1.085727196987, 0.620793868415592, -1.59196825418148, 1.22591716219061, 0.229266443008482, 0.367173255296779, 0.505216020668447, 0.0312034638643472, 0.39356358284746, -0.270525608557865, 0.740154342318247, 0.0118616924862557, -0.00190726641594468, 0.551609991459245, -0.00280864474787323, 0.190289197387431, 0.0398870559109159, 0.100465790065737, 0.0545124977327229, -0.0842535646085665, -0.0118066802466277, -7.98612494793366E-4}, {5.85546831079784, 1.75516834426958, 1.61918868669735, 2.0885925500873, 3.79456345570656, -0.359327825637343, 0.200716479991565, -0.0710786025019521, 0.357712115418396, 0.00899737551125601, 0.0573144564871893, 0.168463690163557, 0.317545933988547, 0.488905055184004, 0.111755787552403, -0.515644341095065, -0.199635896581073, 0.144545425130531, -0.0597444901311218, -0.197831300191456, 0.350364073877239, 0.11314395166262, 0.00181796649622431, -0.0378750179903832, 0.141454433008314, 0.0263619429844923, -0.10532257032337, 0.126007560473393, 0.040267052823161}, {2.21647000769821, 7.08482264608116, -3.11558767002862, -0.837922725411819, -2.26903382114675, 0.95468369911691, -0.699513604500324, 0.379560024142378, -0.356040277151068, -1.21756587094955, 0.708489018641864, -0.244109143534055, -0.693399208218174, -0.412152543133707, -0.274568998545759, -0.513968835966802, 0.125005661282932, 0.349708578849021, 0.738382731898667, 0.0369622109640963, 0.268455055725919, -0.0883872181179233, 0.0930806072042744, -0.269262417121316, 0.0462734638577039, -0.0105933988281053, 0.279160848242866, -0.117568576029086, 0.06695427807482}, {-0.27541571150954, 6.52699820759447, -6.16181344081265, -1.74961627874973, -1.54397225761824, -0.0196422238837209, 2.91718868856477, -0.631030400679533, 1.47713062232683, -1.30442158641182, 1.48493201917873, 0.76060885669128, 0.00351128939021711, 1.39620964562043, 0.33263058748254, 0.819506767917752, -0.411066974847123, -0.090969383048501, -0.102365865865156, 0.0396910486359826, -0.563612586593297, 0.044675558500046, 0.283176982851187, 0.721934420574079, 0.258202850825154, 0.0556867672966374, -0.324466720981203, -0.0422542046690072, 0.283012156659047}, {4.70462324688195, 5.2071550493018, 0.488498307576632, 0.791579464247286, 0.332319742173611, 1.54370259653118, -1.35849950614566, 0.111593342746814, -1.05856648573793, 0.140770545417364, -0.134978796946179, 0.066260164862223, 0.0169292965645804, -0.418830035238081, -0.44068837623143, 0.176745887135496, 0.358079661724497, 0.144126896089907, 0.38941384289171, 0.0125195666695459, -0.157399795082217, -0.126771205498118, -0.0744773083181893, 0.160271144204494, -0.107047899706822, 0.097200325601213, -0.114964537035972, -0.104965419012028, 0.110316364343301}, {3.15201495640987, 6.3727910439468, -2.48043905646701, 1.03805646804824, 1.32184890803675, -1.96262869652714, 1.94554558686192, -1.95373102413617, 0.663373528103047, 1.18606325979638, -1.42046834853552, 0.390108060206374, 0.118034731226958, 0.541989701202469, 0.186171831400016, 0.014644806399668, 0.0288667900913911, -1.126486841039, -0.304352638772171, 0.117488398403175, -0.00811382887671598, -0.260419493697492, -0.071373897874346, 0.0173937284317849, 0.038762235342885, -0.570752591003464, -0.13009235100119, 0.082828725617667, -0.318298952984124}, {6.10064458172913, 2.92956655762161, 1.73466397948095, 0.404200270876776, 0.964498668476676, -0.463284953382798, -0.995221802370152, 0.562388034216601, 0.542471904794803, 0.296198800360161, -0.229139316466136, 0.081427952460354, -0.0671989109945565, -0.0373496404480116, 0.247210013806522, 0.365294422023912, -0.369374469025494, 0.0329588793301035, -0.0656854695026863, -0.100948246674481, 0.139097305765972, 0.229598128008534, -0.0866589689672357, 0.0111906893654672, 0.0720280331978572, 0.155597275555065, -0.0672512468411445, 0.067270936938173, 0.0469784461090772}, {1.46903910124202, 7.01030103569936, -2.58886235417315, 1.07394732111267, -0.366933325301354, 2.18553826254256, 0.0355078248789109, 0.835309547573288, -1.35191974627308, 0.0482668640526982, -0.419472363687922, 0.0197307083889124, 0.246175764583562, -0.887546552482463, -1.08096743222348, -0.347009865624625, 0.733973233465566, 0.428488741681174, 0.262660108522088, 0.154677547680735, -0.119100268792451, -0.453295562497001, -0.242974235338266, -0.241650125379586, -0.0568582887711422, 0.0973335169330367, 0.167551103087729, -0.0264856824229482, 0.0855867310710185}, {5.41630004524201, 1.76479571716601, 1.6975671072116, 2.65861726553528, 4.23072791682425, 1.36951341419227, -0.00105390597415393, -0.451894555146326, -0.343568147648773, -0.169191606253418, 0.489859612804156, 0.288030826130473, 0.589437756104392, 0.723270262425043, -0.0925429821994426, -0.813091090517856, 0.0243155239791431, 0.421852224850224, -0.105033433905165, 0.0112217661301044, -0.330046388291325, -0.0180252509445007, 0.00481188849747517, 0.137262495498081, -0.160225543717369, -0.0717218054087423, -0.115831192462613, -0.181733064802284, 0.0380367546855226}, {5.04498883791027, 4.81453297741691, 0.67660249140323, -0.594228356218422, -1.49632922205958, 0.751854329225749, -2.44595476844997, 0.76207725185424, -0.0562330934470656, -0.109909715626376, 0.235856543488805, -1.61019015753271E-4, -0.437227620987827, -0.313070760585939, 0.257821634883384, 0.0686006239052654, -0.168158953498118, -0.0842166081091735, 0.115467585184374, -0.0663976641529019, 0.230355455857809, -0.138703241621104, 0.0105546650373673, 0.076796783488152, 0.109430737085579, -0.178755660323623, 0.00528075224409683, 0.00356076680681655, -0.0317796843603849}, {3.44754999934356, 6.64470107920707, -1.62308230908224, 1.118487560227, 0.747584550705649, -0.169601639166306, -0.160174529379252, 0.218222541956672, 0.51260550016931, 0.764597484267527, -1.25904702877775, 0.479495997660915, -0.33353363417561, -0.22518161803589, 0.630075480342627, -0.176284330856672, -0.101068264179181, -0.0725051469186017, -0.732369803753561, -0.141964337403113, 0.165148481833014, 0.156104040690801, 0.415398287607868, -0.0795143736440303, -0.0395801590513613, 0.0324086982350451, -0.0746196300694686, 0.161117698192288, -0.134666596078594}, {5.35356988691332, 3.74155116767802, 0.301274039573763, 0.176582367832936, 0.943404671750983, -3.393494347307, 1.50692277710739, -2.41023838617368, -0.423110921723128, 0.315661337071454, -0.470457967385421, -0.765978877280047, 0.399029212192912, -0.0881848560976, -0.170008370960348, 0.227652515528785, -0.0798896546241853, -0.427986974445879, 0.929580060475261, 0.204094571702923, 0.147001884291079, -0.357839660785004, -0.0566396027451391, 0.206100279085986, 0.0931726289385861, -0.0272253962767414, 0.196353485128185, -0.092464240643554, -0.0745014483430425}, {2.54519479938281, 7.28195082384415, -3.02706986770252, 0.328512040705844, -0.287270527783166, -0.165082998646783, 0.763881353470669, -0.352397869731319, 0.260508905093468, 0.31134225416758, -0.733137664392333, 0.205293678290771, -0.443209182407805, -0.0837662049410566, 0.134837309506925, 0.0453665477188044, 0.142416632391248, -0.247445806051843, -0.26329453277795, -0.0111024220511353, -0.0970423854049865, 0.174767948549076, 0.113054219430488, -0.0877445854468134, -0.0952111439121116, 0.00834530911908499, 0.123187163002391, 0.00341820491358008, -0.0312035032223445}, {6.13193093276175, 1.61553222158747, 2.53438411811986, -0.900093932218087, -1.21526017299506, 1.79557368769496, -1.98926007811196, 0.563155134905994, -0.216192122520032, 0.0546482441719508, 0.488518938299665, 0.112895944962012, 0.0973930226572915, 0.293652962962909, -0.100998982162901, 0.674540766412567, 0.0158847338780796, -0.478193443689662, 0.110895009137223, 0.123092603117294, 0.104321781096489, -0.296424130112345, -0.157425818598591, 0.144746137706012, 0.117142161024928, -0.215398351132384, -0.0732141019139402, 0.06109206086725, -0.0367450311021949}, {4.01319379619067, 5.80506626954553, -0.429373146299468, 1.79654279377091, 1.75152407417716, 0.774792408711215, 0.0739743117819573, -0.562034688471406, -0.936509062812451, 0.756338069871563, -0.791513056497798, 0.242576699146655, 0.32390914195472, -0.185020948484376, -0.545641860394782, -0.284164363398614, 0.536943585772796, 0.117886246613875, 0.0643380227530958, -0.00712118473327935, -0.2103735238623, 0.063175510489729, -0.265866977683028, -0.0147770945726714, -0.0741033182339281, -0.0677737099321119, -0.259466588573034, -0.199799512519703, 0.0934767985076371}, {6.36089308469396, 1.37845146799166, 1.66140517848924, 0.0235341645643399, 1.0841870026897, -3.08146372758128, 0.763823468126581, -0.414718439778866, 0.226533421165028, 0.114069833176425, -0.212176967403707, -0.482092881287866, 0.209030589616143, -0.246638775336742, 0.0912906878734657, 0.266989228098282, -0.328044217228102, 0.102649297565837, 0.322951672068051, 0.031411796990432, 0.340234161144272, -0.155753487081633, 0.0373358901436647, -0.0491030348528088, 0.129614034854759, 0.1099386048447, 0.0189687304668686, 0.113381219886603, 0.0802742873223165}, {5.7947548566222, 3.44597421246014, 1.20095194345707, 0.713938690120425, 1.39813883659932, -1.38532890829655, -0.836891690561185, 0.68513420729791, 1.19487549258612, 0.512330967889801, -0.613366341856723, 0.266655821837248, -0.104968118906086, -0.0210702345432859, 0.58000127196026, 0.122465087472549, -0.654197685838577, 0.0206228181196847, -0.348357647491982, -0.143560956559858, 0.33338271235321, 0.138538641866444, 0.066566590590781, -0.119937373800421, 0.0422666158349328, 0.254939686223966, -0.146692855628438, 0.17053602995726, 0.0386802829445311}, {5.18330305907899, 3.79139591233956, 1.04112871336225, 2.1706404921037, 3.1474580134412, 0.424660324568629, -0.0646437686994277, -0.431803808935906, -0.375311363167572, 0.473396345922035, -0.409820472720774, 0.306231219983723, 0.440928129811397, 0.269215804102143, -0.124786463342273, -0.449350144790282, 0.10038878049891, 0.236615789263628, -0.0440386712737733, -0.113423128686346, -0.00301105236715963, 0.13511893157237, -0.0767689879970417, 0.074721652693417, 0.0114474391839007, -0.0615751773742928, -0.288306320933757, -0.0898432557684587, 0.0646516803928994}, {5.52905045738072, 2.29878676719242, 1.62270623177147, 2.36194534641004, 3.81232471294475, 0.869492461695156, 0.0770821797080409, -0.512806467080238, -0.430493728799299, 0.013473713036824, 0.195464080247743, 0.205937168691334, 0.504463197036671, 0.516958330431835, -0.135434040603385, -0.568118150838433, 0.0463343258972663, 0.33623715299152, 0.0168294603553048, -0.0518549396558781, -0.131994639924098, 0.0743219713990437, -0.0442730750976204, 0.068949520729472, -0.0583531535495359, -0.0937789245866566, -0.197727256366091, -0.171584808424395, 0.0901946676312338}, {6.10846657202346, -0.102533559310063, 1.58584474296517, 1.92401552256249, 4.02389739326733, -1.1835407993275, 0.943963040885897, -0.174658007920998, 0.284946936273907, -0.530431491876176, 0.522448325721215, -0.176783018843626, 0.153976574736202, 0.367016105259891, 0.0870818542678537, -0.578704253551786, -0.158445636374496, 0.0155731426081366, 0.121631556554278, -0.200005108223603, 0.687585747111944, -0.0942180865864144, 0.0432160123859753, -0.181789432320507, 0.29150923808649, -0.0916818094263239, 0.0340292312498731, 0.142360711924333, 0.134685311733242}, {6.60560803905191, -1.77992356402236, 2.03440860561617, 0.895439219188427, 2.46868578478522, 0.235105686476527, 0.723869503443003, 0.135466545350552, 0.117399142148234, -0.672732087013627, 0.69687427397791, -0.309400763635102, -0.19508832969111, 0.0612494205666883, 0.0248222874849698, 0.239731538652172, -0.0814013868915933, -0.0121894762886934, 0.103509621872289, 0.0146640899462263, 0.0413158582484983, 0.178288062174026, -0.0079911082769956, -0.168702836245984, 0.100271906587768, -0.0406643926142647, 0.138828641514003, 0.0366204750877325, 0.0165610061704755}, {5.72249501157779, 3.95708320146637, 1.35763881800047, 0.328253874398928, 0.468553266738486, 0.268450611283561, -1.09674025275873, 0.0396532161390982, -0.316820829182867, 0.207114426379037, -0.118995405965653, -0.0777391413071566, -0.0734363885984207, -0.181126063631599, -0.0513499432657206, 0.376034881203135, -0.0296011248880014, 0.015001719298352, 0.202985332621967, -0.0745569475139283, 0.0124550055120767, 0.200198468415487, -0.110036221767519, 0.0812928938405527, -0.00696317605273511, 0.128467562770105, -0.0852420651936986, -0.0508772479307116, 0.0859967203722423}, {0.734549803035439, 7.18800853131165, -3.66826368503404, 1.17313032192733, 0.40042311735938, 1.13147772952426, 1.7502551051715, 0.272293159898059, -0.438616159860411, 1.0019277178144, -0.944312114229285, 0.317573768388493, 0.273232330684577, -0.145776009254801, -0.493542934962859, -0.157713367887157, 0.76677763521934, -0.0961508281249045, -0.713661990800999, 0.0788954979906734, -0.205597869278863, -0.097833160704825, -0.301818749678122, -0.324169639497455, 0.0169364385278718, -0.269227375935437, -0.0436466364303512, 0.238518351893938, -0.165293095820855}, {1.95188678464871, 7.40143187566967, -3.79368369844038, -0.0357423914506601, -0.644479542115436, -0.150618113138242, 1.2921143347477, -0.496958610135334, 0.363164131380683, 0.0770760504189727, -0.426830524016259, 0.20375277668122, -0.436957026845389, 0.119928934953415, 0.0216370500698529, 0.164353542130083, 0.15992331762468, -0.30671171202382, -0.179031988499795, 0.0325006459811662, -0.210874108399123, 0.15445510088414, 0.0380134256358047, -0.0419790266160031, -0.0864369248025651, -0.00183424588170459, 0.161534132997582, -0.00209698161773095, 5.49103434185927E-4}, {1.34880762480541, 7.4088702071501, -4.19043285813526, 0.10812355054123, -0.413779156523895, 0.104944602810807, 1.68670006729466, -0.250448596354007, 0.446927806657653, 0.272180277640613, -0.568909873574764, 0.342715070435347, -0.307581218466745, 0.205887644391998, 0.118538151710512, 0.224433367776008, 0.231537300124612, -0.312295949555627, -0.512069260687783, 0.0109998036632164, -0.162560304560724, 0.104515809526072, 0.101007113911754, -0.0702106705323109, -0.0656874766436321, -0.129742986621924, 0.0976158895644147, 0.128633678956945, -0.0803573599611981}, {3.06667503607093, 6.88315998855662, -1.86523407183361, 1.09886301272122, 0.495579750440065, 0.601903899630134, 0.22650059782942, -0.161558151964301, -0.50853760435965, 0.593679339982683, -0.877665790528124, 0.200884312405087, -0.087378101225941, -0.358829943910573, -0.323385866472145, -0.136411421021541, 0.457222536671924, -0.00547177495757812, -0.101631647473668, -0.0312263284868347, -0.105526694490275, 0.0805541989773675, -0.122164554714392, -0.102997452059943, -0.0672148109325904, 0.0148411635551089, -0.00867249466162386, -0.0487431667221673, 0.00510605386626212}, {6.50861846734372, 0.93173819074262, 2.14285873416521, -1.17846994103294, -0.9751386255231, -2.25564486382852, -0.48584813932822, 0.620658307168403, 0.772731975849311, 0.284814706566624, -0.0377735243872981, -0.247118100288875, 0.171302812994891, -0.0850872653955293, 0.134002775398564, 0.265334514185829, -0.335001736361581, 0.16648239123415, -0.217669600833418, 0.0294891366288224, -0.0589830498200196, 0.0872938960224158, -0.259013426220321, -0.106586210325323, -0.00660124649283655, 0.088807358128129, -0.00228729115161121, -0.0545010375174567, 0.0782640556063281}, {4.60220104337504, 5.11720857565346, 0.15598032512865, -1.05191297425814, -2.38409618925125, 0.714759809900149, -2.87462280791015, 0.909616542578089, 0.0878677037122318, -0.407925350316778, 0.542354108538085, -0.0423882215382786, -0.626203795020284, -0.310160665879505, 0.44943896467609, -0.313291962051399, -0.263478142963913, -0.0938936562093923, 0.12214023931153, -0.0583041256568137, 0.389146986437693, -0.28636454364153, 0.0928919000202061, -0.0292041816794661, 0.192206455080133, -0.45028604943107, 0.0183191699170316, -0.0137245223395101, -0.0880505984837936}, {5.37753582999177, 2.83342485736285, 2.03475609111578, 0.637482561149134, 0.39290259163441, 3.03018136812532, -2.48243552252157, 0.973071187085182, -0.400506029109831, -0.00999600294855762, 0.355972687126486, 0.556950144474385, 0.210784704935037, 0.122779977253055, -0.0680028245414444, 0.630807855947078, -0.0487196804347345, -0.145693835482426, 0.25439119017591, 0.291455849415381, -0.330980792790437, -0.77678268885155, 0.16482143051701, 0.601808990179728, -0.044677485539109, -0.137902229583304, -0.0234708226985055, 0.171045493821415, -0.176203630146858}, {6.12285725325505, 0.159830989225134, 2.04831245476916, 1.91086605427749, 3.66520332367419, 0.960339896451338, 0.0987635041317897, 0.00757959919015736, 0.185494264194126, -0.494851848916017, 0.715694835531276, 0.00689743025428394, 0.164614913530463, 0.532858496810455, 0.0354416288106131, -0.240224311455269, -0.140898590523695, 0.149744989687626, -0.00419418148102771, -0.00464032205673527, -0.134850844985446, 0.09781003144427, 0.00253256399562942, 0.00432165456955937, -0.0517877581683517, 0.0468186531194616, 0.110640523524514, 0.00524462005385158, -0.0280468534040186}, {5.1006997139559, 4.17861607448654, 0.0435645950889988, 1.03509110040819, 2.08172605359407, -2.87520525364047, 1.45067250121975, -2.01331826835351, -0.0179249349936158, 0.622407200816668, -0.86513119451273, -0.292269952737419, 0.387333804901215, 0.140886852319095, -0.0286046055203011, -0.0601204929693848, -0.154871819575231, -0.532905991655528, 0.580504771843052, 0.0607742026870996, 0.470768501439297, -0.328647149000854, -0.0876239479565673, 0.00158921229520014, 0.183258267884573, -0.291189870434513, -0.0441243170169759, -0.067561208091148, -0.0525172289124665}, {3.56484279766105, 6.38272536722164, -0.936637334807217, 0.531288969535311, -0.60789561497116, 1.50323757199593, -1.70800597075111, 0.980163847843753, -0.478257382528487, -0.0723265278787555, -0.357880742401452, 0.205053391769762, -0.374305069638498, -0.715254539566486, 0.0764208102359788, -0.133614632691811, 0.126829603662523, 0.274985245286538, 0.0840488378286369, -0.0639779363673501, 0.162213029879882, -0.257924193518855, 0.305016140346814, 0.0962407193427555, 0.0412243974288374, -0.0155666904789684, 0.123602451938587, 0.0417040174347376, -0.0558890896720429}, {3.07974668430526, 7.10584545735006, -2.62380643930847, -0.312315572952943, -1.1503022749593, -0.285517461785709, 0.184328951390344, -0.591939104078423, -0.00830100100596105, -0.234970783476256, -0.0937059833130835, -0.137569778246445, -0.593713863665884, -0.165918967653524, -0.111411377938262, -0.0331567863672042, 0.11742600791592, -0.16151132102739, 0.337531323424882, 0.0274236737181434, -0.181372985948721, 0.227344159053999, -0.0565658455341876, -0.0624550464502899, -0.113036590273576, 0.187492511217763, 0.219637965772132, -0.143024693881378, 0.0981845801141594}, {4.20548905520923, 6.22040943450786, -1.25603342829441, -0.560263259546228, -1.33412528871549, -1.22834811791347, -1.09433129525432, 0.0737051787244992, 0.98182456451915, -0.042879502850386, -0.274220035109185, -0.0216087953011972, -0.842127633528652, -0.24110245225573, 0.909757522504411, -0.171518797708485, -0.657784980650307, -0.102275729239621, -0.257286424070207, 0.00713331847222703, -0.00592464151408773, 0.219283539495185, 0.375466410793417, -0.123119698728325, -0.143641337267947, 0.117039314424496, 0.0816834182174742, -0.132743503294397, 0.0591026703466733}, {5.88770040171655, 3.26246517383737, 1.68171679351744, 0.707395731343725, 1.16419772674617, 0.370498121772615, -1.26494225023693, 0.623415279798613, 0.294833791517497, 0.279575098101456, -0.194803058055317, 0.211681811847844, -0.0344400192816383, -0.0149337633458714, 0.186235092243747, 0.345698507075924, -0.267592360553578, 0.0671513766524392, -0.0485538561291317, -0.0887148599473605, 0.0450005946976256, 0.163253402912599, -0.0362576118413134, 0.132485243535843, 0.052400654718133, 0.129317417653062, -0.0730301530170942, 0.0759103896507344, 0.00555880433211527}, {3.46304925577428, 6.7873380129938, -1.7782730286731, 0.813650536458947, 0.406162176675708, -0.112435461300561, 0.331658487943896, -0.517805408459256, -0.188851347835509, 0.565289639183788, -0.869075193382574, 0.132949769938075, -0.218817449024156, -0.224439294054582, -0.130154063690906, -0.0294151631127783, 0.266707212643045, -0.18254993782071, -0.0562073876532605, -0.047452858870828, -0.0721035808989833, 0.175100245266724, -0.0912579626060258, -0.0796162532782604, -0.0803308094571948, 0.0338626411576498, 0.0160501857028265, -0.0697916218878586, 0.00275331446281169}, {-1.2237723448691, 6.57665188684051, -5.95076078709035, -1.5601772842845, -1.2369941625386, 1.10425655324259, 2.73038702844106, 0.666848274318224, 0.690780903756493, -1.18519713377441, 1.17246733038596, 0.35889527168809, 0.341148138342915, 0.672149003095258, -0.0967055993334417, 0.595869113598787, -0.159748903261222, 0.438835734579072, -0.111592396536419, -0.0702364706905322, 0.216033804244876, -0.00469974431149139, -0.00209985988558712, 0.126368848383015, 0.100237307893314, 0.0549220993872048, -0.118376244602551, 0.0686718464169419, 0.0467406641758579}, {4.00097959826193, 6.50794692832149, -1.24081433861298, -0.0511819587385056, -0.828492932476502, -0.0975562492803462, -0.880682987778206, 0.0113907421698542, 0.0269508462749194, -0.00209721731863326, -0.316404955682977, -0.0573421962170347, -0.596380920694896, -0.400645046373631, 0.210913078834101, -0.0487017960155452, -0.065160191084333, -0.0216534541099589, 0.103701784540804, -0.0684690713589221, 0.0398933926548631, 0.195536231885377, 0.11268625982504, -0.0528807726668714, -0.0738147212368121, 0.133121770790919, 0.120850596287937, -0.0874471864188508, 0.0482526224096117}, {3.93566320558598, 6.10344037808261, -0.559023212581478, 0.803497686655034, -0.017685823008791, 1.11627870832748, -1.71610374760492, 1.07141166329981, -0.0053162893293557, 0.230694609210155, -0.64358252077264, 0.39751330711012, -0.367660033852018, -0.580221765663913, 0.42960719014015, -0.087644773220289, -0.091059622068357, 0.252147734337913, -0.270134499082076, -0.124026099413817, 0.161739723980556, -0.122109149012319, 0.411303430707047, 0.148575513693294, 0.0515112323646312, 0.0331382900394792, 0.0517446756689711, 0.109203109437485, -0.102374178738872}, {4.15482181622414, 6.13620308682815, -0.55850742321875, 0.489898395922736, -0.261545274220762, 0.794942205808333, -1.40935615620699, 0.558244724000074, -0.237870212712284, 0.147156984448211, -0.448437091082194, 0.156467431693835, -0.39214597484145, -0.528176882204344, 0.145160842358464, -0.0143126372468885, 0.0266587239846583, 0.140325608149416, 0.0117287875182343, -0.101115532071412, 0.0989320571412208, 0.00790190439454474, 0.172440748188118, 0.0628015330115937, -0.00956244089117735, 0.0743822239917375, 0.049845706968362, -0.00415330249437517, -0.00396716992373537}, {5.10309349530939, 4.50319127465333, 0.794832968872739, 1.66702008667976, 2.17730532018446, 0.451396081254989, -0.505575949095546, -0.108061346604248, -0.294470017332539, 0.533433563235289, -0.567938440170765, 0.284684011226127, 0.206595158228079, -0.00570916763028647, -0.0514345242976304, -0.132396341570436, 0.0614839182522748, 0.175018094609077, -0.0467812280302803, -0.116142981332499, -0.0168740424617663, 0.16206020458774, -0.0359517476626268, 0.110990252649863, -0.00822806959222202, 0.0620827382302391, -0.217515518055793, -0.0325786177480121, 0.0459054858253527}, {-2.43674873992695, 6.10402544657315, -5.4134883991158, -1.12941086515456, -0.813586930970377, 1.94280799673007, 2.82930287176856, 1.45160782489033, -0.292162395997352, -0.671702857680461, 1.00393079041119, -0.108280326352616, 1.01029137408263, -0.0127212353776241, -1.22737006280134, 0.338582009541604, -0.0696269676466257, 0.54445896030986, 0.059273012881429, -0.076398233047657, 0.42155710698592, -0.332137937485944, -0.722394278911062, -0.374903229317834, -0.00412756928847014, 0.160855778482035, 0.0420868475912497, 0.147964805503306, -0.113557890777977}, {3.83282123169081, 6.50741192217736, -1.08821289298412, 0.519267490155935, -0.223362373514135, 0.616633231649052, -0.835811561936254, 0.181905625570448, -0.393400436991195, 0.174334069703715, -0.497394119227463, 0.0665559164930642, -0.360847304450387, -0.501609982935241, -0.0676977003285492, -0.0384320503476486, 0.184199006711528, 0.0888681770769644, 0.105947769257219, -0.0776185182492335, 0.0240296997618459, 0.0821773743859448, 0.0510012327663071, -0.0140165865367137, -0.0583726530810863, 0.114281674728806, 0.067710677969753, -0.0590725358098757, 0.0377736351115484}, {5.01131812285521, -6.38435117323988, -0.0194245554889111, -2.06753339682201, -3.44360116824172, 2.13941658035997, 0.828900907780818, -0.229765932179944, 0.80360229844838, 1.34264843271308, -1.78620144485958, 1.45458745037782, 0.739613002446217, 0.936371529467363, -0.187752254646377, -1.2719275407101, -0.0202419368481078, 0.143792405749982, 0.374577083333448, -0.300119834835999, 0.456354534478251, -0.0692430365731665, 0.109514798676623, 0.272250145296524, 0.0828042488318524, 0.150999367581673, 0.249045500981693, -0.378738617708956, 0.34767828008995}, {6.28860328239642, 0.786858340153053, 2.31876510612293, -2.24934175352176, -2.80140567155993, -1.54662060285667, -0.703086265211117, -0.171640143166909, -0.165258048980973, 0.188360826164179, 0.414463663620125, -0.532374096232042, 0.439452973340269, 0.17325153877235, -0.1097435939297, -0.158431587027186, 0.143873332170946, 0.0494304366944087, -0.40766745436179, -0.0866168797638174, -0.121290117558088, 0.162735780044557, -0.27365457477244, 0.0589598196689758, -0.0364145173305872, 0.0472455912630257, 0.0237714086487439, -0.00770749451755856, -0.0354897043733125}, {5.28856797264951, -7.58955667107315, -2.12105435550623, 0.4290165771237, 0.32910352590875, -0.266336856020095, 0.926394494492871, 0.55326752573279, -0.231944574050057, -0.410436648298949, -0.135848932187859, 0.0570247720820168, -0.823802820270523, -0.682075740365765, 0.139222285306038, -0.230307194724596, 0.110535097387794, -0.00302477749460025, 0.0714152411501497, -0.115212519549582, -0.0851925886878659, 0.16302711314231, -0.166493537248735, 0.27950389272532, 0.0871024987800816, -0.137956987089932, -0.0551832457348979, 0.0696730313625031, -0.100633193935406}, {6.50040534513383, -3.5126685693756, 1.68901412372434, -1.26659082832892, -1.12542909590591, -1.4319009538628, 0.370090626135314, 1.70143502880575, 1.13256989017188, 0.332511312342714, -0.344364370410237, 0.470940276974514, 0.267317025785385, 0.103857712665746, -0.351236576508069, 0.0893855558960703, 0.173192815849813, 0.244131294741183, -0.107009101939511, 0.0216482470502781, -0.213289813855238, 0.134200247228227, -0.230740956869057, -0.0851344855957752, 0.048437754062192, -0.230007978630745, 0.053133341047189, -0.199534631818078, 0.0363945999060327}, {5.96464855764409, -5.95019946254881, 0.45270610923789, -1.40963978945527, -1.86323213783239, 0.144635565557447, 1.1962162039818, 0.65365499222197, 0.139571459526714, 0.44054172387221, -0.892928191531542, 0.729514619931935, 0.083058430970514, 0.0132115010659509, -0.213680054013097, -0.363934479544589, 0.206414620824869, 0.385060382601455, 0.0438539681031774, -0.185836545747493, -0.122961383813189, 0.296291292024293, 0.0726263055394883, 0.234924610781758, 0.0654485577754294, -0.200851157646847, 0.121849461390916, -0.168142398796958, -0.0321552124827621}, {2.99620190323381, -8.46501192503691, -6.51790111333664, 1.57942857100611, 0.0659111978843386, -1.36895734062794, -2.00401240603415, 0.242753556512267, -1.24668514980219, 0.378106399606112, -0.144984147757815, 0.222012510471196, 0.171856158451179, 0.400080793852275, -0.0417438720009874, 0.217139718904051, -0.0592531960306428, -0.0971914517315685, 0.148092801907593, -0.0635751634923138, -0.0284363292665268, 0.3672994272106, -0.0405593169931718, 0.0228954447292347, -0.00664118686694716, 0.0517429807840342, -0.230182592204363, -0.0511930595771617, 0.0962414578349617}, {3.40826082172367, 5.24507973609634, -1.73531202683941, -2.58007520248623, -4.57162826264349, -1.10970345884813, -2.12428618650875, -0.82459378166429, 0.383746639421443, -1.65261521175095, 2.3094113307125, -0.790442735283965, -0.785469755936863, 0.58211867941982, 0.559292472342024, -2.13117473739667, -0.316125400105742, -0.0545955053659748, 0.557128839135436, 0.201525553693666, -0.396835637314994, 0.125590010835606, -0.0411961097143207, -0.310775342254436, 0.0764679732590481, -0.520493340435951, -0.303492313331801, -0.0123891924802606, -0.0588595431839964}, {4.20989980566574, -7.99554281604394, -4.30422845536111, 1.2099760142093, 0.680216933648212, -2.14205934998469, -0.58027977474675, 1.76933601944263, -0.185909586413311, -0.254180015787438, 0.155389355424026, 0.480244122325061, -0.311829295097654, 0.00544425696610373, -0.545670924075527, -0.164725449809096, 0.840032255472846, -0.613591029718413, 0.418836077861375, 0.00598110755816754, -0.0410922969007822, 0.0704483664573809, 0.35157189187708, 0.0116517760299633, -0.240086708646935, 0.127994502402082, -0.440271704960635, -0.00314036962686245, 0.0365293439456535}, {5.80192168899574, -5.12772862317599, -0.124080688680221, -0.425565391908363, -0.0641201584925336, -3.81777765562812, 1.50652263306591, 1.6869289769587, -0.396800140125598, -0.266924637033042, -0.210886239851737, 0.584850282515901, 0.0627703721984669, -0.533690315955263, -0.334839217433867, -0.217023105441071, 0.369240140523572, 0.672189464196457, 0.187500584466561, 0.0950609758351376, -0.0839120747287337, -0.73005217554866, 0.492997496613095, 0.25988555877371, -0.0652774161612342, -0.300427467861373, -0.0809384884046136, 0.164802946556107, -0.112025448468608}, {3.92985128284296, -8.25455872106183, -3.77420240699753, 0.403248977249007, -0.80719246544265, 2.96601108099633, -0.186295793000696, -1.7629294880275, 1.49515736423769, 0.733567789858293, -1.07265523681588, -0.609148809342011, -0.262538572209181, -0.581728435772449, 0.541914076968673, -0.478108714743623, -0.84361892539493, 0.460700453209832, 0.602327036849556, 0.0837902456032472, -0.145891686387816, -0.205474812112759, -0.606343237642965, 0.0696108419117462, -0.123547001932662, 0.343486479992589, -0.308798757060156, 0.515685115618424, -0.15508294801621}, {6.61595237710707, -2.59693226488827, 2.39832271775193, -0.306605806203567, 0.408520537553276, 2.00073536620546, 0.36085838322316, -0.114684543126233, -0.0963519227258016, -0.359283988044452, 0.474852007154257, -0.129484935814667, -0.149683689070927, 0.169163499633652, -0.00555789693142474, 0.719208552529714, -0.0591351853223241, -0.28765647397133, 0.0757146045070324, 0.242286590069368, -0.228949522738367, 0.0430800370904509, 0.0494479166898997, -0.213188671053194, -0.0778522604948143, -0.0338240963943722, 0.0495143138667987, -0.0102019733272071, -0.0666606089445084}, {6.71515977224276, -2.39969183652492, 2.04804958448006, -0.98183931392411, -0.395712469992398, -1.77195871570883, 1.15469046583357, 0.240668268098886, -0.381313088149643, -0.140697727899577, 0.034666893253131, -0.265522120051124, 0.126021618789685, -0.35230697380632, -0.151840567106387, 0.317146097864086, 0.124061905930048, 0.405040281689643, -0.0426806353931836, -0.0561464606279319, 0.0296886246593149, 0.104549611824757, 0.132426518283181, 0.0675942649594735, 0.148215163663736, -0.107912603429908, 0.0953809819985111, 0.0629522000167408, -0.0138223987161632}, {6.26589112027355, -5.52287618074356, 0.592181262636328, -0.231764018346531, 0.2892496649729, 0.429873578265682, 1.50705062476505, 0.0842589335196524, -0.303695232473883, -0.524950935600538, 0.095744188079107, -0.133139923549316, -0.599623933092128, -0.525032542207622, 0.153272810616884, 0.143376297768052, 0.009672048413468, 0.079740465304673, -0.0541606757100554, -0.0203955007265978, -0.0613152377942868, 0.171619191657926, 0.047707521825596, -0.0206895709741696, 0.101384510367363, -0.169623137534525, 0.0634395311099873, 0.0281438853748609, -0.0678436291494231}, {5.89111857746866, 1.49612688628514, 1.8784675750888, -2.55599013574578, -3.3749379595238, -2.19940479520859, -0.452067440549476, -1.18450251537419, -0.752477494675974, -0.0285343267972573, 0.769586713408273, -1.00968056646489, 0.58618660793812, 0.170434344279668, -0.204658670766418, -0.550884944481321, 0.367200958672687, 0.0940883750753088, -0.312371860810941, -0.0817109440817352, -0.353562343438777, 0.16805209947535, -0.146776895270018, 0.221124016940459, -0.205144290902182, 0.344820062675279, 0.0683134143635497, 0.2014236691934, -0.205490385827699}, {5.83357679646189, -0.693476962869522, 2.55198018891857, -2.92775266795858, -3.96661950429251, 0.281587088911376, -0.196509627840321, -1.50236159815292, -1.69766005971695, 0.0850960578921843, 0.714223902652911, -0.523499123030298, 0.921602287874328, 0.631973904092908, -0.441087018743283, -0.568028419629662, 0.865474275401207, -0.290845062675788, -0.77920245667802, -0.332243009799821, 0.39306691255043, -0.0274452888713035, 0.326432958505784, 0.0504898455049166, -0.122837384153582, 0.361843722557007, -0.212995782182807, 0.358177638744659, -0.0602163532623993}, {6.3112586510003, -3.90589867055962, 2.11559980958816, -1.3971726044105, -1.45931491469404, 2.39428116778932, 0.796743257206935, -0.663339209424675, -0.47254833412994, 0.0127826170096989, -0.0384442147053262, 0.106666547383538, 0.0199465715226987, 0.231770487217192, 0.0416230039574417, 0.401861518655854, 0.0105791095470758, -0.349811466360564, -0.136965945604382, 0.138018768590067, 0.0816389480223484, -0.117468446734448, 0.260907005287624, -0.253734890207109, -0.0912946730284177, 0.074825530403631, -0.0838876561798146, -0.00301897617138114, 0.044501665611105}, {6.60617058683546, -3.88208166635197, 1.54205074908755, -0.553344298716389, 0.0210496351976868, -0.572077901174391, 0.561362980098573, 1.41763795382017, 1.02600083021209, -0.0395878227689407, -0.0547435875461956, 0.230334637269998, -0.0921602084340367, -0.0076502463612502, -0.245791325898613, 0.295952828866852, 0.139193559969278, -0.0215848719401136, 0.0797945433552239, 0.0403190905431166, -0.12124041561987, 0.266369307659541, -0.163146759856572, -0.115286375131562, 0.127269667473726, -0.131209081194249, 0.10451983909416, 0.00706329341180832, -0.0447700583627687}, {2.11624910338592, -7.88105887921139, -6.92538685783418, 1.71417074268242, -0.179068354445819, 1.18260609467278, -3.25497133139443, -2.11293663333576, 2.25866176867929, 1.35361543954935, -0.278992214026975, -2.01809890563749, 1.4502081270579, 0.0486753164147873, -0.582571325070259, 0.501523067815606, 0.0605204376176024, 0.94941587735171, 0.362123866314765, -0.0586365520316557, 0.00529843256255428, 0.284047096941011, 0.415696463649566, -0.189781227868699, 0.17071557109699, -0.322470297403501, -0.261709606898099, 0.271290261791042, 0.0346971900886836}, {2.03311985240773, -7.7121408860288, -7.07476507971733, 1.4770891356721, -0.477908753365426, -2.44845603390099, -2.49798813925768, 0.181796626165447, -3.68303793589345, 0.571633841448708, -0.316229024197964, 1.73244055982071, 0.724164444239769, 1.54325309195215, 0.590889705905859, 0.385327659121583, -1.21108035118276, 0.445498835721077, 0.0832545191494539, 0.196852202699949, -0.207434653522624, 0.108090907259693, -0.0956471574742831, -0.415607710071053, 0.0418764457262666, -0.0595949837763947, 0.541887972562696, 0.175616369336805, -0.270130225136245}, {5.79712173417827, 2.06799357771586, 1.02677106865037, -1.07753232227282, -0.787697368775682, -4.8065133730275, 0.694042658051757, -0.923356013124317, 0.626517956785484, 0.263609252418105, -0.230012180847153, -0.738831946837164, 0.433386552672666, -0.280009132271804, 0.306835036114719, 0.0112967887070749, -0.604425217111779, 0.171280425034107, 0.219475130687971, 0.414160699026795, -0.326880112901634, -0.731290741860896, 0.143226885207155, 0.193474335973984, -0.292884218179007, 0.390400083964557, 0.196042232244115, 0.084154862310207, -0.123036657484488}, {5.618343733432, -6.97679067904564, -0.698893679053902, -0.275322183140666, -0.417962738837657, 1.75587303071693, 1.28742320410177, -0.44115762357264, 0.0658681687153281, -0.164181570993364, -0.407683353110394, -0.0194751772498734, -0.7122920959789, -0.547150906562406, 0.38188443646207, -0.130002304015253, -0.272507997864465, 0.0503505278907196, 0.0450155125234851, 0.0161404142608874, -0.153116754830918, 0.0946100262780296, -0.136487132549553, 0.00564772496859314, -0.0390608742857228, 0.00524697317448075, -0.035874541317086, 0.0719477574146776, -0.115042279895836}, {5.8273018582832, 1.96853615785043, 2.03347993065376, -2.45840342088757, -3.52683002173753, -0.368209751360616, -1.57031192582681, -0.590430953396071, -0.719592695337513, -0.08334506094142, 0.957834794050333, -0.666875128769603, 0.330731701245489, 0.376204481676533, -0.212325535199005, -0.426123306009418, 0.406354746331944, -0.36959785139626, -0.234371943544132, -0.135730664399142, 0.115879038418632, 0.0736726039285928, -0.300156984640038, -0.0106653111744741, 0.0073818109068278, -0.0192282145019867, -0.149665895869244, 0.15330190907083, -0.0565526156458543}, {2.61633183810777, -8.09803481327507, -6.81920752923585, 1.75075335345542, 0.222688763155509, -2.35368331827025, -2.3478176692778, 0.668403182154905, -2.19976271640238, 0.194377607722814, 0.192833614963226, 0.744775063130958, 0.346431297508234, 0.897286247311331, -0.049187660432944, 0.393482422194964, -0.0256553415235285, -0.446544760325727, 0.0105468664183671, 0.10118807382164, 0.0638095058181597, 0.0861867484721048, 0.242129636671675, -0.249270060735606, -0.125769647654903, 0.163462661957551, -0.115477060406934, -0.164973408234698, 0.145114573432726}, {6.67048371714425, 0.376480675676861, 2.31896674800756, -0.459914860711801, 0.333870925721536, -1.22531925346136, 0.630147867768554, -0.648224510786496, -0.743584611775146, -0.147440889348687, 0.228616899873717, -0.624213329656692, 0.150491348851793, -0.248495338154168, -0.170400419554478, 0.545926942916928, 0.0720737835850178, 0.160892309966454, 0.263425224950813, -0.0426734229770084, 0.10706898852007, 0.244581248133965, 0.022754292940298, -0.0374728567311534, 0.110154735041492, 0.0444607662835312, 3.00647324626413E-4, -0.00927635665245623, 0.0952453729392938}, {5.93254059136326, -6.24091298782766, 0.125639649486873, -0.483331705821265, -0.52236784424801, 1.74130164745435, 0.704519037784198, 0.509502398830194, 1.2199890260865, 0.122785031014206, -0.420842790237999, 0.242050679758082, -0.334086692343437, 0.009340807578037, -0.0958392662745932, 0.0528690145410656, 0.0408947741897615, -0.287567586821155, 0.36830177980345, 0.135623762376902, -0.258934553314888, 0.248803760096277, -0.179135699864689, -0.0762062794915448, -3.52656072504341E-5, -0.042123635657785, 0.16443897825092, 0.0286978351270975, -0.197194955768459}, {4.93932554637217, -7.59922460054467, -2.82901227273087, 1.15075948297085, 1.19156949522577, -0.279087831338548, -0.169559399833623, 1.28098958744068, 1.43282169592886, -0.427896730979605, 0.383120269311244, -0.301770656221987, -0.574369111116088, -0.260410475271566, -0.46636946585911, -0.180131784816065, 0.769467732686071, -0.729927678958558, 0.281613224926253, 0.00131696239970174, -0.143382996486548, 0.294772001470286, -0.0380316530846511, 7.09022589044211E-4, -0.125453698445022, 0.188437680322225, -0.0014895347695872, 0.0768493502685693, -0.170872042478971}, {6.57538164186022, 1.15769748725547, 2.37526742268341, -0.476308968923199, 0.0887339879335202, -0.410401358182869, 0.0425379753619766, -0.60344341772888, -0.793256674908807, -0.0833589733015009, 0.287475348785087, -0.546872589842937, 0.127487547266856, -0.13620628331175, -0.223790602226111, 0.616699166682376, 0.121406854040498, 0.0336667560750428, 0.273265745935869, -0.0332733207528826, 0.031205688799863, 0.299362911030798, -0.0621714195379632, -0.0490705003998624, 0.0395731850040011, 0.0920395621893964, -0.0653465315302753, -0.0503376150009502, 0.116480897220053}, {6.59611303065886, 0.730503653827012, 2.63532349562379, -0.773649801652122, -0.517403041560686, 0.530719086617442, -0.77349653468484, 0.18475831590596, -0.225679316860074, 0.0313409751797375, 0.320244804318113, -0.189934477968361, 0.0909469700174869, 0.109831370600782, -0.130384413831265, 0.68199052567325, 0.0186153492198677, -0.172527976403219, 0.0707366889538638, 0.0211841714415388, 0.0123153300393468, 0.184115101588093, -0.159736146850453, -0.012597684757005, 0.0765207531561998, -0.00791331791576454, -0.0438288359746137, -0.0026877336128148, 0.0477829173555336}, {6.3675027989137, -4.43102386905536, 1.41903415591477, -1.55769249040409, -1.64198332768112, -1.06296830539364, 1.30548152177958, 0.562014827925733, -0.343055925911494, 0.173090981476737, -0.440016992959155, 0.315726078656569, 0.208080247941147, -0.177802688421869, -0.2314439915987, -0.107253260307339, 0.275401776024715, 0.551826192048772, -0.23729427081715, -0.167840931756692, -0.112603486158326, 0.16952161344416, 0.181156425377447, 0.237626159791268, 0.0781906092572068, -0.211465081041856, 0.14447321428132, -0.0760619876653762, -0.0681588139420129}, {5.28999119525381, -6.50698223757346, -1.81923755867995, 1.43880339516625, 2.25678293385354, -1.49811122743629, 0.300281598776169, 1.7787908968934, 1.15075623129105, -0.98942543383101, 0.950295573167605, -0.196683210909858, -0.656412750119662, -0.209176271520759, -0.411353756625364, -0.372755335513486, 0.83549412482644, -0.899369905595301, 0.0534947553024344, -0.0364766919099147, 0.293686876101757, -0.128540681845259, 0.106350125327988, -0.0900715074784592, -0.0350594628678469, 0.312702597190809, 0.0360979008040493, 0.204632346116521, 0.0079069369518851}, {4.41528444932926, -7.85124669952066, -3.91210293910489, 1.3132179348044, 1.11575750099598, -2.08438659631835, 0.0460409258910329, 1.21891221305715, -0.983470317616928, -0.75419030746089, 0.491608217725424, 0.207483657853599, -0.760314934549772, -0.435620815541323, -0.0244465338585278, -0.235434170972032, 0.477127057299325, -0.577800845600708, -0.0895020725025243, -0.0742645821361373, 0.272962929241506, -0.319120361566272, 0.0177437522124464, 0.323959339630172, 0.0500343822526587, 0.0209681330449463, -0.162145958053416, 0.0151380516809079, 0.108291912790663}, {2.32161306536668, -7.73273650418679, -6.53955524950082, 2.12783864136985, 0.805048871846585, 1.18566788101093, -3.06578457890183, -1.92920033455196, 2.56328769268057, 0.470877491062898, 0.819695506696724, -2.70676415125345, 0.907803701120526, -0.376739923601904, -0.573262447388107, 0.479096521747621, 0.647634569387276, 0.0645073020293283, -0.830449493923198, -0.0270698517342232, 0.0867253417807263, -0.317893233014588, 0.260474764586369, 0.103582308674946, -0.0412096132423806, -0.0740754868187593, 0.468563434443724, -0.448582687799192, 0.0124290175598811}, {6.26891087731801, -4.62541910237925, 1.3772668899127, -1.71031547603692, -1.93220491551047, -0.744483497002017, 1.46709945659647, 0.203684973087377, -0.686779404308691, 0.18836448587894, -0.497390308075692, 0.325826388571471, 0.229335244682775, -0.181683816279857, -0.172457144414903, -0.200923290195473, 0.274769103104435, 0.605249829440083, -0.332268008430949, -0.230823493833804, -0.0575754100837265, 0.169949905279964, 0.291747675354294, 0.298091390169142, 0.0705655173467403, -0.171828931673699, 0.15537679580842, -0.0557907531943807, -0.0782613849148112}, {6.6644195845701, -0.0189239912223178, 2.13490885798541, -0.0895711865070671, 0.886299650977648, -1.84684146049891, -0.0331434145308109, 0.989196297031821, 1.00932919571179, 0.0936708337406625, -0.0447505373059804, -0.0428190220117807, 0.0531689151219637, -0.0469715451890722, 0.088168922821092, 0.379968472383989, -0.329292287817028, 0.100211562504397, -0.0260734761085971, -0.0114332970891221, 0.182994131497929, 0.111435760665026, -0.148018651606953, -0.181952159851511, 0.127609121038287, 0.113912189215528, -0.0258534965815124, 0.121026839338204, 0.0887751166386483}, {6.02252572810301, -1.42479948350211, 1.4705313478135, -1.16363484999653, -0.926056336133023, -4.20298473126812, -0.174955771523641, 2.25412256177668, 2.15570234072008, 0.508430134457258, -0.366010102904261, 0.503467469428454, 0.566547741090627, -0.0264875816993011, -0.0334641044563895, -0.13925205882911, -0.400535975795582, 0.607909961227608, -0.4370134564724, 0.366781200475414, -0.399615776470585, -0.82256477462896, -0.225590515217072, -0.557244377324893, -0.470375464412997, 0.0473755594794736, -0.372008344992207, -0.305653566213921, 0.249339169313444}, {3.60748814296357, -8.35294013037409, -5.23777143754973, 1.54649604345542, 0.737544712770668, -0.246890385445104, -0.528477435571717, -0.802359449268311, -1.4889193949734, -0.575653100163915, 0.41402518444906, -0.576160330971812, -0.963847910604515, -0.889054322201032, 0.937822733852795, -0.123518251062441, -0.622658048584552, -0.0941358838165704, -1.01724352353437, -0.168905721300993, 0.281870520411765, -0.492483565054071, -1.07308857023857, 0.601458190354267, 0.282922321912936, -0.0294246035003948, 0.0461941515503433, -0.247182211892408, 0.27446828383455}, {5.696958831774, -5.11632808633069, 1.37376983926242, -1.87315506861514, -2.63573750587109, 3.10603982227972, 0.522732048305395, -0.416491256769021, 0.641286419815804, 0.722988256763649, -0.82279070681514, 0.794832759638462, 0.368974423942776, 0.8011725782086, -0.0310343130665914, -0.220205363366907, -0.0728357466201707, -0.610623207936345, 0.130906486722093, 0.127590998991517, 0.375623805149245, -0.394651135501632, 0.104646308956652, -0.13435344120299, 0.0120414965548922, 0.138069223764676, 0.108340637402768, -0.095583124602281, 0.147686032582832}, {6.58308777223492, -3.63140536794386, 1.7771386279502, -0.77548124334151, -0.385275041568419, 0.00143749460069473, 0.144717655296389, 1.5517905515282, 1.38769214129311, 0.156568163621557, -0.127088806500333, 0.377021648029096, 0.0195894459536642, 0.224164984643994, -0.268714276926765, 0.3575128937604, 0.095182113862256, -0.16207251308375, 0.0675357790174208, 0.09073499140015, -0.165868202325402, 0.266552843387353, -0.283470702147165, -0.136193137352078, 0.133270975847641, -0.164559449296579, 0.150198379234223, -0.0600320459382366, -0.0579276924573005}, {6.39489673410424, 1.59803278502419, 2.4826778654048, -0.839149439806029, -0.826953399756673, 0.71572158898645, -1.13822419176347, 0.0520184082388673, -0.462265810201489, 0.0251904173009238, 0.388972844322924, -0.232628566468548, 0.0816549501896093, 0.0830450941797796, -0.169919071866699, 0.637697240339548, 0.085285533421426, -0.222648823999271, 0.133002001590358, 0.0128642858167992, 0.0346067761137931, 0.117107737070013, -0.165835330840307, 0.0200035803019928, 0.0481195293840367, 9.51545410168808E-4, -0.089514954940587, -0.00149445049119925, 0.0577548938423658}, {6.18545955589463, -5.45851878220494, 0.568083918008668, 0.189052738903638, 0.941539480846004, 1.20038345424024, 1.43276465788521, -0.277946476360571, -0.198006744776983, -0.783960726120682, 0.435956712906258, -0.381688616041067, -0.760169134868934, -0.515963074111177, 0.302961249148695, 0.17973150314211, -0.113402841799317, -0.0849205226238803, -0.123575270568703, 0.0854353874616317, -0.136966766811338, 0.0614948852497905, -0.017827465255406, -0.16663212578428, -0.00348680763100379, -0.114677418332259, 0.0971957910017808, -0.0124841314254546, -0.0817329606816596}, {5.86044070676529, -6.17750389260646, 0.360150621598214, -0.999964600502952, -1.23199028989225, 1.67550749380824, 1.63441547705202, -0.717971852193814, -0.615657169726282, -0.0309112000851502, -0.545926394738568, 0.20168325070538, -0.422164996372925, -0.391810115876501, 0.354262366175278, -0.125717307028599, -0.220927988744826, 0.211690199777491, -0.152520241978544, -0.0737992119864452, 0.0190052836594959, 0.0538311142406676, 0.185235748775842, -0.0090904932016696, -0.0297614381788244, 0.0251529810123634, -0.0770186058647958, 0.0260572672075389, -0.00867814354501372}, {6.03235349449153, -4.43377575634185, 1.2826331165519, 0.132725824039922, 1.0153886752748, 2.24541396453752, 1.78698386456183, -1.68134769294522, -1.38841463949676, -1.06679983568034, 0.795071107759733, -0.633437949349873, -0.679337354519948, -0.561591776157161, 0.573442820499758, 0.359379683289825, -0.340081161730378, 0.0769732549750411, -0.355396530279728, 0.256797532293254, -0.214984900191349, -0.315186437335005, 0.314764772886019, -0.57771377975193, -0.318502368140781, -0.125827029471667, -0.231244523150468, -0.281831020150149, 0.124806755976612}, {6.28860328239642, 0.786858340153053, 2.31876510612293, -2.24934175352176, -2.80140567155993, -1.54662060285667, -0.703086265211117, -0.171640143166909, -0.165258048980973, 0.188360826164179, 0.414463663620125, -0.532374096232042, 0.439452973340269, 0.17325153877235, -0.1097435939297, -0.158431587027186, 0.143873332170946, 0.0494304366944087, -0.40766745436179, -0.0866168797638174, -0.121290117558088, 0.162735780044557, -0.27365457477244, 0.0589598196689758, -0.0364145173305872, 0.0472455912630257, 0.0237714086487439, -0.00770749451755856, -0.0354897043733125}, {5.41207495288157, -7.34063972392359, -1.13110265848925, -0.599557283601255, -1.1849539269376, 1.39543636053737, 1.03758488872998, 0.0108236956938881, 0.409364200743193, 0.354614167281461, -0.973302374960007, 0.447622207864066, -0.379415148918031, -0.259772192530918, 0.110125093098615, -0.389694434924854, -0.133129799193161, 0.200520208845893, 0.373198035045836, -0.0972091696849437, -0.148443911390983, 0.296867047607059, -0.119939276742912, 0.16998716132283, 0.0146750159715981, -0.0194536644917629, -0.0286710962103903, 0.0433399624261602, -0.0964260772104907}, {5.43414167917479, -6.70346558529509, -0.175984478176685, -1.04904210962611, -1.65581731219436, 2.78565715923955, 1.33559236862151, -1.03181584363056, 0.0584807682243581, 0.338836455104766, -0.933749001897226, 0.372366308333935, -0.322693501873548, -0.152393225147778, 0.440832601896841, -0.341775698978559, -0.450811402974748, 0.0418292497109614, 0.114840097121013, 0.0273462324888589, 0.0796410583712146, -0.149202331665885, 0.0742938892505292, -0.0989010143831152, -0.130208970706035, 0.25299203779704, -0.128061930560928, 0.092647939807011, 0.0285835284510502}, {6.30414175418556, -4.2234534552815, 1.6319470132925, -0.58199192728929, -0.0244494688409719, 1.51370158045512, 1.75191450678802, -1.28565134951079, -1.43309788041954, -0.6637624229898, 0.367848247549004, -0.415616869488214, -0.422386854196153, -0.490218111115959, 0.319874245761158, 0.419032779637062, -0.108417030209909, 0.138003249156272, -0.264159723775748, 0.0738828096629226, -0.019948906345214, -0.0416745596092867, 0.40593811659171, -0.337200668962578, -0.111210193441478, -0.0751687243265492, -0.188104129875158, -0.0930172004408492, 0.0851851873575214}, {6.53923980016782, -0.206626012507942, 2.12929726554961, -0.946736720979541, -0.309028693243593, -2.37781407543408, 1.26227779369913, -1.09202628654848, -1.14726539002825, -0.190071507907986, 0.2079879200304, -0.841604926387125, 0.335676641563983, -0.448934657892577, -0.197226379465267, 0.404240244431233, 0.16558784887402, 0.382138593448104, 0.244524203142953, -0.0241541065443781, 0.0842819353744078, 0.0230487605966779, 0.235370080713475, 0.145402732072875, 0.110180805532016, 0.0533553148495334, 0.125901893084107, 0.093038245073649, -0.0296239821062452}, {6.73714982022202, -2.88513887886439, 2.22055983914429, -0.58831384714443, 0.103960396027627, 0.612966563143561, 0.87800912080796, -0.0510414023244464, -0.348159239477998, -0.325994852285037, 0.283208793763059, -0.227721595618296, -0.147090516096692, -0.118621609781573, -0.0468926026310467, 0.557450232102615, 0.0488877569787522, -0.0129371682623665, -0.00135124426704614, 0.0435624885473961, -0.0451324725593708, 0.234245718752755, 0.0753753313792646, -0.144799377332694, 0.078717055878102, -0.087578444204794, 0.0389876506423119, -0.00420702456389194, 0.00314458338495058}, {5.98548655694873, -3.82068766980941, 2.17307665520094, -1.84557965615825, -2.39478415311103, 3.15609083168164, -0.0165898617433295, -0.235328115653983, 0.41986344983781, 0.496150701450483, -0.296605076457486, 0.613030892763612, 0.388311864153522, 0.896080120326996, -0.089579374861701, 0.216769581003401, 0.00893465209158385, -0.864922384233197, 0.0103469168272224, 0.250913842415194, 0.329171214703867, -0.514330442859511, 0.0773617471693147, -0.176177897374323, 0.0268832456307033, 0.00478404757435427, 0.0734106688326031, -0.0453323429846474, 0.076620629715664}, {6.47917365442517, 0.367036862729552, 2.62573418891823, -1.6305210309568, -1.90412804398726, -8.6506406614333E-4, -1.28426442744895, 0.762227948774155, 0.453071198659356, 0.280912176835487, 0.245326104084929, 0.008603904185405, 0.219624333398044, 0.322337018319098, -0.0343359816103188, 0.353255000257996, -0.0605949587180135, -0.256238213144213, -0.273698762168305, -0.00661091104345721, 0.0879472473410888, 0.0760490973669652, -0.376034161545947, -0.0302138828885868, 0.163805996241899, -0.207050644658436, 0.00576310137902719, -0.0814469226894047, 0.0343846233673611}};

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testKPCAThreshold() {
        System.out.println("learn threshold");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            KPCA<double[]> kpca = new KPCA<double[]>((T[])x, (MercerKernel<double[]>)new GaussianKernel(Math.sqrt(2.5)), 1.0E-4);
            Assert.assertTrue(Math.equals(this.latent, kpca.getVariances(), 0.001));
            double[][] points = kpca.project((T[])x);
            points[0] = kpca.project(x[0]);
            Assert.assertTrue(Math.equals(points, kpca.getCoordinates(), 1.0E-7));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testKPCAK() {
        System.out.println("learn k");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            KPCA<double[]> kpca = new KPCA<double[]>((T[])x, (MercerKernel<double[]>)new GaussianKernel(Math.sqrt(2.5)), 29);
            Assert.assertTrue(Math.equals(this.latent, kpca.getVariances(), 0.001));
            double[][] points = kpca.project((T[])x);
            points[0] = kpca.project(x[0]);
            Assert.assertTrue(Math.equals(points, kpca.getCoordinates(), 1.0E-7));
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

