/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import java.util.Arrays;
import smile.math.Math;
import smile.math.matrix.SparseMatrix;
import smile.plot.Graphics;
import smile.plot.Palette;
import smile.plot.Plot;
import smile.plot.PlotCanvas;

public class SparseMatrixPlot
extends Plot {
    private SparseMatrix sparse;
    private double[] x;
    private double[] y;
    private double min;
    private double max;
    private double width;
    private Color[] palette;

    public SparseMatrixPlot(SparseMatrix sparse) {
        this(sparse, Color.BLUE);
    }

    public SparseMatrixPlot(SparseMatrix sparse, Color color) {
        super(color);
        int i;
        this.sparse = sparse;
        int m = sparse.nrows();
        int n = sparse.ncols();
        this.x = new double[n];
        for (i = 0; i < this.x.length; ++i) {
            this.x[i] = (double)i + 0.5;
        }
        this.y = new double[m];
        for (i = 0; i < this.y.length; ++i) {
            this.y[i] = (double)(this.y.length - i) - 0.5;
        }
    }

    public SparseMatrixPlot(SparseMatrix sparse, int k) {
        this(sparse, Palette.jet(k, 1.0f));
    }

    public SparseMatrixPlot(SparseMatrix sparse, Color[] palette) {
        int i;
        this.sparse = sparse;
        this.palette = palette;
        int m = sparse.nrows();
        int n = sparse.ncols();
        this.x = new double[n];
        for (i = 0; i < this.x.length; ++i) {
            this.x[i] = (double)i + 0.5;
        }
        this.y = new double[m];
        for (i = 0; i < this.y.length; ++i) {
            this.y[i] = (double)(this.y.length - i) - 0.5;
        }
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        for (double z : sparse.values()) {
            if (z < this.min) {
                this.min = z;
            }
            if (!(z > this.max)) continue;
            this.max = z;
        }
        double[] values = new double[sparse.size()];
        int i2 = 0;
        for (double z : sparse.values()) {
            if (Double.isNaN(z)) continue;
            values[i2++] = z;
        }
        if (i2 > 0) {
            Arrays.sort(values, 0, i2);
            this.min = values[(int)Math.round(0.01 * (double)i2)];
            this.max = values[(int)Math.round(0.99 * (double)(i2 - 1))];
            this.width = (this.max - this.min) / (double)palette.length;
        }
    }

    @Override
    public void paint(Graphics g) {
        double z;
        int j;
        int i;
        int n;
        int m;
        Color c = g.getColor();
        double[] start = new double[2];
        double[] end = new double[2];
        if (this.palette != null) {
            m = this.sparse.nrows();
            n = this.sparse.ncols();
            for (i = 0; i < m; ++i) {
                for (j = 0; j < n; ++j) {
                    z = this.sparse.get(i, j);
                    if (z == 0.0 || Double.isNaN(z)) continue;
                    int k = (int)((z - this.min) / this.width);
                    if (k < 0) {
                        k = 0;
                    }
                    if (k >= this.palette.length) {
                        k = this.palette.length - 1;
                    }
                    g.setColor(this.palette[k]);
                    start[0] = this.x[j];
                    start[0] = j == 0 ? start[0] - Math.abs(this.x[j + 1] - this.x[j]) / 2.0 : start[0] - Math.abs(this.x[j] - this.x[j - 1]) / 2.0;
                    start[1] = this.y[i];
                    start[1] = i == 0 ? start[1] + Math.abs(this.y[i + 1] - this.y[i]) / 2.0 : start[1] + Math.abs(this.y[i] - this.y[i - 1]) / 2.0;
                    end[0] = this.x[j];
                    end[0] = j == this.x.length - 1 ? end[0] + Math.abs(this.x[j] - this.x[j - 1]) / 2.0 : end[0] + Math.abs(this.x[j + 1] - this.x[j]) / 2.0;
                    end[1] = this.y[i];
                    end[1] = i == this.y.length - 1 ? end[1] - Math.abs(this.y[i] - this.y[i - 1]) / 2.0 : end[1] - Math.abs(this.y[i + 1] - this.y[i]) / 2.0;
                    g.fillRect(start, end);
                }
            }
        } else {
            g.setColor(this.getColor());
            m = this.sparse.nrows();
            n = this.sparse.ncols();
            for (i = 0; i < m; ++i) {
                for (j = 0; j < n; ++j) {
                    z = this.sparse.get(i, j);
                    if (z == 0.0) continue;
                    start[0] = this.x[j];
                    start[0] = j == 0 ? start[0] - Math.abs(this.x[j + 1] - this.x[j]) / 2.0 : start[0] - Math.abs(this.x[j] - this.x[j - 1]) / 2.0;
                    start[1] = this.y[i];
                    start[1] = i == 0 ? start[1] + Math.abs(this.y[i + 1] - this.y[i]) / 2.0 : start[1] + Math.abs(this.y[i] - this.y[i - 1]) / 2.0;
                    end[0] = this.x[j];
                    end[0] = j == this.x.length - 1 ? end[0] + Math.abs(this.x[j] - this.x[j - 1]) / 2.0 : end[0] + Math.abs(this.x[j + 1] - this.x[j]) / 2.0;
                    end[1] = this.y[i];
                    end[1] = i == this.y.length - 1 ? end[1] - Math.abs(this.y[i] - this.y[i - 1]) / 2.0 : end[1] - Math.abs(this.y[i + 1] - this.y[i]) / 2.0;
                    g.fillRect(start, end);
                }
            }
        }
        if (this.palette != null) {
            g.clearClip();
            double height = 0.7 / (double)this.palette.length;
            start[0] = 1.1;
            start[1] = 0.15;
            end[0] = 1.13;
            end[1] = start[1] - height;
            for (i = 0; i < this.palette.length; ++i) {
                g.setColor(this.palette[i]);
                g.fillRectBaseRatio(start, end);
                start[1] = start[1] + height;
                end[1] = end[1] + height;
            }
            g.setColor(Color.BLACK);
            start[1] = start[1] - height;
            end[1] = 0.15 - height;
            g.drawRectBaseRatio(start, end);
            start[0] = 1.14;
            double log = Math.log10(Math.abs(this.max));
            int decimal = 1;
            if (log < 0.0) {
                decimal = (int)(-log) + 1;
            }
            g.drawTextBaseRatio(String.valueOf(Math.round(this.max, decimal)), 0.0, 1.0, start);
            start[1] = 0.15 - height;
            log = Math.log10(Math.abs(this.min));
            decimal = 1;
            if (log < 0.0) {
                decimal = (int)(-log) + 1;
            }
            g.drawTextBaseRatio(String.valueOf(Math.round(this.min, decimal)), 0.0, 0.0, start);
        }
        g.setColor(c);
    }

    public static PlotCanvas plot(SparseMatrix sparse) {
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{sparse.ncols(), sparse.nrows()};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new SparseMatrixPlot(sparse));
        canvas.getAxis(0).setLabelVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setLabelVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(SparseMatrix sparse, Color color) {
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{sparse.ncols(), sparse.nrows()};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new SparseMatrixPlot(sparse, color));
        canvas.getAxis(0).setLabelVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setLabelVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(SparseMatrix sparse, Color[] palette) {
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{sparse.ncols(), sparse.nrows()};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound, false);
        canvas.add(new SparseMatrixPlot(sparse, palette));
        canvas.getAxis(0).setLabelVisible(false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setLabelVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        return canvas;
    }
}

