/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import smile.plot.Axis;
import smile.plot.Base;
import smile.plot.Graphics;

class BaseGrid {
    private Base base;
    private Axis[] axis;

    public BaseGrid(Base base) {
        this.base = base;
        this.axis = new Axis[base.getDimension()];
        for (int i = 0; i < base.getDimension(); ++i) {
            this.axis[i] = new Axis(base, i);
        }
    }

    public BaseGrid(Base base, String ... axisLabels) {
        if (axisLabels.length != base.getDimension()) {
            throw new IllegalArgumentException("Axis label size don't match base dimension.");
        }
        this.base = base;
        this.axis = new Axis[base.getDimension()];
        for (int i = 0; i < base.getDimension(); ++i) {
            this.axis[i] = new Axis(base, i, axisLabels[i]);
        }
    }

    public BaseGrid setLabelVisible(int i, boolean v) {
        this.axis[i].setLabelVisible(v);
        return this;
    }

    public boolean isLabelVisible(int i) {
        return this.axis[i].isLabelVisible();
    }

    public BaseGrid setGridVisible(int i, boolean v) {
        this.axis[i].setGridVisible(v);
        return this;
    }

    public boolean isGridVisible(int i) {
        return this.axis[i].isGridVisible();
    }

    public BaseGrid setFrameVisible(boolean v) {
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].setGridVisible(v);
        }
        return this;
    }

    public boolean isFrameVisible() {
        return this.axis[0].isGridVisible();
    }

    public Axis getAxis(int i) {
        return this.axis[i];
    }

    public BaseGrid setAxisLabel(String ... axisLabels) {
        if (axisLabels.length != this.base.getDimension()) {
            throw new IllegalArgumentException("Axis label size don't match base dimension.");
        }
        for (int i = 0; i < axisLabels.length; ++i) {
            this.axis[i].setAxisLabel(axisLabels[i]);
        }
        return this;
    }

    public String[] getAxisLabel() {
        String[] array = new String[this.axis.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.axis[i].getAxisLabel();
        }
        return array;
    }

    public BaseGrid setAxisLabel(int i, String axisLabel) {
        this.axis[i].setAxisLabel(axisLabel);
        return this;
    }

    public String getAxisLabel(int i) {
        return this.axis[i].getAxisLabel();
    }

    public BaseGrid setBase(Base base) {
        this.base = base;
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].setBase(base);
        }
        return this;
    }

    public void paint(Graphics g) {
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].paint(g);
        }
    }
}

