/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Plot;
import smile.plot.PlotCanvas;

public class BarPlot
extends Plot {
    double[][] data;
    String[] description;
    double width;
    double[][] leftTop;
    double[][] rightTop;
    double[][] leftBottom;
    double[][] rightBottom;

    public BarPlot(int[] data) {
        super(Color.BLUE);
        this.data = new double[data.length][2];
        for (int i = 0; i < data.length; ++i) {
            this.data[i][0] = (double)i + 0.5;
            this.data[i][1] = data[i];
        }
        this.init();
    }

    public BarPlot(double[] data) {
        super(Color.BLUE);
        this.data = new double[data.length][2];
        for (int i = 0; i < data.length; ++i) {
            this.data[i][0] = (double)i + 0.5;
            this.data[i][1] = data[i];
        }
        this.init();
    }

    public BarPlot(String[] description, double[] data) {
        super(Color.BLUE);
        if (data.length != description.length) {
            throw new IllegalArgumentException("Data size and label size don't match.");
        }
        this.description = description;
        this.data = new double[data.length][2];
        for (int i = 0; i < data.length; ++i) {
            this.data[i][0] = (double)i + 0.5;
            this.data[i][1] = data[i];
        }
        this.init();
    }

    public BarPlot(int[][] data) {
        super(Color.BLUE);
        if (data[0].length != 2) {
            throw new IllegalArgumentException("Invalid data dimension: " + data[0].length);
        }
        this.data = new double[data.length][2];
        for (int i = 0; i < data.length; ++i) {
            this.data[i][0] = data[i][0];
            this.data[i][1] = data[i][1];
        }
        this.init();
    }

    public BarPlot(double[][] data) {
        super(Color.BLUE);
        if (data[0].length != 2) {
            throw new IllegalArgumentException("Dataset is not 2-dimensional.");
        }
        this.data = data;
        this.init();
    }

    private void init() {
        int i;
        this.width = Double.MAX_VALUE;
        for (i = 1; i < this.data.length; ++i) {
            double w = Math.abs(this.data[i][0] - this.data[i - 1][0]);
            if (!(this.width > w)) continue;
            this.width = w;
        }
        this.leftTop = new double[this.data.length][2];
        this.rightTop = new double[this.data.length][2];
        this.leftBottom = new double[this.data.length][2];
        this.rightBottom = new double[this.data.length][2];
        for (i = 0; i < this.data.length; ++i) {
            this.leftTop[i][0] = this.data[i][0] - this.width / 2.0;
            this.leftTop[i][1] = this.data[i][1];
            this.rightTop[i][0] = this.data[i][0] + this.width / 2.0;
            this.rightTop[i][1] = this.data[i][1];
            this.leftBottom[i][0] = this.data[i][0] - this.width / 2.0;
            this.leftBottom[i][1] = 0.0;
            this.rightBottom[i][0] = this.data[i][0] + this.width / 2.0;
            this.rightBottom[i][1] = 0.0;
        }
    }

    public double getWidth() {
        return this.width;
    }

    @Override
    public String getToolTip(double[] coord) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.rightTop[i][1] > this.rightBottom[i][1]) {
                if (!(coord[0] < this.rightBottom[i][0]) || !(coord[0] > this.leftBottom[i][0]) || !(coord[1] < this.rightTop[i][1]) || !(coord[1] > this.rightBottom[i][1])) continue;
                if (this.description == null) {
                    return String.format("data[%d] = %g", i, this.data[i][1]);
                }
                return String.format("%s = %g", this.description[i], this.data[i][1]);
            }
            if (!(coord[0] < this.rightBottom[i][0]) || !(coord[0] > this.leftBottom[i][0]) || !(coord[1] > this.rightTop[i][1]) || !(coord[1] < this.rightBottom[i][1])) continue;
            if (this.description == null) {
                return String.format("data[%d] = %g", i, this.data[i][1]);
            }
            return String.format("%s = %g", this.description[i], this.data[i][1]);
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        int i;
        Color c = g.getColor();
        g.setColor(Color.BLACK);
        for (i = 0; i < this.data.length; ++i) {
            g.drawLine(this.leftBottom[i], this.leftTop[i]);
            g.drawLine(this.leftTop[i], this.rightTop[i]);
            g.drawLine(this.rightTop[i], this.rightBottom[i]);
            g.drawLine(this.rightBottom[i], this.leftBottom[i]);
        }
        g.setColor(this.getColor());
        for (i = 0; i < this.data.length; ++i) {
            g.fillPolygon(0.2f, (double[][])new double[][]{this.leftBottom[i], this.leftTop[i], this.rightTop[i], this.rightBottom[i]});
        }
        g.setColor(c);
    }

    public static PlotCanvas plot(double[] data) {
        return BarPlot.plot(null, data);
    }

    public static PlotCanvas plot(String id, double[] data) {
        double[] lowerBound = new double[]{0.0, Math.min(data)};
        double[] upperBound = new double[]{data.length, Math.max(data)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        BarPlot plot = new BarPlot(data);
        plot.setID(id);
        canvas.add(plot);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(0).setLabelVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(double[] data, String[] labels) {
        return BarPlot.plot(null, data, labels);
    }

    public static PlotCanvas plot(String id, double[] data, String[] labels) {
        if (data.length != labels.length) {
            throw new IllegalArgumentException("Data size and label size don't match.");
        }
        double[] lowerBound = new double[]{0.0, Math.min(data)};
        double[] upperBound = new double[]{data.length, Math.max(data)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        BarPlot plot = new BarPlot(labels, data);
        plot.setID(id);
        canvas.add(plot);
        double[] locations = new double[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            locations[i] = (double)i + 0.5;
        }
        canvas.getAxis(0).addLabel(labels, locations);
        canvas.getAxis(0).setGridVisible(false);
        return canvas;
    }

    public static PlotCanvas plot(double[] ... data) {
        return BarPlot.plot(null, data);
    }

    public static PlotCanvas plot(String id, double[] ... data) {
        if (data[0].length != 2) {
            throw new IllegalArgumentException("Dataset is not 2-dimensional.");
        }
        double[] lowerBound = Math.colMin(data);
        double[] upperBound = Math.colMax(data);
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        canvas.getAxis(0).setGridVisible(false);
        BarPlot plot = new BarPlot(data);
        plot.setID(id);
        canvas.add(plot);
        return canvas;
    }
}

