/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp;

import java.util.Arrays;
import java.util.HashMap;
import smile.nlp.AnchorText;
import smile.nlp.Text;
import smile.nlp.TextTerms;

public class SimpleText
extends Text
implements TextTerms,
AnchorText {
    private String anchor;
    private String[] words;
    private HashMap<String, Integer> freq = new HashMap();
    private int maxtf;

    public SimpleText(String id, String title, String body, String[] words) {
        super(id, title, body);
        this.words = words;
        for (String w : words) {
            Integer f = this.freq.get(w);
            f = f == null ? Integer.valueOf(1) : Integer.valueOf(f + 1);
            this.freq.put(w, f);
            if (f <= this.maxtf) continue;
            this.maxtf = f;
        }
    }

    @Override
    public int size() {
        return this.words.length;
    }

    @Override
    public Iterable<String> words() {
        return Arrays.asList(this.words);
    }

    @Override
    public Iterable<String> unique() {
        return this.freq.keySet();
    }

    @Override
    public int tf(String term) {
        Integer f = this.freq.get(term);
        if (f == null) {
            return 0;
        }
        return f;
    }

    @Override
    public int maxtf() {
        return this.maxtf;
    }

    @Override
    public String getAnchor() {
        return this.anchor;
    }

    @Override
    public SimpleText setAnchor(String anchor) {
        this.anchor = anchor;
        return this;
    }

    @Override
    public SimpleText addAnchor(String linkLabel) {
        this.anchor = this.anchor == null ? linkLabel : this.anchor + " " + linkLabel;
        return this;
    }

    public String toString() {
        return String.format("Document[%s%s]", this.getID(), this.getTitle() == null ? "" : " -- " + this.getTitle());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleText other = (SimpleText)obj;
        return this.getID().equals(other.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

