/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.Cholesky;
import smile.math.matrix.EVD;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;
import smile.math.matrix.MatrixMultiplication;
import smile.math.matrix.QR;
import smile.math.matrix.SVD;

public abstract class DenseMatrix
extends Matrix
implements MatrixMultiplication<DenseMatrix, DenseMatrix> {
    public abstract double[] data();

    public abstract int ld();

    public abstract double set(int var1, int var2, double var3);

    public double update(int i, int j, double x) {
        return this.set(i, j, x);
    }

    public abstract LU lu();

    public LU lu(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.lu();
    }

    public abstract Cholesky cholesky();

    public Cholesky cholesky(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.cholesky();
    }

    public abstract QR qr();

    public QR qr(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.qr();
    }

    public abstract SVD svd();

    public SVD svd(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.svd();
    }

    public abstract EVD eigen();

    public EVD eigen(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.eigen();
    }

    public abstract double[] eig();

    public double[] eig(boolean inPlace) {
        DenseMatrix a = inPlace ? this : this.copy();
        return a.eig();
    }

    @Override
    public abstract DenseMatrix transpose();

    public DenseMatrix inverse() {
        return this.inverse(false);
    }

    public DenseMatrix inverse(boolean inPlace) {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("Call inverse() on a non-square matrix");
        }
        LU lu = this.lu(inPlace);
        return lu.inverse();
    }

    public double norm1() {
        int m = this.nrows();
        int n = this.ncols();
        double f = 0.0;
        for (int j = 0; j < n; ++j) {
            double s = 0.0;
            for (int i = 0; i < m; ++i) {
                s += Math.abs(this.get(i, j));
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public double norm2() {
        return this.svd(false).norm();
    }

    public double norm() {
        return this.norm2();
    }

    public double normInf() {
        int m = this.nrows();
        int n = this.ncols();
        double[] f = new double[m];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int n2 = i;
                f[n2] = f[n2] + Math.abs(this.get(i, j));
            }
        }
        return Math.max(f);
    }

    public double normFro() {
        int m = this.nrows();
        int n = this.ncols();
        double f = 0.0;
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                f = Math.hypot(f, this.get(i, j));
            }
        }
        return f;
    }

    public double xax(double[] x) {
        if (this.nrows() != this.ncols()) {
            throw new IllegalArgumentException("The matrix is not square");
        }
        if (this.nrows() != x.length) {
            throw new IllegalArgumentException("Matrix and vector size doesn't match for x' * A * x");
        }
        int n = x.length;
        double s = 0.0;
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < n; ++i) {
                s += this.get(i, j) * x[i] * x[j];
            }
        }
        return s;
    }

    public double[] rowSums() {
        int m = this.nrows();
        int n = this.ncols();
        double[] x = new double[m];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int n2 = i;
                x[n2] = x[n2] + this.get(i, j);
            }
        }
        return x;
    }

    public double[] rowMeans() {
        int m = this.nrows();
        int n = this.ncols();
        double[] x = new double[m];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int n2 = i;
                x[n2] = x[n2] + this.get(i, j);
            }
        }
        int i = 0;
        while (i < m) {
            int n3 = i++;
            x[n3] = x[n3] / (double)n;
        }
        return x;
    }

    public double[] colSums() {
        int m = this.nrows();
        int n = this.ncols();
        double[] x = new double[n];
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                int n2 = j;
                x[n2] = x[n2] + this.get(i, j);
            }
        }
        return x;
    }

    public double[] colMeans() {
        int m = this.nrows();
        int n = this.ncols();
        double[] x = new double[n];
        int j = 0;
        while (j < n) {
            for (int i = 0; i < m; ++i) {
                int n2 = j;
                x[n2] = x[n2] + this.get(i, j);
            }
            int n3 = j++;
            x[n3] = x[n3] / (double)m;
        }
        return x;
    }

    public abstract DenseMatrix copy();

    @Override
    public abstract DenseMatrix ata();

    @Override
    public abstract DenseMatrix aat();

    public abstract double add(int var1, int var2, double var3);

    public abstract double sub(int var1, int var2, double var3);

    public abstract double mul(int var1, int var2, double var3);

    public abstract double div(int var1, int var2, double var3);

    public DenseMatrix add(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) + b.get(i, j));
            }
        }
        return c;
    }

    public DenseMatrix add(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.add(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public DenseMatrix sub(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) - b.get(i, j));
            }
        }
        return c;
    }

    public DenseMatrix sub(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.sub(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public DenseMatrix mul(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) * b.get(i, j));
            }
        }
        return c;
    }

    public DenseMatrix mul(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.mul(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public DenseMatrix div(DenseMatrix b, DenseMatrix c) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) / b.get(i, j));
            }
        }
        return c;
    }

    public DenseMatrix div(DenseMatrix b) {
        if (this.nrows() != b.nrows() || this.ncols() != b.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.div(i, j, b.get(i, j));
            }
        }
        return this;
    }

    public DenseMatrix add(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) + x);
            }
        }
        return c;
    }

    public DenseMatrix add(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.add(i, j, x);
            }
        }
        return this;
    }

    public DenseMatrix sub(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) - x);
            }
        }
        return c;
    }

    public DenseMatrix sub(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.sub(i, j, x);
            }
        }
        return this;
    }

    public DenseMatrix mul(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) * x);
            }
        }
        return c;
    }

    public DenseMatrix mul(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.mul(i, j, x);
            }
        }
        return this;
    }

    public DenseMatrix div(double x, DenseMatrix c) {
        if (this.nrows() != c.nrows() || this.ncols() != c.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                c.set(i, j, this.get(i, j) / x);
            }
        }
        return c;
    }

    public DenseMatrix div(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.div(i, j, x);
            }
        }
        return this;
    }

    public DenseMatrix replaceNaN(double x) {
        int m = this.nrows();
        int n = this.ncols();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!Double.isNaN(this.get(i, j))) continue;
                this.set(i, j, x);
            }
        }
        return this;
    }

    public double sum() {
        int m = this.nrows();
        int n = this.ncols();
        double s = 0.0;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                s += this.get(i, j);
            }
        }
        return s;
    }

    public double[][] array() {
        double[][] V = new double[this.nrows()][this.ncols()];
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                V[i][j] = this.get(i, j);
            }
        }
        return V;
    }
}

