/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

public class Cholesky {
    protected DenseMatrix L;

    public Cholesky(DenseMatrix L) {
        if (L.nrows() != L.ncols()) {
            throw new UnsupportedOperationException("Cholesky constructor on a non-square matrix");
        }
        this.L = L;
    }

    public DenseMatrix getL() {
        return this.L;
    }

    public double det() {
        double d = 1.0;
        for (int i = 0; i < this.L.nrows(); ++i) {
            d *= this.L.get(i, i);
        }
        return d * d;
    }

    public DenseMatrix inverse() {
        int n = this.L.nrows();
        DenseMatrix inv = Matrix.eye(n);
        this.solve(inv);
        return inv;
    }

    public void solve(double[] b) {
        DenseMatrix B = Matrix.newInstance(b);
        this.solve(B);
    }

    public void solve(DenseMatrix B) {
        int i;
        int j;
        int k;
        if (B.nrows() != this.L.nrows()) {
            throw new IllegalArgumentException(String.format("Row dimensions do not agree: A is %d x %d, but B is %d x %d", this.L.nrows(), this.L.ncols(), B.nrows(), B.ncols()));
        }
        int n = B.nrows();
        int nrhs = B.ncols();
        for (k = 0; k < n; ++k) {
            for (j = 0; j < nrhs; ++j) {
                for (i = 0; i < k; ++i) {
                    B.sub(k, j, B.get(i, j) * this.L.get(k, i));
                }
                B.div(k, j, this.L.get(k, k));
            }
        }
        for (k = n - 1; k >= 0; --k) {
            for (j = 0; j < nrhs; ++j) {
                for (i = k + 1; i < n; ++i) {
                    B.sub(k, j, B.get(i, j) * this.L.get(i, k));
                }
                B.div(k, j, this.L.get(k, k));
            }
        }
    }
}

