/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.manifold.LaplacianEigenmap;
import smile.math.Math;

public class LaplacianEigenmapTest {
    AttributeDataset swissroll;

    public LaplacianEigenmapTest() {
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setDelimiter("\t");
        try {
            this.swissroll = parser.parse("Swissroll", IOUtils.getTestDataFile("manifold/swissroll.txt"));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /*
     * Opcode count of 13069 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    @Test
    public void testLearn() {
        System.out.println("learn");
        double[][] points = new double[][]{{0.015, 0.0125}, {-0.0186, 0.012}, {0.0434, -0.0024}, {0.0332, 0.0175}, {-0.011, 0.0075}, {0.0096, 0.0215}, {-0.0201, 0.0163}, {0.0347, -0.0175}, {0.0075, -0.0239}, {0.0388, -0.0354}, {0.041, 0.0466}, {-0.0329, -0.0094}, {0.0344, 0.0499}, {-0.0411, 0.0123}, {-0.0317, 0.0254}, {-0.0198, -0.0092}, {-0.0339, 0.0222}, {0.0358, -0.0073}, {-0.0433, -0.0106}, {-0.0459, 0.0274}, {-0.0035, -0.0188}, {-0.0459, 0.0287}, {-0.0468, 0.0341}, {-0.0233, -0.0168}, {0.0232, 0.0137}, {0.0395, 0.0569}, {-0.0222, -0.0397}, {-0.026, 0.0221}, {-0.0211, 0.0034}, {0.0325, 0.0457}, {0.0298, 0.0372}, {0.0318, 0.0088}, {-0.0187, 0.01}, {0.0344, 0.0231}, {-0.0448, 0.0048}, {0.0399, -0.0331}, {0.0297, -0.0421}, {0.0237, -0.0391}, {0.0236, 0.0319}, {-0.0305, -0.0312}, {-0.0011, -0.053}, {-0.0031, -0.0328}, {-0.0399, 0.0122}, {0.0163, -0.0073}, {0.0369, -0.0367}, {-0.0053, -0.0444}, {0.0041, -0.0282}, {-0.0471, 0.0332}, {0.0239, 0.0114}, {-0.0456, 0.0233}, {-0.0221, -0.0025}, {-0.0126, -0.0112}, {0.0162, -0.0391}, {-0.04, 0.0106}, {0.0137, -0.0044}, {-0.0213, -0.0254}, {0.0244, 0.0356}, {0.0393, 0.0599}, {0.0205, 0.0265}, {-0.0312, -0.0071}, {-0.0104, -0.0502}, {-0.0466, 0.0285}, {-0.0474, 0.0279}, {-0.0254, -0.0141}, {-0.0171, 0.0062}, {0.0275, -0.0473}, {-0.0474, 0.0324}, {0.0383, -0.0383}, {0.0252, -0.048}, {0.0151, 0.0188}, {-0.0111, 0.0162}, {0.0016, 0.0175}, {-0.0124, 0.0057}, {0.0408, 0.0443}, {0.0076, 0.0198}, {0.0426, 0.0116}, {0.0402, 0.0047}, {-0.0397, 0.009}, {0.0373, -0.0348}, {-0.0413, -0.014}, {0.0222, 0.0333}, {0.0307, -0.0142}, {0.0246, 0.0392}, {0.0162, -0.0391}, {-0.0036, -0.0344}, {0.0293, -0.0152}, {-0.0234, -0.0148}, {-0.0107, -0.05}, {0.0366, -0.0171}, {0.0328, 0.0152}, {-0.0434, -0.0097}, {-0.0104, -0.0147}, {0.0333, 0.0215}, {0.0126, -0.0016}, {0.0427, 0.0014}, {0.0387, 0.0623}, {-0.0436, 0.0133}, {0.0238, -0.0413}, {-0.047, 0.0341}, {0.0232, 0.0292}, {0.0431, -6.0E-4}, {-0.0101, -0.044}, {-0.0474, 0.0334}, {-0.025, 0.0221}, {-0.0415, 0.0266}, {-0.0313, 0.025}, {-0.018, 0.0135}, {0.023, -0.0442}, {0.0383, -0.0351}, {-0.0238, 0.0041}, {-0.0305, -0.0073}, {0.0445, 0.012}, {-0.0053, -0.0403}, {0.0317, -0.0088}, {0.0141, 0.0115}, {-0.0139, -0.0423}, {0.0075, 0.0228}, {-0.025, -0.0302}, {0.0283, -0.0154}, {0.0398, -0.0305}, {0.0313, -0.0405}, {0.0389, -0.0393}, {0.0295, 0.0363}, {0.0248, 0.0392}, {-0.0053, -0.0403}, {-0.0073, 0.0069}, {0.0214, -0.0229}, {0.0174, 0.0216}, {0.04, 0.0365}, {-0.0423, -0.0093}, {0.0218, 0.0357}, {0.0442, 0.0818}, {0.0032, -0.0487}, {0.0215, 0.0354}, {0.0153, -0.0053}, {0.0311, 0.0359}, {0.0396, -0.0388}, {0.0415, -0.0228}, {-0.025, -0.0295}, {0.0409, -0.0324}, {-0.0036, -0.0397}, {-0.0421, 0.0267}, {-0.0425, -0.0094}, {0.0064, 0.0225}, {0.0174, -0.05}, {-0.0476, 0.0343}, {-0.0071, 0.0036}, {-0.0252, -0.0359}, {0.0097, -0.0494}, {0.0408, 8.0E-4}, {-0.0449, 0.013}, {0.0177, -0.0382}, {0.0444, 0.0093}, {0.0131, 0.0213}, {0.0267, -0.0177}, {-0.0361, 0.0202}, {0.0362, -0.0029}, {0.0255, 0.0399}, {0.0394, -0.0329}, {-7.0E-4, 0.0058}, {-0.0393, -3.0E-4}, {0.0395, -0.039}, {-0.0454, 0.02}, {0.0228, 0.0327}, {0.0242, 0.0388}, {-0.0181, 0.013}, {0.0214, 0.0165}, {-0.0432, -0.0068}, {-0.0293, -0.0072}, {0.0402, 0.0678}, {-0.0365, -0.0221}, {-0.0079, 0.0138}, {-0.0315, 0.025}, {-0.0404, -0.0125}, {0.0399, 0.0023}, {0.0379, -0.008}, {0.0049, 0.0175}, {0.0042, -0.0505}, {-0.0367, 0.0192}, {0.005, 0.0185}, {-0.011, 0.0056}, {-0.0348, -0.0109}, {-0.0031, -0.0375}, {0.0215, 0.0325}, {0.0189, -0.0132}, {0.0356, 0.0311}, {-0.0194, -0.0408}, {0.0436, -0.0013}, {-0.0436, -0.0052}, {-0.0319, -0.0294}, {0.0415, 0.0459}, {0.001, -0.0093}, {0.0287, 0.0315}, {-0.0305, -0.0312}, {0.0385, 0.0605}, {0.0368, -0.0238}, {0.0421, 0.0585}, {0.0117, 0.0191}, {0.0033, 0.0157}, {0.0242, 0.0386}, {0.0259, 0.0394}, {-0.0434, 0.0327}, {0.0133, -3.0E-4}, {-0.0484, 0.0344}, {0.0409, -0.0324}, {0.039, -0.0346}, {-0.0013, -0.0159}, {-0.0228, -0.0345}, {6.0E-4, 0.0173}, {-0.021, -0.0406}, {-0.0232, -0.0159}, {-0.0473, 0.0265}, {-0.0326, -0.0116}, {-0.047, 0.0251}, {0.0352, -0.0346}, {-0.0436, -0.0086}, {-0.0286, -0.0238}, {-0.027, 0.0082}, {-0.0423, -0.013}, {0.0386, -0.0279}, {9.0E-4, -0.0528}, {0.0446, 0.0161}, {0.0058, -0.0265}, {0.0447, 0.0149}, {0.0036, -0.0519}, {-0.0026, -0.04}, {0.0432, -0.0053}, {-0.0463, 0.0282}, {-0.039, 0.0276}, {0.0236, -0.0461}, {0.0091, -0.048}, {-0.0013, 0.0188}, {0.0179, -0.0386}, {0.0439, 0.0077}, {0.0408, 0.0697}, {0.04, 0.0022}, {0.0238, -0.0486}, {0.0313, -0.0441}, {-0.0367, -0.0097}, {0.0332, 0.0429}, {0.0162, -0.0067}, {0.0436, -2.0E-4}, {0.0351, 0.0294}, {0.0169, -0.0026}, {-0.0338, 0.0192}, {0.0427, 0.0014}, {-0.0405, 0.0229}, {-0.0226, -0.0014}, {0.04, 0.0591}, {-0.0448, 0.0337}, {0.041, 0.0616}, {0.0055, 0.0178}, {-0.0044, -0.013}, {-0.0437, -0.0076}, {-0.0455, 0.0337}, {0.0263, -0.0471}, {-0.0182, -0.0421}, {-0.0452, 0.02}, {0.002, 0.0168}, {-0.047, 0.0304}, {0.039, 7.0E-4}, {0.0433, -0.003}, {-0.0189, -0.0432}, {-0.0463, 0.0275}, {0.0342, -0.038}, {0.0154, 1.0E-4}, {-0.0427, -0.0086}, {0.0408, 0.0697}, {-0.0289, -0.0328}, {-0.0358, 0.0195}, {0.006, 0.0223}, {0.0391, -0.0299}, {-0.0483, 0.0338}, {0.0409, -0.0324}, {0.0345, -0.0377}, {0.0393, -0.039}, {0.0061, -0.0046}, {-0.0255, -0.0295}, {-0.0232, -0.0265}, {-0.0436, -0.0016}, {0.0142, 0.001}, {0.0424, 0.0638}, {-0.0316, -0.0075}, {0.0283, 0.0166}, {-0.0203, -0.0076}, {-0.0476, 0.0318}, {0.0246, 0.0124}, {0.0402, 0.0677}, {0.0248, 0.0148}, {0.0204, 0.0342}, {0.0213, -0.0221}, {-0.0159, 0.0056}, {-0.0383, -0.0081}, {0.0027, -0.0489}, {-0.0158, -0.011}, {0.0156, 0.0255}, {-0.0086, -0.0099}, {-0.0344, 0.0197}, {0.0215, 0.0354}, {0.0312, 0.0416}, {-0.0281, 0.0236}, {0.027, -0.0469}, {0.0118, -0.0134}, {-0.0302, 0.0247}, {0.0039, 0.0214}, {-0.0459, 0.0265}, {-0.0397, -0.0128}, {-0.0452, 0.0339}, {0.0376, -0.0308}, {0.0098, 0.0199}, {0.011, 0.015}, {0.0238, 0.0384}, {-0.0101, -0.0504}, {-0.0405, 0.0231}, {0.0446, 0.0141}, {0.0046, -0.0315}, {0.0273, -0.0475}, {0.0263, 0.0328}, {-0.0381, -7.0E-4}, {0.0359, -0.0135}, {0.0054, -0.0324}, {0.0189, -0.0399}, {-0.0424, -0.01}, {0.0128, 0.0257}, {0.0166, 0.0235}, {0.0355, -0.0117}, {-0.0327, 0.0258}, {-0.0453, 0.021}, {0.0268, 0.0374}, {-0.0309, -0.0307}, {0.0067, -0.0512}, {-0.0432, -0.0064}, {0.0404, -0.0283}, {0.0329, 0.046}, {-0.0083, -0.0509}, {0.0398, -0.0301}, {-0.0105, -0.0427}, {-0.0188, -0.0119}, {-0.0443, -5.0E-4}, {0.0212, -0.0487}, {-0.0318, 0.0247}, {-0.0452, 0.0242}, {4.0E-4, -0.0417}, {0.0339, 0.0292}, {0.0387, -0.0392}, {0.0146, 0.0092}, {-0.0087, -0.0511}, {0.0217, -0.0471}, {-0.0223, -0.0202}, {0.0033, -0.0492}, {-0.0061, -0.05}, {-0.0446, 0.0034}, {0.0342, -0.0406}, {-0.0119, -0.0437}, {0.0225, 0.0313}, {0.0443, 0.0825}, {2.0E-4, -0.0208}, {-0.0015, 0.0013}, {0.0247, 0.034}, {0.0153, -0.0505}, {0.0248, -0.0448}, {-0.047, 0.0284}, {-0.0136, 0.0059}, {-8.0E-4, -0.0239}, {-0.0319, -0.0078}, {-0.0298, -0.032}, {-0.0042, -0.0391}, {-0.0467, 0.0343}, {-0.0457, 0.0225}, {-0.0465, 0.0294}, {-0.0483, 0.0344}, {0.0078, 0.019}, {-0.0179, -0.0412}, {-0.043, -0.0117}, {-0.0391, 0.004}, {0.0013, 0.0166}, {0.0287, 0.0355}, {0.0277, -0.0432}, {0.0408, -0.0304}, {0.0335, -0.0378}, {0.0443, 0.082}, {0.0128, -0.0068}, {0.041, 0.0424}, {0.0198, -0.0493}, {-0.0202, 0.0073}, {0.0441, 0.0798}, {0.0118, 0.0188}, {-0.0408, 0.0214}, {0.0272, -0.0474}, {0.0342, 0.0304}, {-0.0284, -0.0334}, {0.0223, 0.0319}, {-0.0397, 0.0291}, {0.044, 0.0048}, {0.0403, 0.0472}, {-0.0358, 0.0195}, {0.0294, -0.0183}, {-0.0024, 0.0011}, {0.0406, 0.0692}, {-0.0294, 0.0244}, {-0.0329, -0.0094}, {0.01, 0.0234}, {0.0172, -0.0056}, {0.0371, -0.0213}, {0.0375, -0.0393}, {-0.0316, 0.0152}, {-0.0369, -0.0209}, {-0.0309, -0.0307}, {-0.0175, -0.0422}, {-0.0341, 0.0188}, {-0.0339, 0.0264}, {0.0289, 0.0067}, {-0.0408, 4.0E-4}, {-0.0086, -0.0509}, {0.0141, 0.0063}, {-0.009, -0.05}, {0.0377, -0.0391}, {-0.0446, 0.033}, {0.0103, 0.0211}, {0.0282, -0.0134}, {-0.014, -0.0386}, {-0.041, 0.0044}, {0.0066, 0.0224}, {0.0308, 0.0039}, {0.022, -0.0203}, {0.0398, 0.0662}, {-0.0112, -0.0428}, {-0.0337, -0.0266}, {-0.0071, -0.0079}, {-0.0071, -0.0062}, {0.0226, 0.0324}, {0.0383, -0.0372}, {-0.0477, 0.0322}, {-0.0391, -0.0156}, {0.0061, -0.0463}, {-0.0275, 0.0233}, {0.0202, -0.0295}, {-0.0439, -0.0059}, {-0.0089, -0.0509}, {-0.0175, 0.0183}, {-0.0102, -0.0497}, {-0.0484, 0.0344}, {-0.0329, 0.0254}, {0.0424, 0.0638}, {-0.0229, -0.0392}, {0.0447, 0.0153}, {-0.025, -0.0304}, {-0.0011, -0.0496}, {0.0238, -0.0451}, {0.0409, -0.032}, {0.0446, 0.0155}, {-0.0026, -0.0322}, {-0.0394, -0.0176}, {-0.044, -0.0022}, {-0.0389, -0.0072}, {-0.0392, -0.0162}, {-0.0353, 0.0239}, {0.0213, -0.0221}, {-0.0227, -0.0164}, {0.0284, 0.0368}, {0.0412, -0.0233}, {0.0286, 0.0309}, {0.0225, 0.0332}, {-0.0167, -0.0452}, {-0.0302, -0.0072}, {-0.0244, -0.0067}, {0.0379, -0.0371}, {0.0217, -0.0241}, {-0.0161, 0.0157}, {-0.0328, -0.028}, {0.0259, -0.0431}, {0.0397, -0.0388}, {0.0222, 0.0139}, {0.0235, -0.0416}, {0.0353, -0.0365}, {0.0408, 0.0473}, {-0.0011, -9.0E-4}, {0.0244, -0.0428}, {-0.0228, 0.0029}, {-0.0249, 0.0053}, {0.0294, 0.0352}, {-0.0395, -0.0096}, {0.0399, -0.0385}, {7.0E-4, -0.0035}, {-0.0089, -0.0089}, {0.03, 0.0378}, {0.0442, 0.0819}, {-0.0405, 0.0123}, {0.0435, 0.0194}, {-0.0163, 0.0175}, {0.0291, 0.0371}, {0.001, -0.003}, {-0.0186, 0.012}, {-0.0183, -0.0429}, {-0.0027, -0.0411}, {0.0075, 0.022}, {-0.0376, 0.0}, {-0.0361, 0.0192}, {0.036, -0.0214}, {0.0217, -0.049}, {-0.0412, -0.0026}, {-0.043, -0.0115}, {0.0186, -0.0483}, {0.0016, -0.0234}, {0.0432, 0.0147}, {0.0422, 0.0642}, {0.0279, 0.0258}, {0.0442, 0.0168}, {0.031, 0.0083}, {-0.0473, 0.0341}, {0.0193, 0.0017}, {0.0016, -0.0487}, {-0.0158, 0.0174}, {0.0195, -0.0497}, {0.0105, -0.0498}, {0.0015, -0.0533}, {-0.0404, -0.0161}, {-0.0428, -0.0122}, {0.0246, 0.0392}, {0.0343, 0.027}, {0.0442, 0.0078}, {0.0235, 0.0138}, {0.0443, 0.0825}, {-0.0077, -0.0059}, {-0.0475, 0.0285}, {0.0289, -0.0464}, {-0.0446, 0.0272}, {-0.0301, -0.008}, {-0.043, 0.0253}, {-0.0356, -0.0236}, {0.044, 0.0047}, {0.0132, -0.0489}, {-0.0386, 0.0283}, {0.0358, -0.0406}, {0.0398, -0.0287}, {-0.0435, 0.0112}, {0.0401, -0.0379}, {-0.0366, -0.0095}, {-0.0269, -0.0258}, {0.0063, -0.0247}, {-0.0452, 0.0115}, {-0.0243, 0.0031}, {-0.0437, -0.0078}, {-0.0229, -0.0253}, {0.0401, 0.0421}, {-0.0043, -0.029}, {-0.0384, 0.025}, {-0.0475, 0.0327}, {-0.0308, 0.0241}, {0.0396, -0.0381}, {-0.0165, -0.0106}, {-0.0431, 0.0124}, {0.0391, -0.0299}, {-0.0463, 0.0281}, {0.0282, -0.0134}, {-0.048, 0.032}, {-0.0385, -0.0184}, {-0.0482, 0.0344}, {-0.0162, 0.0178}, {-0.0476, 0.0292}, {0.0382, -0.0366}, {-0.0436, -0.006}, {-0.0036, 0.0032}, {-0.0413, -0.0143}, {0.0414, 0.0183}, {-0.0465, 0.0274}, {0.0027, 0.0171}, {0.0025, 0.0141}, {0.0418, -0.0204}, {-0.0033, -0.035}, {-9.0E-4, -0.0127}, {0.0256, -0.039}, {0.0193, 0.017}, {-0.0451, 0.0338}, {0.0438, 0.0795}, {0.042, 0.0613}, {0.0344, -0.0355}, {-0.0346, -0.0093}, {1.0E-4, -0.0488}, {-0.0038, -0.0378}, {-0.0036, -0.0352}, {-0.002, 0.0169}, {-0.0393, -0.0068}, {0.0335, -0.0423}, {0.0177, 0.0014}, {-0.0351, 0.0198}, {-0.0364, -0.0073}, {0.0023, 0.0202}, {-0.0235, -0.0383}, {0.0438, 0.001}, {-0.0449, 0.0065}, {0.0174, -0.0377}, {-0.0066, -0.0097}, {0.0443, 0.0817}, {-0.0106, -0.0429}, {-0.0464, 0.0343}, {-0.0459, 0.0191}, {0.0053, 0.022}, {0.0377, 0.0338}, {-0.04, -0.0036}, {-0.0479, 0.0311}, {-0.0385, 0.0176}, {0.0438, 0.0114}, {-0.0469, 0.0315}, {-0.0288, 0.024}, {0.0443, 0.0825}, {0.0223, 0.031}, {-0.0065, -0.0466}, {0.044, 0.0186}, {-0.0454, 0.0179}, {0.0345, -0.0412}, {-0.0227, -0.0383}, {0.0423, -0.0147}, {0.0431, -0.0063}, {-0.037, -0.0088}, {0.0284, 0.0329}, {-0.0025, -0.0403}, {-0.0409, 0.0242}, {-0.0433, -0.0042}, {-0.0275, -0.0059}, {-0.0216, -0.016}, {-0.0049, 0.0151}, {0.0096, -0.0183}, {0.0039, -0.0485}, {0.0045, -0.0527}, {0.043, 0.0187}, {0.0362, -0.0083}, {-0.0241, 0.0026}, {-0.0445, 0.0092}, {0.0387, 0.0623}, {0.0023, -0.0532}, {-0.0362, 0.019}, {-0.0246, -0.0321}, {0.0019, -0.0475}, {-0.023, -0.0173}, {0.0402, -0.0307}, {0.0014, 0.0051}, {-0.0481, 0.032}, {-0.0396, -0.0061}, {0.0149, -0.002}, {0.0406, -0.035}, {4.0E-4, -0.0175}, {-0.0329, 0.0254}, {-0.0257, -0.0287}, {0.0291, -0.0457}, {-0.0314, -0.0093}, {0.0414, 0.0476}, {0.0365, -0.0346}, {0.0443, 0.0819}, {0.04, 0.0022}, {-0.0439, 0.0331}, {-0.0397, -0.0124}, {0.0143, 0.027}, {-0.0429, -0.0118}, {0.0437, 0.0161}, {0.0307, 0.0047}, {-0.0178, 0.0178}, {-0.0438, -0.0045}, {0.0202, 0.0286}, {0.0362, -0.008}, {-0.0446, 0.0336}, {0.0164, 0.0149}, {-0.0012, 0.0176}, {-0.025, -0.0362}, {0.0286, -0.0439}, {0.0141, -0.0028}, {-0.0376, 0.0246}, {6.0E-4, 0.0182}, {0.023, -0.0218}, {0.0394, 0.063}, {0.0397, 9.0E-4}, {-0.0458, 0.0341}, {0.0097, 0.0233}, {-0.0064, -0.0016}, {0.0395, 0.0016}, {-0.0401, 0.0174}, {0.0442, 0.0817}, {-0.0115, -0.0424}, {-0.0225, -0.0188}, {0.037, -0.0401}, {0.0424, -0.0137}, {-0.0483, 0.0344}, {0.0307, -0.0142}, {-0.0334, -0.005}, {0.0405, 0.0688}, {0.0398, 0.0602}, {-0.0483, 0.0338}, {0.003, -0.0351}, {-0.043, -0.0117}, {0.0165, -0.0067}, {0.0425, 0.0698}, {0.0257, 0.014}, {0.0357, -0.0093}, {-0.0399, -0.0166}, {0.0441, 0.0798}, {0.0299, 0.039}, {0.0302, 0.0378}, {-0.0462, 0.031}, {0.0397, 0.0013}, {0.0237, -0.0391}, {-0.0257, -0.0284}, {0.0138, -0.0081}, {0.0266, -0.043}, {0.0112, 0.0194}, {0.0435, 0.0123}, {-0.0073, -0.0424}, {-0.0203, 0.0053}, {-0.0407, 0.0234}, {0.0408, -0.0283}, {0.0271, -0.0476}, {-0.0232, 0.0045}, {-0.0393, -0.0068}, {0.0313, 0.0456}, {-0.0044, 9.0E-4}, {0.0424, 0.0652}, {-0.0203, -0.0415}, {-0.0234, -0.0164}, {-0.0202, -0.0419}, {-0.042, 0.0277}, {-0.0402, 0.0112}, {-0.0224, -0.0221}, {-0.0091, -0.0438}, {0.0183, -0.044}, {-0.0061, -0.0517}, {-0.0421, -0.0112}, {0.0292, 0.018}, {0.0228, 0.037}, {0.0288, -0.0428}, {0.0381, -0.032}, {-0.013, -0.0484}, {-0.0313, 0.025}, {-0.0224, -0.0054}, {0.0395, 0.0601}, {-0.0117, -0.0431}, {-0.0484, 0.0344}, {0.0297, 0.0111}, {-0.0432, -0.0113}, {0.0395, -0.039}, {-0.0383, -0.0095}, {0.025, 0.011}, {0.0012, -0.0532}, {-0.0266, 0.0225}, {0.0191, -0.0413}, {0.0267, 0.0318}, {-0.0463, 0.0283}, {-0.0466, 0.0286}, {0.022, 0.0349}, {-0.0131, 0.0056}, {0.0366, 0.0536}, {0.0446, 0.016}, {0.0442, 0.0816}, {0.0437, 0.0161}, {0.0045, -0.0413}, {-0.0425, 0.0083}, {0.0141, 0.0115}, {-0.0175, 0.0185}, {-0.0315, -0.0075}, {-8.0E-4, -0.0187}, {0.0283, -0.047}, {0.0265, -0.015}, {0.0265, 0.0101}, {0.0284, -0.0468}, {0.0031, -0.0243}, {0.0175, -0.05}, {0.0362, -0.0117}, {-0.0378, 0.0282}, {-0.0438, -0.0062}, {-0.0329, 0.0171}, {-0.0437, -0.0056}, {0.013, 0.0158}, {0.0057, -0.0491}, {0.0402, -0.0371}, {0.0442, 0.0078}, {0.0436, 0.0788}, {-0.0042, 0.0166}, {-0.0423, -0.0095}, {-0.0456, 0.0208}, {0.0351, -0.0304}, {0.0241, -0.0441}, {0.0445, 0.0163}, {-0.0035, -0.0339}, {0.0361, 0.0553}, {0.0401, -0.0379}, {-0.0446, 0.0336}, {-0.0449, 0.0202}, {0.0294, 0.0347}, {0.0353, -0.0072}, {0.0339, -0.0068}, {-0.0478, 0.0304}, {-0.043, 0.0141}, {0.0285, 0.0331}, {-0.0311, -0.0075}, {-0.0341, 0.0174}, {-0.02, -0.0407}, {0.0354, -0.0274}, {-0.012, 0.0057}, {-0.0025, -0.0157}, {-0.0391, 0.0253}, {0.0223, 0.0308}, {0.0042, -0.0296}, {-0.0015, -0.0481}, {0.0111, -0.0499}, {-0.0019, 0.0026}, {0.0349, -0.0353}, {-0.0402, -0.0036}, {-0.0451, 0.0087}, {0.043, 0.0023}, {-5.0E-4, -0.0}, {-0.025, -0.0284}, {-0.0346, 0.0206}, {-8.0E-4, -0.0531}, {0.0218, -0.0484}, {-0.045, 0.0077}, {-0.0362, -0.007}, {-0.0406, 0.0221}, {0.0069, -0.0466}, {0.0318, 0.0014}, {-0.0042, -0.0383}, {0.0087, 0.0235}, {-0.0037, -0.0407}, {-0.0372, 0.0013}, {-0.0394, 0.0261}, {-0.0358, -0.0093}, {0.0226, 0.0369}, {0.002, -0.0533}, {0.0358, -0.0406}, {0.0216, 0.0346}, {0.04, 0.0365}, {0.0178, -0.0397}, {-0.0346, -0.0093}, {-0.0403, 0.0253}, {-0.0394, 0.0078}, {0.0109, 0.0182}, {0.0276, 0.0218}, {-0.0029, -0.0483}, {-0.0459, 0.0341}, {-0.0354, -0.0117}, {-0.0403, 0.0272}, {-0.0349, 0.0268}, {-0.0475, 0.032}, {0.0217, 0.0127}, {0.0348, -0.0385}, {0.0422, 0.0642}, {1.0E-4, -0.0488}, {-4.0E-4, -0.0032}, {0.036, -0.0197}, {0.0405, 0.0688}, {-0.0294, 0.0242}, {0.0089, -0.0244}, {-0.0322, -0.0086}, {-0.0018, -0.0397}, {-7.0E-4, 0.017}, {0.0312, 0.0147}, {-0.0325, -0.0063}, {0.0446, 0.0139}, {0.0411, -0.0304}, {-0.0476, 0.0303}, {0.0048, -0.0264}, {-0.0401, 0.0105}, {-0.0402, 0.0108}, {-0.0408, 4.0E-4}, {-0.0136, 0.0066}, {-0.0182, -0.0421}, {0.0246, 0.039}, {-0.0237, -0.0022}, {-0.0152, -0.0115}, {-0.0362, 0.0229}, {0.0408, 0.0473}, {0.0171, -0.0387}, {-0.0439, -0.0057}, {-0.0224, -0.0102}, {-0.0435, -0.0092}, {0.0236, 0.0099}, {-0.023, 0.0024}, {-0.0137, -0.0479}, {0.0233, -0.0476}, {0.044, 0.0047}, {-0.0107, -0.046}, {0.043, -0.0069}, {0.0228, -0.0293}, {-0.0455, 0.0222}, {0.038, 0.0588}, {0.0018, -0.0262}, {0.0341, 0.0117}, {0.0311, 0.0407}, {-0.0459, 0.017}, {0.0409, -0.0333}, {-0.0442, 0.0161}, {-0.0407, 0.0266}, {-0.0463, 0.0272}, {-0.0091, 0.003}, {-0.04, 0.0213}, {0.0446, 0.0155}, {0.0427, 0.0014}, {0.0119, 0.0231}, {0.0218, -0.0391}, {0.0406, 0.0542}, {-0.0471, 0.0331}, {-0.024, -0.0027}, {-0.015, -0.043}, {-0.0465, 0.0296}, {0.0401, -0.0379}, {-0.0451, 0.0099}, {0.0152, -7.0E-4}, {-0.0036, 0.0032}, {0.019, -0.0406}, {-0.0481, 0.0324}, {0.0345, 0.0313}, {-0.045, 0.0338}, {0.0286, -0.0024}, {0.0033, -0.0527}, {0.0398, -0.0284}, {0.0423, 0.0342}, {0.0247, -0.0472}, {-0.0439, 0.0331}, {-0.0224, -0.0054}, {-0.0426, -0.0123}, {-0.0356, 0.0206}, {-0.0163, 0.0115}, {0.0138, 0.0214}, {0.0228, -0.0466}, {0.0368, -0.0018}, {-0.0281, 0.0236}, {0.0227, -0.0486}, {-0.0294, 0.0244}, {-0.0406, 0.0302}, {0.0431, 0.0012}, {0.0162, -0.0371}, {-0.0247, -0.0283}, {0.0419, 0.0726}, {0.0405, 0.0049}, {0.0345, 0.028}, {-0.0138, 0.0177}, {0.0011, -0.0077}, {-0.0396, 0.0238}, {-0.0126, -0.0112}, {0.0429, -0.009}, {0.0323, -6.0E-4}, {-0.0386, -0.0188}, {0.0218, 0.0084}, {0.0031, -0.047}, {-0.0402, 0.0144}, {0.0142, -0.0501}, {0.0333, -0.0408}, {0.0144, 0.0065}, {-0.0454, 0.0268}, {0.0261, -0.043}, {0.0177, -0.0044}, {0.0427, 0.0671}, {-0.0213, -0.0254}, {0.0077, 0.0229}, {0.0311, -0.0153}, {-0.0171, 0.0167}, {0.0442, 0.082}, {0.0385, 0.0368}, {0.0252, 0.0386}, {-0.0191, -0.0418}, {-0.0147, 0.0168}, {0.0204, 0.0048}, {-0.0417, -0.014}, {-0.0471, 0.0341}, {-0.0436, -0.0071}, {0.0051, 0.0219}, {-0.0256, -0.031}, {0.0396, 0.0585}, {-0.0437, 0.0277}, {0.0195, 0.033}, {-0.0391, -0.0156}, {-0.0416, -0.0107}, {-0.0378, 0.0282}, {0.0298, -0.0143}, {-0.0086, -0.0428}, {0.0415, 0.0459}, {0.0443, 0.0819}, {-0.013, -0.0485}, {-0.0063, -0.0519}, {0.0255, -0.0433}, {0.0327, -0.0127}, {-0.0237, 0.0045}, {-0.0435, -0.0062}, {-0.0399, -0.0166}, {0.038, -0.0374}, {-0.044, 0.0121}, {0.0433, 0.0081}, {0.0357, -0.0093}, {0.0429, 0.0034}, {0.0092, -0.042}, {-0.0221, -0.0174}, {0.0405, 0.0687}, {0.0067, 0.0227}, {0.0279, -0.0431}, {-0.0163, -0.0457}, {0.0015, -0.0533}, {0.0036, 0.021}, {0.0188, -0.0404}, {-0.0432, 0.0115}, {-0.0472, 0.0265}, {0.0142, -0.0499}, {0.0297, -0.0421}, {-0.0432, -0.0103}};
        double[][] dat = (double[][])this.swissroll.toArray((E[])new double[this.swissroll.size()][]);
        double[][] data = new double[1000][];
        System.arraycopy(dat, 0, data, 0, data.length);
        LaplacianEigenmap laplacianEigenmap = new LaplacianEigenmap(data, 2, 7);
        double[][] coords = laplacianEigenmap.getCoordinates();
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points[0].length; ++j) {
                Assert.assertEquals(Math.abs(points[i][j]), Math.abs(coords[i][j]), 1.0E-4);
            }
        }
    }
}

