/*
 * Decompiled with CFR 0.152.
 */
package smile.gap;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.gap.BitString;
import smile.gap.Chromosome;
import smile.gap.FitnessMeasure;
import smile.gap.GeneticAlgorithm;

public class GeneticAlgorithmTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testEvolve() {
        System.out.println("evolve");
        Chromosome[] seeds = new BitString[100];
        for (int i = 0; i < seeds.length; ++i) {
            seeds[i] = new BitString(15, (FitnessMeasure<BitString>)new Knapnack(), BitString.Crossover.UNIFORM, 1.0, 0.2);
        }
        GeneticAlgorithm instance = new GeneticAlgorithm(seeds, GeneticAlgorithm.Selection.TOURNAMENT);
        instance.setElitism(2);
        instance.setTournament(3, 0.95);
        BitString result = (BitString)instance.evolve(1000, 18.0);
        Assert.assertEquals(18.0, result.fitness(), 1.0E-7);
        int[] best = new int[]{1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        for (int i = 0; i < best.length; ++i) {
            Assert.assertEquals(best[i], result.bits()[i]);
        }
    }

    class Knapnack
    implements FitnessMeasure<BitString> {
        int limit = 9;
        int[] weight = new int[]{2, 3, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        double[] reward = new double[]{6.0, 6.0, 6.0, 5.0, 1.3, 1.2, 1.1, 1.0, 1.1, 1.3, 1.0, 1.0, 0.9, 0.8, 0.6};

        Knapnack() {
        }

        @Override
        public double fit(BitString chromosome) {
            double wsum = 0.0;
            double rew = 0.0;
            int[] bits = chromosome.bits();
            for (int i = 0; i < this.weight.length; ++i) {
                if (bits[i] != 1) continue;
                wsum += (double)this.weight[i];
                rew += this.reward[i];
            }
            if (wsum > (double)this.limit) {
                rew -= 5.0 * (wsum - (double)this.limit);
            }
            return rew;
        }
    }
}

