/*
 * Decompiled with CFR 0.152.
 */
package smile.gap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.gap.Chromosome;
import smile.gap.LamarckianChromosome;
import smile.math.Math;
import smile.util.MulticoreExecutor;

public class GeneticAlgorithm<T extends Chromosome> {
    private static final Logger logger = LoggerFactory.getLogger(GeneticAlgorithm.class);
    private int size;
    private T[] population;
    private Selection selection = Selection.TOURNAMENT;
    private int elitism = 1;
    private int tournamentSize = 3;
    private double tournamentProbability = 0.95;
    private int t = 5;
    private List<Task> tasks = new ArrayList<Task>();

    public GeneticAlgorithm(T[] seeds) {
        this((Chromosome[])seeds, Selection.TOURNAMENT);
    }

    public GeneticAlgorithm(T[] seeds, Selection selection) {
        this.size = seeds.length;
        this.population = seeds;
        this.selection = selection;
        for (int i = 0; i < this.size; ++i) {
            this.tasks.add(new Task(i));
        }
    }

    public T[] population() {
        return this.population;
    }

    public GeneticAlgorithm<T> setElitism(int elitism) {
        if (elitism < 0 || elitism >= this.size) {
            throw new IllegalArgumentException("Invalid elitism: " + elitism);
        }
        this.elitism = elitism;
        return this;
    }

    public int getElitism() {
        return this.elitism;
    }

    public GeneticAlgorithm<T> setTournament(int size, double p) {
        if (size < 1) {
            throw new IllegalArgumentException("Invalid tournament size: " + size);
        }
        if (p < 0.5 || p > 1.0) {
            throw new IllegalArgumentException("Invalid best-player-wins probability: " + p);
        }
        this.tournamentSize = size;
        this.tournamentProbability = p;
        return this;
    }

    public int getTournamentSize() {
        return this.tournamentSize;
    }

    public double getTournamentProbability() {
        return this.tournamentProbability;
    }

    public GeneticAlgorithm<T> setLocalSearchSteps(int t) {
        if (t < 0) {
            throw new IllegalArgumentException("Invalid of number of iterations of local search: " + t);
        }
        this.t = t;
        return this;
    }

    public int getLocalSearchSteps() {
        return this.t;
    }

    public T evolve(int generation) {
        return this.evolve(generation, Double.POSITIVE_INFINITY);
    }

    public T evolve(int generation, double threshold) {
        if (generation <= 0) {
            throw new IllegalArgumentException("Invalid number of generations to go: " + generation);
        }
        try {
            MulticoreExecutor.run(this.tasks);
        }
        catch (Exception ex) {
            logger.error("Failed to run Genetic Algorithm on multi-core", ex);
            for (Task task : this.tasks) {
                task.call();
            }
        }
        Arrays.sort(this.population);
        T best = this.population[this.size - 1];
        Chromosome[] offsprings = new Chromosome[this.size];
        for (int g = 1; g <= generation && best.fitness() < threshold; ++g) {
            int i;
            for (i = 0; i < this.elitism; ++i) {
                offsprings[i] = this.population[this.size - i - 1];
            }
            for (i = this.elitism; i < this.size; i += 2) {
                Chromosome father = this.select((Chromosome[])this.population);
                Chromosome mother = this.select((Chromosome[])this.population);
                while (mother == father) {
                    mother = this.select((Chromosome[])this.population);
                }
                Chromosome[] children = father.crossover(mother);
                offsprings[i] = children[0];
                offsprings[i].mutate();
                if (i + 1 >= this.size) continue;
                offsprings[i + 1] = children[1];
                offsprings[i + 1].mutate();
            }
            System.arraycopy(offsprings, 0, this.population, 0, this.size);
            try {
                MulticoreExecutor.run(this.tasks);
            }
            catch (Exception ex) {
                logger.error("Failed to run Genetic Algorithm on multi-core", ex);
                for (Task task : this.tasks) {
                    task.call();
                }
            }
            Arrays.sort(this.population);
            best = this.population[this.size - 1];
            double avg = 0.0;
            for (T ch : this.population) {
                avg += ch.fitness();
            }
            logger.info(String.format("Genetic Algorithm: generation %d, best fitness %g, average fitness %g", g, best.fitness(), avg /= (double)this.size));
        }
        return best;
    }

    private T select(T[] population) {
        double worst = population[0].fitness();
        double[] fitness = new double[this.size];
        switch (this.selection) {
            case ROULETTE_WHEEL: {
                if (worst > 0.0) {
                    worst = 0.0;
                }
                for (int i = 0; i < this.size; ++i) {
                    fitness[i] = population[i].fitness() - worst;
                }
                Math.unitize1(fitness);
                return population[Math.random(fitness)];
            }
            case SCALED_ROULETTE_WHEEL: {
                for (int i = 0; i < this.size; ++i) {
                    fitness[i] = population[i].fitness() - worst;
                }
                Math.unitize1(fitness);
                return population[Math.random(fitness)];
            }
            case RANK: {
                for (int i = 0; i < this.size; ++i) {
                    fitness[i] = i + 1;
                }
                Math.unitize1(fitness);
                return population[Math.random(fitness)];
            }
            case TOURNAMENT: {
                int i;
                Object[] pool = new Chromosome[this.tournamentSize];
                for (i = 0; i < this.tournamentSize; ++i) {
                    pool[i] = population[Math.randomInt(this.size)];
                }
                Arrays.sort(pool);
                for (i = 1; i <= this.tournamentSize; ++i) {
                    double p = Math.random();
                    if (!(p < this.tournamentProbability)) continue;
                    return (T)pool[this.tournamentSize - i];
                }
                return (T)pool[this.tournamentSize - 1];
            }
        }
        return null;
    }

    class Task
    implements Callable<Task> {
        final int i;

        Task(int i) {
            this.i = i;
        }

        @Override
        public Task call() {
            Chromosome chromosome = GeneticAlgorithm.this.population[this.i];
            if (chromosome instanceof LamarckianChromosome) {
                LamarckianChromosome ch = (LamarckianChromosome)chromosome;
                for (int j = 0; j < GeneticAlgorithm.this.t; ++j) {
                    ch.evolve();
                }
            }
            chromosome.fitness();
            return this;
        }
    }

    public static enum Selection {
        ROULETTE_WHEEL,
        SCALED_ROULETTE_WHEEL,
        RANK,
        TOURNAMENT;

    }
}

