/*
 * Decompiled with CFR 0.152.
 */
package smile.gap;

import smile.gap.Chromosome;
import smile.gap.FitnessMeasure;
import smile.math.Math;

public class BitString
implements Chromosome {
    public final int length;
    private int[] bits;
    private double mutationRate = 0.01;
    private Crossover crossover = Crossover.TWO_POINT;
    private double crossoverRate = 0.9;
    private FitnessMeasure<BitString> measure;
    private double fitness = Double.NaN;

    public BitString(int length, FitnessMeasure<BitString> measure) {
        if (length <= 0) {
            throw new IllegalArgumentException("Invalid bit string length: " + length);
        }
        this.length = length;
        this.measure = measure;
        this.bits = new int[length];
        for (int i = 0; i < length; ++i) {
            this.bits[i] = Math.random() > 0.5 ? 1 : 0;
        }
    }

    public BitString(int length, FitnessMeasure<BitString> measure, Crossover crossover, double crossoverRate, double mutationRate) {
        if (length <= 0) {
            throw new IllegalArgumentException("Invalid bit string length: " + length);
        }
        if (crossoverRate < 0.0 || crossoverRate > 1.0) {
            throw new IllegalArgumentException("Invalid crossover rate: " + crossoverRate);
        }
        if (mutationRate < 0.0 || mutationRate > 1.0) {
            throw new IllegalArgumentException("Invalid mutation rate: " + mutationRate);
        }
        this.length = length;
        this.measure = measure;
        this.crossoverRate = crossoverRate;
        this.mutationRate = mutationRate;
        this.crossover = crossover;
        this.bits = new int[length];
        for (int i = 0; i < length; ++i) {
            this.bits[i] = Math.random() > 0.5 ? 1 : 0;
        }
    }

    public BitString(int[] bits, FitnessMeasure<BitString> measure) {
        this.bits = bits;
        this.length = bits.length;
        this.measure = measure;
    }

    public BitString(int[] bits, FitnessMeasure<BitString> measure, Crossover crossover, double crossoverRate, double mutationRate) {
        this.bits = bits;
        this.length = bits.length;
        this.measure = measure;
        this.crossoverRate = crossoverRate;
        this.mutationRate = mutationRate;
        this.crossover = crossover;
    }

    public int[] bits() {
        return this.bits;
    }

    @Override
    public int compareTo(Chromosome o) {
        return (int)Math.signum(this.fitness - o.fitness());
    }

    @Override
    public double fitness() {
        if (Double.isNaN(this.fitness)) {
            this.fitness = this.measure.fit(this);
        }
        return this.fitness;
    }

    @Override
    public BitString newInstance() {
        return new BitString(this.length, this.measure, this.crossover, this.crossoverRate, this.mutationRate);
    }

    public BitString[] crossover(Chromosome another) {
        if (!(another instanceof BitString)) {
            throw new IllegalArgumentException("The input parent is NOT bit string chromosome.");
        }
        BitString mother = (BitString)another;
        BitString[] offsprings = new BitString[2];
        if (Math.random() < this.crossoverRate) {
            switch (this.crossover) {
                case SINGLE_POINT: {
                    this.singlePointCrossover(this, mother, offsprings);
                    break;
                }
                case TWO_POINT: {
                    this.twoPointCrossover(this, mother, offsprings);
                    break;
                }
                case UNIFORM: {
                    this.uniformCrossover(this, mother, offsprings);
                }
            }
        } else {
            offsprings[0] = this;
            offsprings[1] = mother;
        }
        return offsprings;
    }

    private void singlePointCrossover(BitString father, BitString mother, BitString[] offsprings) {
        int point = 0;
        while (point == 0) {
            point = Math.randomInt(this.length);
        }
        int[] son = new int[this.length];
        System.arraycopy(father.bits, 0, son, 0, point);
        System.arraycopy(mother.bits, point, son, point, this.length - point);
        int[] daughter = new int[this.length];
        System.arraycopy(mother.bits, 0, daughter, 0, point);
        System.arraycopy(father.bits, point, daughter, point, this.length - point);
        offsprings[0] = new BitString(son, this.measure, this.crossover, this.crossoverRate, this.mutationRate);
        offsprings[1] = new BitString(daughter, this.measure, this.crossover, this.crossoverRate, this.mutationRate);
    }

    private void twoPointCrossover(BitString father, BitString mother, BitString[] offsprings) {
        int point1 = 0;
        while (point1 == 0 || point1 == this.length - 1) {
            point1 = Math.randomInt(this.length);
        }
        int point2 = 0;
        while (point2 == point1 || point2 == 0 || point2 == this.length - 1) {
            point2 = Math.randomInt(this.length);
        }
        if (point2 < point1) {
            int p = point1;
            point1 = point2;
            point2 = p;
        }
        int[] son = new int[this.length];
        System.arraycopy(father.bits, 0, son, 0, point1);
        System.arraycopy(mother.bits, point1, son, point1, point2 - point1);
        System.arraycopy(father.bits, point2, son, point2, this.length - point2);
        int[] daughter = new int[this.length];
        System.arraycopy(mother.bits, 0, daughter, 0, point1);
        System.arraycopy(father.bits, point1, daughter, point1, point2 - point1);
        System.arraycopy(mother.bits, point2, daughter, point2, this.length - point2);
        offsprings[0] = new BitString(son, this.measure, this.crossover, this.crossoverRate, this.mutationRate);
        offsprings[1] = new BitString(daughter, this.measure, this.crossover, this.crossoverRate, this.mutationRate);
    }

    private void uniformCrossover(BitString father, BitString mother, BitString[] offsprings) {
        int[] son = new int[this.length];
        int[] daughter = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            if (Math.random() < 0.5) {
                son[i] = father.bits[i];
                daughter[i] = mother.bits[i];
                continue;
            }
            son[i] = mother.bits[i];
            daughter[i] = father.bits[i];
        }
        offsprings[0] = new BitString(son, this.measure, this.crossover, this.crossoverRate, this.mutationRate);
        offsprings[1] = new BitString(daughter, this.measure, this.crossover, this.crossoverRate, this.mutationRate);
    }

    @Override
    public void mutate() {
        for (int i = 0; i < this.length; ++i) {
            if (!(Math.random() < this.mutationRate)) continue;
            int n = i;
            this.bits[n] = this.bits[n] ^ 1;
        }
    }

    public static enum Crossover {
        SINGLE_POINT,
        TWO_POINT,
        UNIFORM;

    }
}

