/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.LDA;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.feature.GAFeatureSelection;
import smile.gap.BitString;
import smile.math.Math;
import smile.validation.Accuracy;

public class GAFeatureSelectionTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testLearn() {
        System.out.println("learn");
        int size = 100;
        int generation = 20;
        LDA.Trainer trainer = new LDA.Trainer();
        Accuracy measure = new Accuracy();
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            BitString[] result;
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            GAFeatureSelection instance = new GAFeatureSelection();
            for (BitString bits : result = instance.learn(size, generation, trainer, measure, x, y, testx, testy)) {
                System.out.format("%.2f%% %d ", 100.0 * bits.fitness(), Math.sum(bits.bits()));
                for (int i = 0; i < x[0].length; ++i) {
                    System.out.print(bits.bits()[i] + " ");
                }
                System.out.println();
            }
            Assert.assertTrue(result[result.length - 1].fitness() > 0.88);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

