/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.DateAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.IOUtils;
import smile.feature.DateFeature;

public class DateFeatureTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAttributes() {
        System.out.println("attributes");
        try {
            ArffParser parser = new ArffParser();
            AttributeDataset data = parser.parse(IOUtils.getTestDataFile("weka/date.arff"));
            DateFeature.Type[] features = new DateFeature.Type[]{DateFeature.Type.YEAR, DateFeature.Type.MONTH, DateFeature.Type.DAY_OF_MONTH, DateFeature.Type.DAY_OF_WEEK, DateFeature.Type.HOURS, DateFeature.Type.MINUTES, DateFeature.Type.SECONDS};
            DateFeature df = new DateFeature(features);
            Attribute[] attributes = df.attributes();
            Assert.assertEquals(features.length, attributes.length);
            for (int i = 0; i < attributes.length; ++i) {
                System.out.println(attributes[i]);
                if (i == 1 || i == 3) {
                    Assert.assertEquals((Object)Attribute.Type.NOMINAL, (Object)attributes[i].getType());
                    continue;
                }
                Assert.assertEquals((Object)Attribute.Type.NUMERIC, (Object)attributes[i].getType());
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testFeature() {
        System.out.println("feature");
        double[][] result = new double[][]{{2001.0, 3.0, 3.0, 2.0, 12.0, 12.0, 12.0}, {2001.0, 4.0, 3.0, 4.0, 12.0, 59.0, 55.0}};
        try {
            ArffParser parser = new ArffParser();
            AttributeDataset data = parser.parse(IOUtils.getTestDataFile("weka/date.arff"));
            double[][] x = (double[][])data.toArray((E[])new double[data.size()][]);
            DateFeature.Type[] features = new DateFeature.Type[]{DateFeature.Type.YEAR, DateFeature.Type.MONTH, DateFeature.Type.DAY_OF_MONTH, DateFeature.Type.DAY_OF_WEEK, DateFeature.Type.HOURS, DateFeature.Type.MINUTES, DateFeature.Type.SECONDS};
            DateFeature df = new DateFeature(features);
            Attribute[] attributes = df.attributes();
            Assert.assertEquals(features.length, attributes.length);
            for (int i = 0; i < x.length; ++i) {
                double[] y = df.feature(((DateAttribute)data.attributes()[0]).toDate(x[i][0]));
                for (int j = 0; j < y.length; ++j) {
                    Assert.assertEquals(result[i][j], y[j], 1.0E-7);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

