/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.parser.IOUtils;
import smile.feature.Bag;

public class BagTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testUniquenessOfFeatures() {
        System.out.println("unique features");
        String[] featuresForBirdStories = new String[]{"crane", "sparrow", "hawk", "owl", "kiwi"};
        String[] featuresForBuildingStories = new String[]{"truck", "concrete", "foundation", "steel", "crane"};
        String testMessage = "This story is about a crane and a sparrow";
        ArrayList<String> mergedFeatureLists = new ArrayList<String>();
        mergedFeatureLists.addAll(Arrays.asList(featuresForBirdStories));
        mergedFeatureLists.addAll(Arrays.asList(featuresForBuildingStories));
        Bag<String> bag = new Bag<String>(mergedFeatureLists.toArray(new String[featuresForBirdStories.length + featuresForBuildingStories.length]));
        double[] result = bag.feature((T[])testMessage.split(" "));
        Assert.assertEquals(9L, result.length);
    }

    @Test
    public void testFeature() {
        System.out.println("feature");
        String[][] text = new String[2000][];
        try (BufferedReader input = IOUtils.getTestDataReader("text/movie.txt");){
            for (int i = 0; i < text.length; ++i) {
                String[] words = input.readLine().trim().split("\\s+");
                text[i] = words;
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        String[] feature = new String[]{"outstanding", "wonderfully", "wasted", "lame", "awful", "poorly", "ridiculous", "waste", "worst", "bland", "unfunny", "stupid", "dull", "fantastic", "laughable", "mess", "pointless", "terrific", "memorable", "superb", "boring", "badly", "subtle", "terrible", "excellent", "perfectly", "masterpiece", "realistic", "flaws"};
        Bag<String> bag = new Bag<String>(feature);
        double[][] x = new double[text.length][];
        for (int i = 0; i < text.length; ++i) {
            x[i] = bag.feature((T[])text[i]);
            Assert.assertEquals(feature.length, x[i].length);
        }
        Assert.assertEquals(1.0, x[0][15], 1.0E-7);
    }
}

