/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.vq;

import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.demo.vq.VQDemo;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;
import smile.vq.NeuralMap;

public class NeuralMapDemo
extends VQDemo {
    JTextField TNumberField = new JTextField(Double.toString(this.T), 5);
    double T = 20.0;

    public NeuralMapDemo() {
        this.optionPane.add(new JLabel("T:"));
        this.optionPane.add(this.TNumberField);
    }

    @Override
    public JComponent learn() {
        try {
            this.T = Double.parseDouble(this.TNumberField.getText().trim());
            if (this.T <= 0.0) {
                JOptionPane.showMessageDialog(this, "Invalid T: " + this.T, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid T: " + this.TNumberField.getText(), "Error", 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        NeuralMap cortex = new NeuralMap(2, this.T, 0.05, 6.0E-4, 5, 3);
        for (int i = 0; i < 5; ++i) {
            for (double[] x : dataset[datasetIndex]) {
                cortex.update(x);
            }
        }
        cortex.purge(16);
        cortex.partition(clusterNumber, 16);
        System.out.format("Cortex clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        int[] y = new int[dataset[datasetIndex].length];
        int[] clusterSize = new int[clusterNumber];
        for (int i = 0; i < dataset[datasetIndex].length; ++i) {
            y[i] = cortex.predict(dataset[datasetIndex][i]);
            if (y[i] == Integer.MAX_VALUE) continue;
            int n = y[i];
            clusterSize[n] = clusterSize[n] + 1;
        }
        List<NeuralMap.Neuron> nodes = cortex.neurons();
        double[][] x = new double[nodes.size()][];
        for (int i = 0; i < x.length; ++i) {
            x[i] = nodes.get((int)i).w;
        }
        PlotCanvas plot = ScatterPlot.plot((double[][])x, '@');
        for (int k = 0; k < clusterNumber; ++k) {
            if (clusterSize[k] <= 0) continue;
            double[][] cluster = new double[clusterSize[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (y[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        for (int i = 0; i < nodes.size(); ++i) {
            NeuralMap.Neuron neuron = nodes.get(i);
            for (NeuralMap.Neuron neighbor : neuron.neighbors) {
                plot.line((double[][])new double[][]{neuron.w, neighbor.w});
            }
        }
        plot.points((double[][])x, '@');
        return plot;
    }

    @Override
    public String toString() {
        return "Neural Map";
    }

    public static void main(String[] argv) {
        NeuralMapDemo demo = new NeuralMapDemo();
        JFrame f = new JFrame("Neural Map");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

