/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.vq;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.clustering.BIRCH;
import smile.demo.vq.VQDemo;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class BIRCHDemo
extends VQDemo {
    private static final String ERROR = "Error";
    JTextField BNumberField = new JTextField(Integer.toString(this.B), 5);
    int B = 5;
    JTextField TNumberField = new JTextField(Double.toString(this.T), 5);
    double T = 0.5;
    JTextField minPtsNumberField = new JTextField(Integer.toString(this.minPts), 5);
    int minPts = 5;

    public BIRCHDemo() {
        this.optionPane.add(new JLabel("B:"));
        this.optionPane.add(this.BNumberField);
        this.optionPane.add(new JLabel("T:"));
        this.optionPane.add(this.TNumberField);
        this.optionPane.add(new JLabel("minPts:"));
        this.optionPane.add(this.minPtsNumberField);
    }

    @Override
    public JComponent learn() {
        try {
            this.B = Integer.parseInt(this.BNumberField.getText().trim());
            if (this.B < 2) {
                JOptionPane.showMessageDialog(this, "Invalid B: " + this.B, ERROR, 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Invalid B: " + this.BNumberField.getText(), ERROR, 0);
            return null;
        }
        try {
            this.T = Double.parseDouble(this.TNumberField.getText().trim());
            if (this.T <= 0.0) {
                JOptionPane.showMessageDialog(this, "Invalid T: " + this.T, ERROR, 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid T: " + this.TNumberField.getText(), ERROR, 0);
            return null;
        }
        try {
            this.minPts = Integer.parseInt(this.minPtsNumberField.getText().trim());
            if (this.minPts < 0) {
                JOptionPane.showMessageDialog(this, "Invalid minPts: " + this.minPts, ERROR, 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid minPts: " + this.minPtsNumberField.getText(), ERROR, 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        BIRCH birch = new BIRCH(2, this.B, this.T);
        for (int i = 0; i < dataset[datasetIndex].length; ++i) {
            birch.add(dataset[datasetIndex][i]);
        }
        if (birch.partition(clusterNumber, this.minPts) < clusterNumber) {
            JOptionPane.showMessageDialog(this, "The number of non-outlier leaves is less than " + clusterNumber + ". Try larger T.", "ERROR", 0);
            return null;
        }
        int[] membership = new int[dataset[datasetIndex].length];
        int[] clusterSize = new int[clusterNumber];
        for (int i = 0; i < dataset[datasetIndex].length; ++i) {
            membership[i] = birch.predict(dataset[datasetIndex][i]);
            if (membership[i] == Integer.MAX_VALUE) continue;
            int n = membership[i];
            clusterSize[n] = clusterSize[n] + 1;
        }
        System.out.format("BIRCH clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        PlotCanvas plot = ScatterPlot.plot(birch.centroids(), '@');
        for (int k = 0; k < clusterNumber; ++k) {
            if (clusterSize[k] <= 0) continue;
            double[][] cluster = new double[clusterSize[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (membership[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        plot.points(birch.centroids(), '@');
        return plot;
    }

    @Override
    public String toString() {
        return "BIRCH";
    }

    public static void main(String[] argv) {
        BIRCHDemo demo = new BIRCHDemo();
        JFrame f = new JFrame("BIRCH");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

