/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smile.math.Math;
import smile.plot.Histogram;
import smile.plot.Line;
import smile.plot.LinePlot;
import smile.plot.PlotCanvas;
import smile.plot.QQPlot;
import smile.stat.distribution.WeibullDistribution;

public class WeibullDistributionDemo
extends JPanel
implements ChangeListener {
    private JPanel optionPane;
    private JPanel canvas;
    private PlotCanvas pdf;
    private PlotCanvas cdf;
    private PlotCanvas histogram;
    private PlotCanvas qqplot;
    private JSlider scaleSlider;
    private JSlider shapeSlider;
    private double scale = 2.0;
    private double shape = 3.0;

    public WeibullDistributionDemo() {
        super(new BorderLayout());
        Hashtable<Integer, JLabel> shapeLabelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 10; i += 2) {
            shapeLabelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.shapeSlider = new JSlider(0, 10, (int)Math.round(this.shape));
        this.shapeSlider.addChangeListener(this);
        this.shapeSlider.setLabelTable(shapeLabelTable);
        this.shapeSlider.setMajorTickSpacing(2);
        this.shapeSlider.setMinorTickSpacing(1);
        this.shapeSlider.setPaintTicks(true);
        this.shapeSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> scaleLabelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 50; i += 10) {
            scaleLabelTable.put(new Integer(i), new JLabel(String.valueOf(i / 10)));
        }
        this.scaleSlider = new JSlider(0, 50, (int)Math.round(this.scale * 10.0));
        this.scaleSlider.addChangeListener(this);
        this.scaleSlider.setLabelTable(scaleLabelTable);
        this.scaleSlider.setMajorTickSpacing(10);
        this.scaleSlider.setMinorTickSpacing(2);
        this.scaleSlider.setPaintTicks(true);
        this.scaleSlider.setPaintLabels(true);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(new JLabel("Shape:"));
        this.optionPane.add(this.shapeSlider);
        this.optionPane.add(new JLabel("Scale:"));
        this.optionPane.add(this.scaleSlider);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(2, 2));
        this.add((Component)this.canvas, "Center");
        WeibullDistribution dist = new WeibullDistribution(this.shape, this.scale);
        double[][] p = new double[100][2];
        double[][] q = new double[100][2];
        for (int i = 0; i < p.length; ++i) {
            p[i][0] = (double)i / 20.0;
            p[i][1] = dist.p(p[i][0]);
            q[i][0] = (double)i / 20.0;
            q[i][1] = dist.cdf(p[i][0]);
        }
        this.pdf = LinePlot.plot(p, Line.Style.SOLID, Color.BLUE);
        this.pdf.setTitle("PDF");
        this.canvas.add(this.pdf);
        this.cdf = LinePlot.plot(q, Line.Style.SOLID, Color.BLUE);
        this.cdf.setTitle("CDF");
        this.canvas.add(this.cdf);
        double[] data = new double[500];
        for (int i = 0; i < data.length; ++i) {
            data[i] = dist.rand();
        }
        this.histogram = Histogram.plot(data, 20);
        this.histogram.setTitle("Histogram");
        this.canvas.add(this.histogram);
        this.qqplot = QQPlot.plot(data, dist);
        this.qqplot.setTitle("Q-Q Plot");
        this.canvas.add(this.qqplot);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.scaleSlider || e.getSource() == this.shapeSlider) {
            this.scale = (double)this.scaleSlider.getValue() / 10.0;
            this.shape = this.shapeSlider.getValue();
            if (this.scale == 0.0) {
                this.scale = 0.01;
            }
            if (this.shape == 0.0) {
                this.shape = 0.01;
            }
            WeibullDistribution dist = new WeibullDistribution(this.shape, this.scale);
            double[][] p = new double[100][2];
            double[][] q = new double[100][2];
            for (int i = 0; i < p.length; ++i) {
                p[i][0] = (double)i / 20.0;
                p[i][1] = dist.p(p[i][0]);
                q[i][0] = (double)i / 20.0;
                q[i][1] = dist.cdf(p[i][0]);
            }
            this.pdf.clear();
            this.pdf.line(p, Line.Style.SOLID, Color.BLUE);
            this.cdf.clear();
            this.cdf.line(q, Line.Style.SOLID, Color.BLUE);
            double[] data = new double[500];
            for (int i = 0; i < data.length; ++i) {
                data[i] = dist.rand();
            }
            this.histogram.clear();
            this.histogram.histogram(data, 20, Color.BLUE);
            this.qqplot.clear();
            this.qqplot.add(new QQPlot(data, dist));
            this.canvas.repaint();
        }
    }

    @Override
    public String toString() {
        return "Weibull";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Weibull Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new WeibullDistributionDemo());
        frame.setVisible(true);
    }
}

