/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smile.plot.BarPlot;
import smile.plot.Histogram;
import smile.plot.PlotCanvas;
import smile.stat.distribution.HyperGeometricDistribution;

public class HyperGeometricDistributionDemo
extends JPanel
implements ChangeListener {
    private JPanel optionPane;
    private JPanel canvas;
    private PlotCanvas pdf;
    private PlotCanvas cdf;
    private PlotCanvas histogram;
    private JSlider mSlider;
    private JSlider nSlider;
    private int N = 100;
    private int m = 50;
    private int n = 10;

    public HyperGeometricDistributionDemo() {
        super(new BorderLayout());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(1, new JLabel(String.valueOf(1)));
        for (int i = 20; i <= 100; i += 20) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.mSlider = new JSlider(1, 100, this.m);
        this.mSlider.addChangeListener(this);
        this.mSlider.setLabelTable(labelTable);
        this.mSlider.setMajorTickSpacing(20);
        this.mSlider.setMinorTickSpacing(5);
        this.mSlider.setPaintTicks(true);
        this.mSlider.setPaintLabels(true);
        this.nSlider = new JSlider(0, 100, this.n);
        this.nSlider.addChangeListener(this);
        this.nSlider.setLabelTable(labelTable);
        this.nSlider.setMajorTickSpacing(20);
        this.nSlider.setMinorTickSpacing(5);
        this.nSlider.setPaintTicks(true);
        this.nSlider.setPaintLabels(true);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(new JLabel("m:"));
        this.optionPane.add(this.mSlider);
        this.optionPane.add(new JLabel("n:"));
        this.optionPane.add(this.nSlider);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(1, 3));
        this.add((Component)this.canvas, "Center");
        HyperGeometricDistribution dist = new HyperGeometricDistribution(this.N, this.m, this.n);
        double[][] p = new double[50][2];
        double[][] q = new double[50][2];
        for (int i = 0; i < p.length; ++i) {
            p[i][0] = i;
            p[i][1] = dist.p(p[i][0]);
            q[i][0] = i;
            q[i][1] = dist.cdf(p[i][0]);
        }
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{50.0, 1.0};
        this.pdf = new PlotCanvas(lowerBound, upperBound);
        this.pdf.add(new BarPlot(p));
        this.pdf.setTitle("PDF");
        this.canvas.add(this.pdf);
        this.cdf = new PlotCanvas(lowerBound, upperBound);
        this.cdf.staircase(q, Color.BLACK);
        this.cdf.setTitle("CDF");
        this.canvas.add(this.cdf);
        int[] data = new int[500];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (int)dist.rand();
        }
        this.histogram = Histogram.plot(data, 10);
        this.histogram.setTitle("Histogram");
        this.canvas.add(this.histogram);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.mSlider || e.getSource() == this.nSlider) {
            this.m = this.mSlider.getValue();
            this.n = this.nSlider.getValue();
            HyperGeometricDistribution dist = new HyperGeometricDistribution(this.N, this.m, this.n);
            double[][] p = new double[50][2];
            double[][] q = new double[50][2];
            for (int i = 0; i < p.length; ++i) {
                p[i][0] = i;
                p[i][1] = dist.p(p[i][0]);
                q[i][0] = i;
                q[i][1] = dist.cdf(p[i][0]);
            }
            this.pdf.clear();
            this.pdf.add(new BarPlot(p));
            this.cdf.clear();
            this.cdf.staircase(q, Color.BLACK);
            int[] data = new int[500];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (int)dist.rand();
            }
            this.histogram.clear();
            this.histogram.histogram(data, 10, Color.BLUE);
        }
    }

    @Override
    public String toString() {
        return "Hypergeometric";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Hyper Geometric Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new HyperGeometricDistributionDemo());
        frame.setVisible(true);
    }
}

