/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smile.plot.BarPlot;
import smile.plot.Histogram;
import smile.plot.PlotCanvas;
import smile.stat.distribution.BernoulliDistribution;

public class BernoulliDistributionDemo
extends JPanel
implements ChangeListener {
    private JPanel optionPane;
    private JPanel canvas;
    private PlotCanvas pdf;
    private PlotCanvas cdf;
    private PlotCanvas histogram;
    private JSlider probSlider;
    private double prob = 0.3;

    public BernoulliDistributionDemo() {
        super(new BorderLayout());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 1; i < 10; i += 2) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf((double)i / 10.0)));
        }
        this.probSlider = new JSlider(1, 9, (int)Math.round(this.prob * 10.0));
        this.probSlider.addChangeListener(this);
        this.probSlider.setLabelTable(labelTable);
        this.probSlider.setMajorTickSpacing(5);
        this.probSlider.setMinorTickSpacing(1);
        this.probSlider.setPaintTicks(true);
        this.probSlider.setPaintLabels(true);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(new JLabel("Probability:"));
        this.optionPane.add(this.probSlider);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(1, 3));
        this.add((Component)this.canvas, "Center");
        BernoulliDistribution dist = new BernoulliDistribution(this.prob);
        double[][] p = new double[2][2];
        double[][] q = new double[2][2];
        for (int i = 0; i < p.length; ++i) {
            p[i][0] = i;
            p[i][1] = dist.p(p[i][0]);
            q[i][0] = i;
            q[i][1] = dist.cdf(p[i][0]);
        }
        double[] lowerBound = new double[]{0.0, 0.0};
        double[] upperBound = new double[]{1.0, 1.0};
        this.pdf = new PlotCanvas(lowerBound, upperBound);
        this.pdf.add(new BarPlot(p));
        this.pdf.setTitle("PDF");
        this.canvas.add(this.pdf);
        this.cdf = new PlotCanvas(lowerBound, upperBound);
        this.cdf.staircase(q, Color.BLACK);
        this.cdf.setTitle("CDF");
        this.canvas.add(this.cdf);
        double[] data = new double[500];
        for (int i = 0; i < data.length; ++i) {
            data[i] = dist.rand();
        }
        this.histogram = Histogram.plot(data, 2);
        this.histogram.setTitle("Histogram");
        this.canvas.add(this.histogram);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.probSlider) {
            this.prob = (double)this.probSlider.getValue() / 10.0;
            BernoulliDistribution dist = new BernoulliDistribution(this.prob);
            double[][] p = new double[2][2];
            double[][] q = new double[2][2];
            for (int i = 0; i < p.length; ++i) {
                p[i][0] = i;
                p[i][1] = dist.p(p[i][0]);
                q[i][0] = i;
                q[i][1] = dist.cdf(p[i][0]);
            }
            this.pdf.clear();
            this.pdf.add(new BarPlot(p));
            this.cdf.clear();
            this.cdf.staircase(q, Color.BLACK);
            double[] data = new double[500];
            for (int i = 0; i < data.length; ++i) {
                data[i] = dist.rand();
            }
            this.histogram.clear();
            this.histogram.histogram(data, 2, Color.BLUE);
        }
    }

    @Override
    public String toString() {
        return "Bernoulli";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Bernoulli Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new BernoulliDistributionDemo());
        frame.setVisible(true);
    }
}

