/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.projection;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.demo.projection.ProjectionDemo;
import smile.math.Math;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.projection.PCA;
import smile.projection.PPCA;

public class PPCADemo
extends ProjectionDemo {
    @Override
    public JComponent learn() {
        int i;
        int i2;
        int[] labels;
        JPanel pane = new JPanel(new GridLayout(2, 2));
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        String[] names = dataset[datasetIndex].toArray(new String[dataset[datasetIndex].size()]);
        if (names[0] == null) {
            names = null;
        }
        long clock = System.currentTimeMillis();
        PCA pca = new PCA(data, true);
        System.out.format("Learn PCA from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        pca.setProjection(2);
        double[][] y = pca.project(data);
        PlotCanvas plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            labels = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (i2 = 0; i2 < y.length; ++i2) {
                plot.point(this.pointLegend, Palette.COLORS[labels[i2]], y[i2]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("PCA");
        pane.add(plot);
        pca.setProjection(3);
        y = pca.project(data);
        plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            labels = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (i2 = 0; i2 < y.length; ++i2) {
                plot.point(this.pointLegend, Palette.COLORS[labels[i2]], y[i2]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("PCA");
        pane.add(plot);
        PPCA ppca = new PPCA(data, 2);
        y = ppca.project(data);
        plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            int[] labels2 = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (i = 0; i < y.length; ++i) {
                plot.point(this.pointLegend, Palette.COLORS[labels2[i]], y[i]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("PPCA");
        pane.add(plot);
        clock = System.currentTimeMillis();
        ppca = new PPCA(data, 3);
        System.out.format("Learn PPCA from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        y = ppca.project(data);
        plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            int[] labels3 = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (i = 0; i < y.length; ++i) {
                plot.point(this.pointLegend, Palette.COLORS[labels3[i]], y[i]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("PPCA");
        pane.add(plot);
        return pane;
    }

    @Override
    public String toString() {
        return "Probabilistic Principal Component Analysis";
    }

    public static void main(String[] argv) {
        PPCADemo demo = new PPCADemo();
        JFrame f = new JFrame("Probabilistic Principal Component Analysis");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

