/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.plot;

import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.data.parser.IOUtils;
import smile.data.parser.SparseMatrixParser;
import smile.math.matrix.SparseMatrix;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.SparseMatrixPlot;

public class SparseMatrixPlotDemo
extends JPanel {
    public SparseMatrixPlotDemo() {
        super(new GridLayout(1, 2));
        SparseMatrixParser parser = new SparseMatrixParser();
        try {
            SparseMatrix m1 = parser.parse(IOUtils.getTestDataFile("matrix/08blocks.txt"));
            PlotCanvas canvas = SparseMatrixPlot.plot(m1);
            canvas.setTitle("08blocks");
            this.add(canvas);
            SparseMatrix m2 = parser.parse(IOUtils.getTestDataFile("matrix/mesh2em5.txt"));
            canvas = SparseMatrixPlot.plot(m2, Palette.jet(256));
            canvas.setTitle("mesh2em5");
            this.add(canvas);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Override
    public String toString() {
        return "Sparse Matrix Plot";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Surface Plot");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new SparseMatrixPlotDemo());
        frame.setVisible(true);
    }
}

