/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.neighbor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import smile.math.Math;
import smile.math.distance.EuclideanDistance;
import smile.neighbor.CoverTree;
import smile.neighbor.KDTree;
import smile.neighbor.LSH;
import smile.neighbor.LinearSearch;
import smile.neighbor.MPLSH;
import smile.neighbor.Neighbor;
import smile.plot.BarPlot;
import smile.plot.PlotCanvas;

public class NearestNeighborDemo
extends JPanel
implements Runnable,
ActionListener {
    private String[] label = new String[]{"Naive", "KD-Tree", "Cover Tree", "LSH", "MPLSH"};
    private JPanel optionPane;
    private JPanel canvas;
    private JButton startButton = new JButton("Start");
    private JSlider logNSlider;
    private JSlider dimensionSlider;
    private int logN = 4;
    private int dimension = 10;

    public NearestNeighborDemo() {
        super(new BorderLayout());
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        Hashtable<Integer, JLabel> logNLabelTable = new Hashtable<Integer, JLabel>();
        for (int i = 3; i <= 7; ++i) {
            logNLabelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.logNSlider = new JSlider(3, 7, this.logN);
        this.logNSlider.setLabelTable(logNLabelTable);
        this.logNSlider.setMajorTickSpacing(1);
        this.logNSlider.setPaintTicks(true);
        this.logNSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> dimensionLabelTable = new Hashtable<Integer, JLabel>();
        dimensionLabelTable.put(new Integer(2), new JLabel(String.valueOf(2)));
        for (int i = 20; i <= 120; i += 20) {
            dimensionLabelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.dimensionSlider = new JSlider(2, 128, this.dimension);
        this.dimensionSlider.setLabelTable(dimensionLabelTable);
        this.dimensionSlider.setMajorTickSpacing(20);
        this.dimensionSlider.setMinorTickSpacing(5);
        this.dimensionSlider.setPaintTicks(true);
        this.dimensionSlider.setPaintLabels(true);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("log N:"));
        this.optionPane.add(this.logNSlider);
        this.optionPane.add(new JLabel("Dimension:"));
        this.optionPane.add(this.dimensionSlider);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(1, 2));
        this.canvas.setBackground(Color.WHITE);
        this.add((Component)this.canvas, "Center");
    }

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.logNSlider.setEnabled(false);
        this.dimensionSlider.setEnabled(false);
        this.logN = this.logNSlider.getValue();
        this.dimension = this.dimensionSlider.getValue();
        System.out.println("Generating dataset...");
        int n = (int)Math.pow(10.0, (double)this.logN);
        double[][] data = new double[n][];
        for (int i = 0; i < n; ++i) {
            data[i] = new double[this.dimension];
            for (int j = 0; j < this.dimension; ++j) {
                data[i][j] = Math.random();
            }
        }
        int[] perm = Math.permutate(n);
        System.out.println("Building searching data structure...");
        long time = System.currentTimeMillis();
        LinearSearch<double[]> naive = new LinearSearch<double[]>(data, new EuclideanDistance());
        int naiveBuild = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        KDTree<double[]> kdtree = new KDTree<double[]>(data, (E[])data);
        int kdtreeBuild = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        CoverTree<double[]> cover = new CoverTree<double[]>(data, new EuclideanDistance());
        int coverBuild = (int)(System.currentTimeMillis() - time);
        System.out.println("Perform 100 searches...");
        int[] answer = new int[100];
        double radius = 0.0;
        time = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            Neighbor<double[], double[]> neighbor = naive.nearest(data[perm[i]]);
            answer[i] = neighbor.index;
            radius += neighbor.distance;
        }
        int naiveSearch = (int)(System.currentTimeMillis() - time);
        radius /= 100.0;
        time = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            kdtree.nearest(data[perm[i]]);
        }
        int kdtreeSearch = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            cover.nearest(data[perm[i]]);
        }
        int coverSearch = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        LSH<double[]> lsh = new LSH<double[]>(this.dimension, 5, (int)Math.ceil(Math.log2(this.dimension)), 4.0 * radius, 1017881);
        for (int i = 0; i < n; ++i) {
            lsh.put(data[i], data[i]);
        }
        int lshBuild = (int)(System.currentTimeMillis() - time);
        double lshRecall = 0.0;
        time = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            if (lsh.nearest((double[])data[perm[i]]).index != answer[i]) continue;
            lshRecall += 1.0;
        }
        int lshSearch = (int)(System.currentTimeMillis() - time);
        System.out.format("The recall of LSH is %.1f%%\n", (lshRecall /= 100.0) * 100.0);
        time = System.currentTimeMillis();
        MPLSH<double[]> mplsh = new MPLSH<double[]>(this.dimension, 5, (int)Math.ceil(Math.log2(n)), 4.0 * radius, 1017881);
        for (int i = 0; i < n; ++i) {
            mplsh.put(data[i], data[i]);
        }
        double[][] train = new double[1000][];
        for (int i = 0; i < train.length; ++i) {
            train[i] = data[perm[i]];
        }
        mplsh.learn(kdtree, train, 1.5 * radius);
        int mplshBuild = (int)(System.currentTimeMillis() - time);
        double mplshRecall = 0.0;
        time = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            if (mplsh.nearest((double[])data[perm[i]], (double)0.95, (int)10).index != answer[i]) continue;
            mplshRecall += 1.0;
        }
        int mplshSearch = (int)(System.currentTimeMillis() - time);
        System.out.format("The recall of MPLSH is %.1f%%\n", (mplshRecall /= 100.0) * 100.0);
        this.canvas.removeAll();
        double[] buildTime = new double[]{naiveBuild, kdtreeBuild, coverBuild, lshBuild, mplshBuild};
        PlotCanvas build = BarPlot.plot(buildTime, this.label);
        build.setTitle("Build Time");
        this.canvas.add(build);
        double[] searchTime = new double[]{naiveSearch, kdtreeSearch, coverSearch, lshSearch, mplshSearch};
        PlotCanvas search = BarPlot.plot(searchTime, this.label);
        search.setTitle("Search Time");
        this.canvas.add(search);
        this.validate();
        this.startButton.setEnabled(true);
        this.logNSlider.setEnabled(true);
        this.dimensionSlider.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public String toString() {
        return "Nearest Neighbor";
    }

    public static void main(String[] argv) {
        NearestNeighborDemo demo = new NearestNeighborDemo();
        JFrame f = new JFrame("Nearest Neighbor");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

