/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.neighbor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.math.distance.EditDistance;
import smile.neighbor.BKTree;
import smile.neighbor.CoverTree;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;
import smile.plot.BarPlot;
import smile.plot.PlotCanvas;

public class ApproximateStringSearchDemo
extends JPanel
implements Runnable,
ActionListener {
    private String[] label = new String[]{"Naive", "BK-Tree", "Cover Tree"};
    private JPanel optionPane;
    private JPanel canvas;
    private JButton startButton = new JButton("Start");
    private JTextField knnField;
    private int knn = 1;
    private String[] data;
    private BKTree<String> bktree;
    private CoverTree<String> cover;
    private LinearSearch<String> naive;

    public ApproximateStringSearchDemo() {
        super(new BorderLayout());
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        this.knnField = new JTextField(Integer.toString(this.knn), 5);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("K:"));
        this.optionPane.add(this.knnField);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(1, 2));
        this.canvas.setBackground(Color.WHITE);
        this.add((Component)this.canvas, "Center");
    }

    @Override
    public void run() {
        long time;
        this.startButton.setEnabled(false);
        this.knnField.setEnabled(false);
        if (this.data == null) {
            System.out.print("Loading dataset...");
            ArrayList<String> words = new ArrayList<String>();
            try {
                FileInputStream stream = new FileInputStream(IOUtils.getTestDataFile("index.noun"));
                BufferedReader input = new BufferedReader(new InputStreamReader(stream));
                String line = input.readLine();
                while (line != null) {
                    if (!line.startsWith(" ")) {
                        String[] w = line.split("\\s");
                        words.add(w[0].replace('_', ' '));
                    }
                    line = input.readLine();
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
            this.data = words.toArray(new String[1]);
            System.out.println(words.size() + " words");
            System.out.println("Building searching data structure...");
            time = System.currentTimeMillis();
            this.naive = new LinearSearch<String>(this.data, new EditDistance(50, true));
            int naiveBuild = (int)(System.currentTimeMillis() - time) / 1000;
            time = System.currentTimeMillis();
            this.bktree = new BKTree<String>(new EditDistance(50, true));
            this.bktree.add((String)this.data);
            int bktreeBuild = (int)(System.currentTimeMillis() - time) / 1000;
            time = System.currentTimeMillis();
            this.cover = new CoverTree<String>(this.data, new EditDistance(50, true));
            int coverBuild = (int)(System.currentTimeMillis() - time) / 1000;
            double[] buildTime = new double[]{naiveBuild, bktreeBuild, coverBuild};
            PlotCanvas build = BarPlot.plot(buildTime, this.label);
            build.setTitle("Build Time");
            this.canvas.add(build);
            this.validate();
        }
        int[] perm = Math.permutate(this.data.length);
        System.out.println("Perform 1000 searches...");
        time = System.currentTimeMillis();
        ArrayList neighbors = new ArrayList();
        for (int i = 0; i < 1000; ++i) {
            this.naive.range(this.data[perm[i]], (double)this.knn, neighbors);
            neighbors.clear();
        }
        int naiveSearch = (int)(System.currentTimeMillis() - time) / 1000;
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            this.bktree.range(this.data[perm[i]], this.knn, (List<Neighbor<String, String>>)neighbors);
            neighbors.clear();
        }
        int kdtreeSearch = (int)(System.currentTimeMillis() - time) / 1000;
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            this.cover.range(this.data[perm[i]], (double)this.knn, neighbors);
            neighbors.clear();
        }
        int coverSearch = (int)(System.currentTimeMillis() - time) / 1000;
        double[] searchTime = new double[]{naiveSearch, kdtreeSearch, coverSearch};
        PlotCanvas search = BarPlot.plot(searchTime, this.label);
        search.setTitle("Search Time of k = " + this.knn);
        this.canvas.add(search);
        if (this.canvas.getComponentCount() > 3) {
            this.canvas.setLayout(new GridLayout(2, 2));
        }
        this.validate();
        this.startButton.setEnabled(true);
        this.knnField.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            try {
                this.knn = Integer.parseInt(this.knnField.getText().trim());
                if (this.knn < 1) {
                    JOptionPane.showMessageDialog(this, "Invalid K: " + this.knn, "Error", 0);
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid K: " + this.knnField.getText(), "Error", 0);
                return;
            }
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public String toString() {
        return "Approximate String Search";
    }

    public static void main(String[] argv) {
        ApproximateStringSearchDemo demo = new ApproximateStringSearchDemo();
        JFrame f = new JFrame("Approximate String Search");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

