/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.interpolation;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.interpolation.BicubicInterpolation;
import smile.interpolation.LaplaceInterpolation;
import smile.plot.Heatmap;
import smile.plot.Palette;
import smile.plot.PlotCanvas;

public class LaplaceInterpolationDemo
extends JPanel {
    public LaplaceInterpolationDemo() {
        super(new GridLayout(2, 2));
        this.setBackground(Color.WHITE);
        double[] x1 = new double[]{0.0, 1.0, 2.0, 3.0};
        double[] x2 = new double[]{0.0, 1.0, 2.0, 3.0};
        double[][] y = new double[][]{{1.0, 2.0, 4.0, 1.0}, {6.0, 3.0, 5.0, 2.0}, {4.0, 2.0, 1.0, 5.0}, {5.0, 4.0, 2.0, 3.0}};
        BicubicInterpolation bicubic = new BicubicInterpolation(x1, x2, y);
        double[][] yy = new double[101][101];
        for (int i = 0; i <= 100; ++i) {
            for (int j = 0; j <= 100; ++j) {
                yy[i][j] = bicubic.interpolate((double)i * 0.03, (double)j * 0.03);
            }
        }
        PlotCanvas canvas = Heatmap.plot(yy, Palette.jet(256));
        canvas.setTitle("Original");
        this.add(canvas);
        double[][] zz = new double[101][101];
        double[][] ww = new double[101][101];
        for (int i = 0; i <= 100; ++i) {
            for (int j = 0; j <= 100; ++j) {
                zz[i][j] = Math.random() < 0.2 ? Double.NaN : yy[i][j];
                ww[i][j] = zz[i][j];
            }
        }
        canvas = Heatmap.plot(ww, Palette.jet(256));
        canvas.setTitle("Missing Values");
        this.add(canvas);
        LaplaceInterpolation.interpolate(zz);
        canvas = Heatmap.plot(zz, Palette.jet(256));
        canvas.setTitle("Laplace");
        this.add(canvas);
    }

    @Override
    public String toString() {
        return "Laplace";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Laplace Interpolation");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new LaplaceInterpolationDemo());
        frame.setVisible(true);
    }
}

