/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.interpolation;

import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.interpolation.BicubicInterpolation;
import smile.interpolation.BilinearInterpolation;
import smile.interpolation.CubicSplineInterpolation2D;
import smile.plot.Heatmap;
import smile.plot.Palette;
import smile.plot.PlotCanvas;

public class Interpolation2Demo
extends JPanel {
    public Interpolation2Demo() {
        super(new GridLayout(2, 2));
        double[] x1 = new double[]{0.0, 1.0, 2.0, 3.0};
        double[] x2 = new double[]{0.0, 1.0, 2.0, 3.0};
        double[][] y = new double[][]{{1.0, 2.0, 4.0, 1.0}, {6.0, 3.0, 5.0, 2.0}, {4.0, 2.0, 1.0, 5.0}, {5.0, 4.0, 2.0, 3.0}};
        PlotCanvas canvas = Heatmap.plot(y, Palette.jet(256));
        canvas.setTitle("Original");
        this.add(canvas);
        BicubicInterpolation bicubic = new BicubicInterpolation(x1, x2, y);
        double[][] yy = new double[101][101];
        for (int i = 0; i <= 100; ++i) {
            for (int j = 0; j <= 100; ++j) {
                yy[i][j] = bicubic.interpolate((double)i * 0.03, (double)j * 0.03);
            }
        }
        canvas = Heatmap.plot(yy, Palette.jet(256));
        canvas.setTitle("Bicubic");
        this.add(canvas);
        BilinearInterpolation bilinear = new BilinearInterpolation(x1, x2, y);
        double[][] zz = new double[101][101];
        for (int i = 0; i <= 100; ++i) {
            for (int j = 0; j <= 100; ++j) {
                zz[i][j] = bilinear.interpolate((double)i * 0.03, (double)j * 0.03);
            }
        }
        canvas = Heatmap.plot(zz, Palette.jet(256));
        canvas.setTitle("Blinear");
        this.add(canvas);
        CubicSplineInterpolation2D spline = new CubicSplineInterpolation2D(x1, x2, y);
        double[][] ww = new double[101][101];
        for (int i = 0; i <= 100; ++i) {
            for (int j = 0; j <= 100; ++j) {
                ww[i][j] = spline.interpolate((double)i * 0.03, (double)j * 0.03);
            }
        }
        canvas = Heatmap.plot(ww, Palette.jet(256));
        canvas.setTitle("Cubic Spline");
        this.add(canvas);
    }

    @Override
    public String toString() {
        return "2D";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Interpolation 2D");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new Interpolation2Demo());
        frame.setVisible(true);
    }
}

