/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.data.classification;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import smile.math.Math;
import smile.stat.distribution.MultivariateGaussianDistribution;

public class ToyData {
    private int k = 10;
    private double[] prob = new double[this.k];
    private double[][] m;
    private double[] m1 = new double[]{0.0, 1.0};
    private double[] m2 = new double[]{1.0, 0.0};
    private double[] var = new double[]{1.0, 1.0};
    private double[] v = new double[]{0.2, 0.2};

    public ToyData() {
        int i;
        for (int i2 = 0; i2 < this.k; ++i2) {
            this.prob[i2] = 1.0 / (double)this.k;
        }
        this.m = new double[2 * this.k][];
        MultivariateGaussianDistribution gauss = new MultivariateGaussianDistribution(this.m1, this.var);
        for (i = 0; i < this.k; ++i) {
            this.m[i] = gauss.rand();
        }
        gauss = new MultivariateGaussianDistribution(this.m2, this.var);
        for (i = 0; i < this.k; ++i) {
            this.m[this.k + i] = gauss.rand();
        }
    }

    public double[][] sample(int n) {
        int i;
        double[][] samples = new double[2 * n][];
        MultivariateGaussianDistribution[] gauss = new MultivariateGaussianDistribution[this.k];
        for (i = 0; i < this.k; ++i) {
            gauss[i] = new MultivariateGaussianDistribution(this.m[i], this.v);
        }
        for (i = 0; i < n; ++i) {
            samples[i] = gauss[Math.random(this.prob)].rand();
        }
        for (i = 0; i < this.k; ++i) {
            gauss[i] = new MultivariateGaussianDistribution(this.m[this.k + i], this.v);
        }
        for (i = 0; i < n; ++i) {
            samples[n + i] = gauss[Math.random(this.prob)].rand();
        }
        return samples;
    }

    public static void main(String[] argv) {
        int label;
        int i2;
        Throwable throwable;
        PrintStream p;
        ToyData toy = new ToyData();
        int n = 100;
        double[][] s = toy.sample(n);
        try {
            p = new PrintStream(new FileOutputStream("toy-train.txt"));
            throwable = null;
            try {
                for (i2 = 0; i2 < s.length; ++i2) {
                    label = i2 / n;
                    p.format("%d\t% .4f\t% .4f\n", label, s[i2][0], s[i2][1]);
                }
            }
            catch (Throwable i2) {
                throwable = i2;
                throw i2;
            }
            finally {
                if (p != null) {
                    if (throwable != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable i2) {
                            throwable.addSuppressed(i2);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        n = 10000;
        s = toy.sample(n);
        try {
            p = new PrintStream(new FileOutputStream("toy-test.txt"));
            throwable = null;
            try {
                for (i2 = 0; i2 < s.length; ++i2) {
                    label = i2 / n;
                    p.format("%d\t% .4f\t% .4f\n", label, s[i2][0], s[i2][1]);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (p != null) {
                    if (throwable != null) {
                        try {
                            p.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        p.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

