/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.clustering.SpectralClustering;
import smile.demo.clustering.ClusteringDemo;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class SpectralClusteringDemo
extends ClusteringDemo {
    JTextField gaussianWidthField = new JTextField(Double.toString(this.gaussianWidth), 5);
    double gaussianWidth = 1.0;

    public SpectralClusteringDemo() {
        this.optionPane.add(new JLabel("Width:"));
        this.optionPane.add(this.gaussianWidthField);
    }

    @Override
    public JComponent learn() {
        try {
            this.gaussianWidth = Double.parseDouble(this.gaussianWidthField.getText().trim());
            if (this.gaussianWidth <= 0.0) {
                JOptionPane.showMessageDialog(this, "Invalid Gaussian Width: " + this.gaussianWidth, "Error", 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid Gaussian Width: " + this.gaussianWidthField.getText(), "Error", 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        SpectralClustering spectral = new SpectralClustering(dataset[datasetIndex], clusterNumber, this.gaussianWidth);
        System.out.format("Spectral Clustering clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        PlotCanvas plot = ScatterPlot.plot(dataset[datasetIndex], this.pointLegend);
        for (int k = 0; k < spectral.getNumClusters(); ++k) {
            double[][] cluster = new double[spectral.getClusterSize()[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (spectral.getClusterLabel()[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        return plot;
    }

    @Override
    public String toString() {
        return "Spectral Clustering";
    }

    public static void main(String[] argv) {
        SpectralClusteringDemo demo = new SpectralClusteringDemo();
        JFrame f = new JFrame("Spectral Clustering");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

